
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */


%  Hofstader's mu math (mutest) proving muiiu
%	from Godel Escher Bach

main :- theorem(5,[m,u,i,i,u]).

rules(S, R) :- rule3(S,R).
rules(S, R) :- rule4(S,R).
rules(S, R) :- rule1(S,R).
rules(S, R) :- rule2(S,R).

rule1(S,R) :-
	append(X, [i], S),
	append(X, [i,u], R).

rule2([m | T], [m | R]) :- append(T, T, R).

rule3([], -) :- fail.
rule3(R, T) :-
	append([i,i,i], S, R),
	append([u], S, T).
rule3([H | T], [H | R]) :- rule3(T, R).

rule4([], -) :- fail.
rule4(R, T) :- append([u, u], T, R).
rule4([H | T], [H | R]) :- rule4(T, R).

theorem(Depth, [m, i]).
theorem(Depth, []) :- fail.

theorem(Depth, R) :-
	Depth > 0,
	D is Depth - 1,
	theorem(D, S),
	rules(S, R).

append([], X, X).
append([A | B], X, [A | B1]) :-
	!,
	append(B, X, B1).

