/* $Id: printwin.c,v 1.2 90/05/09 22:11:24 pturner Exp Locker: pturner $
 *
 * Printer initialization
 */

#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/frame.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include "globals.h"
#include "defines.h"

void cancel_ok();		/* defined in statuswin.c */

extern Frame main_frame;	/* defined in grtool.c */
extern Pixfont *winfont;
extern int hpgl_loaded;

static Panel_item printto_item;	/* for printer select popup */
static Panel_item printstring_item;


int ptofile = 0;		/* flag to indicate destination of hardcopy
				 * output, ptofile = 0 means print to printer
				 * non-zero print to file */
char printstr[128] = "pout.dat";/* hardcopy to this file */

/* printer definition strings defined in the drivers */
extern char hp_prstr1[];	/* HP plotter defined in hp.c */
extern char hp_prstr2[];	/* HPGL in HP Laserjet II defined in hp.c */
extern char ps_prstr[];		/* PostScript defined in ps.c */
extern char hplj_prstr[];	/* HP LJ series II defined in hplj.c */
char noprint[] = "No printer installed";

setprstring(hdevice)
    int hdevice;
{
    switch (hdevice) {
    case 1:
    case 2:
    case 3:
    case 4:
	curprint = hp_prstr1;
	break;
    case 5:
    case 6:
	curprint = ps_prstr;
	break;
    case 7:
    case 8:
	curprint = hp_prstr2;
	break;
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
	curprint = hplj_prstr;
	break;
    default:
	curprint = noprint;
	break;
    }
}

/*
 * set the print options
 */
void do_prstr_toggle(item, value, event)
    Panel_item item;
    Event *event;
    int value;
{
    setprstring(value + 1);
    if ((int) panel_get_value(printto_item) == 0) {
	panel_set_value(printstring_item, curprint);
    }
}

void do_pr_toggle(item, value, event)
    Panel_item item;
    Event *event;
    int value;
{
    if (value) {
	panel_set(printstring_item, PANEL_LABEL_STRING, "Print to file:", 0);
	panel_set_value(printstring_item, printstr);
    } else {
	panel_set(printstring_item, PANEL_LABEL_STRING, "Printer control string:", 0);
	panel_set_value(printstring_item, curprint);
    }
}

printer_setup()
{
    Frame psetup_frame;
    Panel psetup_panel;
    Panel_item devices_item;
    int status;
    char tmpstr[128];

    psetup_frame = window_create(main_frame, FRAME,
				 WIN_Y, 50,
				 WIN_X, 50,
				 WIN_FONT, winfont,
				 FRAME_SHOW_LABEL, FALSE,
				 FRAME_NO_CONFIRM, TRUE,
			      WIN_ERROR_MSG, "Couldn't create psetup_frame",
				 0);
    psetup_panel = window_create(psetup_frame, PANEL,
				 WIN_FONT, winfont,
				 0);
    devices_item = panel_create_item(psetup_panel, PANEL_CYCLE,
				     PANEL_LABEL_STRING, "Device:",
				     PANEL_ITEM_X, ATTR_COL(1),
				     PANEL_ITEM_Y, ATTR_ROW(0),
				     PANEL_NOTIFY_PROC,
				     do_prstr_toggle,
				     PANEL_CHOICE_STRINGS,
				     "HP 7550 8.5x11 landscape",
				     "HP 7550 8.5x11 portrait",
				     "HP 7550 11x17 landscape",
				     "HP 7550 11x17 portrait",
				     "PostScript landscape",
				     "PostScript portrait",
				     "HPGL to LaserJet landscape",
				     "HPGL to Laserjet portrait",
				     "Rasterfile landscape",
				     "Rasterfile portrait",
				     "Generic landscape",
				     "Generic portrait",
				     "HPlaserjet 300dpi landscape",
				     "HPlaserjet 300dpi portrait",
				     "HPlaserjet 150dpi landscape",
				     "HPlaserjet 150dpi portrait",
				     "HPlaserjet 75dpi landscape",
				     "HPlaserjet 75dpi portrait",
				     0, 0);
    printstring_item = panel_create_item(psetup_panel, PANEL_TEXT,
				PANEL_LABEL_STRING, "Print control string:",
					 PANEL_ITEM_X, ATTR_COL(1),
					 PANEL_ITEM_Y, ATTR_ROW(3),
					 PANEL_VALUE_DISPLAY_LENGTH, 60, 0);
    printto_item = panel_create_item(psetup_panel, PANEL_CYCLE,
				     PANEL_LABEL_STRING, "Print to:",
				     PANEL_ITEM_X, ATTR_COL(1),
				     PANEL_ITEM_Y, ATTR_ROW(2),
				     PANEL_NOTIFY_PROC,
				     do_pr_toggle,
				     PANEL_CHOICE_STRINGS,
				     "Printer",
				     "File", 0, 0);
    panel_create_item(psetup_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(5),
		      PANEL_LABEL_IMAGE,
		      panel_button_image(psetup_panel, "Cancel", 6, 0),
		      PANEL_CLIENT_DATA, FALSE,
		      PANEL_NOTIFY_PROC, cancel_ok, 0);
    panel_create_item(psetup_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(10),
		      PANEL_ITEM_Y, ATTR_ROW(5),
		      PANEL_LABEL_IMAGE,
		      panel_button_image(psetup_panel, " OK ", 6, 0),
		      PANEL_CLIENT_DATA, TRUE,
		      PANEL_NOTIFY_PROC, cancel_ok, 0);
    window_fit(psetup_panel);
    window_fit(psetup_frame);
    panel_set_value(devices_item, hdevice - 1);
    panel_set_value(printto_item, ptofile);
    if (ptofile) {
	panel_set_value(printstring_item, printstr);
    } else {
	panel_set_value(printstring_item, curprint);
    }
    status = (int) window_loop(psetup_frame);
    if (status) {
	hdevice = (int) panel_get_value(devices_item) + 1;
	ptofile = (int) panel_get_value(printto_item);
	strcpy(tmpstr, (char *) panel_get_value(printstring_item));
	if (ptofile) {
	    strcpy(printstr, tmpstr);
	} else {
	    strcpy(curprint, tmpstr);
	}
	window_destroy(psetup_frame);
#ifdef LOCAL
	if (hdevice == 7 || hdevice == 8) {
	    if (!hpgl_loaded) {
		if (yesno("Load HPGL?", "", "YES", "NO")) {
		    system("dohpgl");
		}
	    }
	    hpgl_loaded = 1;
	}
#endif
    } else
	window_destroy(psetup_frame);
}
