/* $Id: io.c,v 1.10 90/03/21 20:01:17 pturner Exp Locker: pturner $
 *
 * input error checking, fexists()
 *
 *
 */

#include <stdio.h>
#include "defines.h"

static char readbuf[80];

int ibounds(x, lower, upper, name)
    int x, lower, upper;
    char *name;
{
    int test;

    test = ((x >= lower) && (x <= upper));
    if (!test) {
	sprintf(readbuf, " in %s : parameter must be in (%d , %d)", name, lower, upper);
	errwin(readbuf);
    }
    return (test);
}

int fbounds(x, lower, upper, name)
    double x, lower, upper;
    char *name;
{
    int test;

    test = ((x >= lower) && (x <= upper));
    if (!test) {
	sprintf(readbuf, "In %s : parameter must be in [%lf, %lf]", name, lower, upper);
	errwin(readbuf);
    }
    return (test);
}

#include <sys/param.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/file.h>
#include <pwd.h>
#include <sys/stat.h>

int fexists(to)
    char *to;
{
    int fold;
    char tbuf[128];
    struct stat stto;

    fold = open(to, 0);
    if (stat(to, &stto) >= 0) {
	sprintf(tbuf, "Overwrite %s?", to);
	if (!yesno(tbuf, "", "YES", "NO")) {
	    close(fold);
	    return (1);
	}
	close(fold);
	return (0);
    }
    close(fold);
    return (0);
}

/**************************************************************************
   Touchup a bitmap graphics editor for the Sun Workstation running SunView
   Copyright (c) 1988 by Raymond Kreisel
   1/22/88 @ Suny Stony Brook

   This program may be redistributed without fee as long as this copyright
   notice is intact.

==> PLEASE send comments and bug reports to one of the following addresses:

       Ray Kreisel
       CS Dept., SUNY at Stony Brook, Stony Brook NY 11794

       UUCP: {allegra, philabs, pyramid, research}!sbcs!rayk
       ARPA-Internet: rayk@sbcs.sunysb.edu
       CSnet: rayk@suny-sb
       (If nobody is home at any of the above addresses try:
        S72QKRE@TOWSONVX.BITNET                    )

 "If I get home before daylight, I just might get some sleep tonight...."

**************************************************************************/
/**************************************************************************
    file: disk_io.c
    purpose: This file handle most of the file I/O stuff
      mostly load, save and file completion

    modifications:
        date:    Tue Mar 22 22:04:58 EST 1988
        author:    rayk
        changes:add comments

        date:    Thu Apr 21 20:14:58 EDT 1988
        author:    rayk
        changes:when you hit return in filename the caret moves
            to textstring

        date:    Thu Apr 21 20:14:58 EDT 1988
        author:    rayk
        changes:when you do a load cut/paste buffer it will
            automagicly bring up the cut/paste command menu

        date:    Wed Jun 1 1:22:18 EDT 1988
        author:    rayk
        changes:fixed bug in resize color canvases

        date:    Wed Jun 15 14:40:48 EDT 1988
        author:    rayk
        changes:added a check in file save to check is the
            current filename is a directory
**************************************************************************/

/* #include "header.h" */

#define TRUE 1
#define FALSE 0

extern int errno;

/* This function, written by Marc J Newberger,
 * will do both login name completion and file name completion, DAM fast.
 * That means as fast as the csh does it.
 */
int complete(template)
    char *template;

{

    char dirName[255];
    char *prefix;
    int pref_len;
    char *suffix;
    char *p, *q;
    char first;
    char nonUnique;
    char twiddleUserCompletion;

    struct direct *nameEntry;
    DIR *dirChan;
    struct passwd *pwdEntry;

    /*
     * First do a little parsing of the input. Separate the prefix template
     * from the directory if there is one.
     */
    twiddleUserCompletion = 0;
    prefix = template + strlen(template);
    while (*(--prefix) != '/' && prefix >= template);

    /*
     * See if a directory was specified:
     */
    if (prefix < template) {
	/*
	 * No /'s, could be either a username completion or a completion in
	 * the current directory.
	 */
	if (template[0] == '~') {
	    /* Case of only a ~ corresponds to the HOME directory */
	    /* Ole H. Nielsen <ohnielse@ltf.dth.dk> (23-Oct-1989) */
	    if (template[1] == '\0') {
		strcpy(template, getenv("HOME"));
		return 0;
	    } else {
		prefix++;
		twiddleUserCompletion = 1;
	    }
	} else {
	    strcpy(dirName, ".");
	}
    } else if (prefix == template) {
	/*
	 * Special case !! The directory excluding the trailing '/' is zero
	 * length. It's the root:
	 */
	strcpy(dirName, "/");
    } else {
	/*
	 * We're completing a file in a directory. The directory may be lead
	 * by a ~<username> abbreviation. If that's the case expand it.
	 */
	if (template[0] == '~') {
	    /*
	     * We need to do twiddle directory expansion. See if it's our
	     * directory:
	     */
	    if (template[1] == '/') {
		/* Case of only a ~/ corresponds to the HOME directory */
		/* Ole H. Nielsen <ohnielse@ltf.dth.dk> (23-Oct-1989) */
		if (template[2] == '\0') {
		    strcpy(template, getenv("HOME"));
		    return 0;
		}
		strcpy(dirName, getenv("HOME"));
		if (&template[1] != prefix) {
		    p = dirName + strlen(dirName);
		    q = &template[1];
		    while (q < prefix) {
			*p = *q;
			p++, q++;
		    }
		    *p = 0;
		}
	    } else {
		/*
		 * It's someone else's. Let our fingers do the walking. (Why
		 * the fuck do they call it the "yellow pages" anyway.
		 * They're white pages dammit !  If they were YELLOW pages,
		 * we could say ypmatch "Automobile, Dealers, Retail", and
		 * things like that !).
		 */
		for (p = dirName, q = &template[1];
		     (*p = *q) != '/';
		     p++, q++);
		*p = 0;
		if (!(pwdEntry = getpwnam(dirName))) {
		    return errno;
		}
		strcpy(dirName, pwdEntry->pw_dir);
		p = dirName + strlen(dirName);
		while (q < prefix) {
		    *p = *q;
		    p++, q++;
		}
		*p = 0;
	    }
	} else {
	    /*
	     * It's a vanilla directory. Strip it out.
	     */
	    strncpy(dirName, template, prefix - template);
	    dirName[prefix - template] = 0;
	}
    }
    /*
     * Bump prefix past the '/'.
     */
    prefix++;

    /*
     * Get the prefix length and a pointer to the end of the prefix.
     */
    pref_len = strlen(prefix);
    suffix = template + strlen(template);

    /*
     * See whether we're doing filename or username completion:
     */
    if (!twiddleUserCompletion) {

	/*
	 * It's filename completion. Read through the directory:
	 */
	if ((dirChan = opendir(dirName)) == 0) {
	    return errno;
	}
	first = 1;
	nonUnique = 0;
	for (;;) {
	    if (!(nameEntry = readdir(dirChan))) {
		break;
	    }
	    if (!strncmp(prefix, nameEntry->d_name, pref_len)) {
		/*
		 * We have a file that matches the template. If it's the
		 * first one, we fill the completion suffix with it.
		 * Otherwise we scan and pare down the suffix.
		 */
		if (first) {
		    first = 0;
		    strcpy(suffix, nameEntry->d_name + pref_len);
		} else {
		    nonUnique = 1;
		    p = suffix;
		    q = nameEntry->d_name + pref_len;
		    while (*p == *q) {
			++p;
			++q;
		    }
		    *p = 0;

		    /*
		     * A little optimization: If p == suffix, we were unable
		     * to do any extension of the name. We might as well quit
		     * here.
		     */
		    if (p == suffix) {
			break;
		    }
		}
	    }
	}

	closedir(dirChan);
    } else {
	/*
	 * Do ~Username completion. Start by resetting the passwd file.
	 */
	setpwent();

	first = 1;
	nonUnique = 0;
	for (;;) {
	    if (!(pwdEntry = getpwent())) {
		break;
	    }
	    if (!strncmp(prefix, pwdEntry->pw_name, pref_len)) {
		/*
		 * We have a user that matches the template. If it's the
		 * first one, we fill the completion suffix with it.
		 * Otherwise we scan and pare down the suffix.
		 */
		if (first) {
		    first = 0;
		    strcpy(suffix, pwdEntry->pw_name + pref_len);
		} else {
		    p = suffix;
		    q = pwdEntry->pw_name + pref_len;
		    while (*p == *q) {
			++p;
			++q;
		    }

		    /*
		     * Here there is a possibility of seeing the same
		     * username twice. For this reason, we only set nonUnique
		     * to 1 if we're shortening the suffix. This means that
		     * the new name is distinct from any name we've seen.
		     */
		    if (*p) {
			nonUnique = 1;
			*p = 0;
		    }
		    /*
		     * A little optimization: If p == suffix, we were unable
		     * to do any extension of the name. We might as well quit
		     * here.
		     */
		    if (p == suffix) {
			break;
		    }
		}
	    }
	}
    }

    /*
     * If nothing matched, return a -1, if there was non-uniqueness return
     * -2.
     */
    if (first) {
	return -1;
    } else if (nonUnique) {
	return -2;
    } else {
	return 0;
    }

}

/*
 * Check if a file exist or not
 */
file_exist(file_name)
    char *file_name;
{
    FILE *fp;

    fp = fopen(file_name, "r");
    fclose(fp);
    if (fp != NULL)
	return (TRUE);
    else
	return (FALSE);
}


/*
 * Check if the file is a directory
 */
file_is_dir(file_name)
    char *file_name;
{
    struct stat buf;

    if (file_exist(file_name)) {
	stat(file_name, &buf);
	if (buf.st_mode & S_IFDIR)
	    return (TRUE);
	else
	    return (FALSE);
    } else
	return (FALSE);
}


/*
 * Take a filename with a ~ character at the begining and return
 * the full path name to that file
 *
 * Hacked so that ~ will expand to the home directory,
 * and so that filenames without an embedded / will be treated correctly (?).
 * Ole H. Nielsen <ohnielse@ltf.dth.dk> (23-Oct-1989)
 */
get_full_path(template, full_path)
    char template[];
char full_path[];

{
    char *p, *q;
    struct passwd *pwdEntry;

    /*
     * We're completing a file in a directory. The directory may be lead by a
     * ~<username> abbreviation. If that's the case expand it.
     */
    if (template[0] == '~') {
	/*
	 * We need to do twiddle directory expansion. See if it's our
	 * directory:
	 */
	if (template[1] == '/' || template[1] == '\0') {
	    strcpy(full_path, getenv("HOME"));
	    strcat(full_path, &template[1]);
	} else {
	    /*
	     * It's someone else's. Let our fingers do the walking. (Why the
	     * fuck do they call it the "yellow pages" anyway. They're white
	     * pages dammit !  If they were YELLOW pages, we could say
	     * ypmatch "Automobile, Dealers, Retail", and things like that
	     * !).
	     */
	    for (p = full_path, q = &template[1];
		 (*p = *q) != '/' && *p != '\0';
		 p++, q++);
	    *p = '\0';
	    if (!(pwdEntry = getpwnam(full_path))) {
		return errno;
	    }
	    strcpy(full_path, pwdEntry->pw_dir);
	    strcat(full_path, q);
	}
    } else
	strcpy(full_path, template);
}
