/*
 * File: heat.m256.c
 *   By: Dave Hiebeler
 *       hiebeler@turing.cs.rpi.edu
 *       Feb. 1990
 *
 * The "heat" rule in the moore neighborhood.  Each cell finds the average
 * value of the cells in the neighborhood; it then takes on that average
 * as its new value, and adds an increment.
 *
 * parm2 is the increment that is added in after the cell takes on the
 * local average value.
 *
 * parm2 = 2 is a good setting
 *
 * Note that parm1, the heat-constant, is not included in this rule as it
 * was on the Sun-version of heat.m256. This is because the truncation
 * in arithmetic on the CM prevents it from working well, unless you do
 * some extra work in your arithmetic.
 *
 * Random starting images do interesting things with some settings of
 * the parameter.  If the image just settles down to a uniform value
 * (being uniformly incremented, if parm2 != 0), then I suggest starting
 * with a uniform field of values around, say 0xf0 (240 decimal), and
 * "punching a hole" of low values such as 0, in the middle.  The hole
 * should be on the order of 40x40 squares, on a 256x256 array.  You can
 * either construct sucn an image on the Sun and then send it to the CM,
 * or use "CM/General_random" to do it all directly on the CM.
 */


#include "CMnborhood.h"

byte heat(), heat_exit();
static CM_field_id_t heat_sum;


void
init_function()
{

    update_function = heat;
    exit_function = heat_exit;
    parm2 = 2;
    heat_sum = CM_allocate_heap_field(15);
}


byte
heat()
{
    CM_u_move_2L(heat_sum, MNorth, 15, 8);
    CM_u_add_3_3L(heat_sum, heat_sum, MSouth, 12, 12, 8);
    CM_u_add_3_3L(heat_sum, heat_sum, MEast, 12, 12, 8);
    CM_u_add_3_3L(heat_sum, heat_sum, MWest, 12, 12, 8);
    CM_u_add_3_3L(heat_sum, heat_sum, MNW, 12, 12, 8);
    CM_u_add_3_3L(heat_sum, heat_sum, MSW, 12, 12, 8);
    CM_u_add_3_3L(heat_sum, heat_sum, MNE, 12, 12, 8);
    CM_u_add_3_3L(heat_sum, heat_sum, MSE, 12, 12, 8);
    CM_u_add_3_3L(heat_sum, heat_sum, MCenter, 12, 12, 8);
    CM_u_truncate_constant_2_1L(heat_sum, 9, 12);
    CM_u_add_constant_2_1L(heat_sum, parm2, 8);
    CM_u_move_1L(cell, heat_sum, 8);
}


byte
heat_exit()
{
    CM_deallocate_heap_field(heat_sum);
}
