#if 0
//<copyright>
// 
// Copyright (c) 1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>
#endif

/*
 * File:     mtl.h
 *
 * Author:   Michael Pichler
 *
 * Created:  29 Jun 95
 *
 * Changed:  29 Jun 95
 *
 */



#ifndef ge3d_mtl_h
#define ge3d_mtl_h


#include "color.h"


/* definition of multiple materials (for facesets) */

typedef struct
{
  int num_ambient,
      num_diffuse,
      num_specular,
      num_emissive,
      num_shininess,
      num_transparency;
  const colorRGB *rgb_ambient,
                 *rgb_diffuse,
                 *rgb_specular,
                 *rgb_emissive;
  const float *val_shininess,
              *val_transparency;
} materialsGE3D;


/* material bindings */

enum ge3d_matbinding_t
{ matb_default,
  matb_overall,
  matb_perpart,
  matb_perpartindexed,
  matb_perface,
  matb_perfaceindexed,
  matb_pervertex,
  matb_pervertexindexed
};


/* definition of a single material */

enum ge3d_material_t  /* constants for ge3dMaterial array */
{ mat_END,
  mat_ambientRGBA,
  mat_diffuseRGBA,
  mat_specularRGBA, 
  mat_emissiveRGBA,
  mat_shininessValue,
  /* scope */
  mat_front = 0x0,
  mat_back = 0x1,
  mat_front_and_back = 0x2
};


#endif
