 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>  		    Initialization Routines
 >>>>
 >>>>			init_spectrum()
 >>>>			init_workspace()
 >>>>			init_colors()
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#include "spectrum.h"


/****************************************************************
*
* Routine Name: spc_init()
*      Purpose: performs first set of initializations 
*        Input: none
*       Output: none
*   Written By: Danielle Argiro
*
****************************************************************/
spc_init()
{
	unsigned long mask;
        XGCValues values;
        Window     rootwindow = XDefaultRootWindow(display);

        /*
         *  perform various initializations
         */
        spc_image            = NULL;
        spc_legend_list      = NULL;
        spc_legend_lookup    = NULL;
        spc_unused_classnums = NULL;
        spc_num_unused_classnums = 0;
        spc_color_model = SpcRGB;

        spc_norm_type   = SpcNormLocal;
        spc_norm_time   = SpcNormWhenNecc;
        spc_norm_method = SpcNormWithinColors;

        spc_plot_operation = SpcAdd;
        spc_actual_plot_zoomfactor =    1.0;
        spc_potential_plot_zoomfactor = 2.0;
        spc_draw_plot_zoombox = false;
	spc_prop_plotting = true;
        spc_x_dcs = NULL;
        spc_y_dcs = NULL;

        current_red_col   = NULL;
        current_green_col = NULL;
        current_blue_col  = NULL;

	current_red_func   = xvf_strcpy("M0");
	current_green_func = xvf_strcpy("M1");
	current_blue_func  = xvf_strcpy("M2");

        norm_red_col   = NULL;
        norm_green_col = NULL;
        norm_blue_col  = NULL;

        xve_init();

        init_colors();

	mask = GCLineWidth | GCFunction | GCForeground | GCBackground;
        values.line_width = 0;
        values.function = GXcopy;
        values.foreground = white;
        values.background = black;
        gc_zoom = XCreateGC(display, rootwindow, mask, &values);
        current_entry = NULL;

}


/***************************************************************
*
* Routine Name: init_spectrum()
*      Purpose: performs various initializations for spectrum 
*        Input: none
*       Output: none
*   Written By: Danielle Argiro
*
****************************************************************/

int init_spectrum()
{
    /*
     *  set global image & global map data
     */
    spc_set_image_and_maps();
   
    /* 
     * initialize xvdisplay library 
     */
    xvd_initialize(display);

    /* 
     * allocate and initialize the xvdisplay structure 
     */
    if (!(xvdisplay = xvd_init_xvdisplay(display, spc_image, 
                      NULL, NULL, NULL, True, False, False, NULL)))
    {
           return(False);
    }
    /* xvd_build_xvdisplay(xvdisplay); */

    /* 
     * set visual & colormap to be used before building GUI 
     */
    xvf_set_visual(xvdisplay->visual);
    xvf_set_colormap(xvdisplay->colormap);
	

    return(True);

}

/****************************************************************
*
* Routine Name: init_workspace()
*      Purpose: sets workspace in which image will be displayed
*        Input: none
*       Output: none
*   Written By: Danielle Argiro
*
****************************************************************/

int init_workspace()
{
    int i, j;

    /* allocates colormap, pixels, XImage, does initializations */
    if (xvd_build_xvdisplay(xvdisplay) == False) return(False);

   /*
    * set the xcolors' RGB bands in the xvdisplay struct to the
    * default values found in columns 0-2 of the image map.
    */

    if (!(transfer_mapcol_to_xcolors(current_red_col, SpcRed))) 
	return(false);    

    if (!(transfer_mapcol_to_xcolors(current_green_col, SpcGreen)))
	return(false);    

    if (!(transfer_mapcol_to_xcolors(current_blue_col, SpcBlue)))
	return(false);    

    xvd_create_raster(display, spc_workspace, xvdisplay, True);

    xvd_update_xcolors(xvdisplay);

    /* print_current_xcolors(); */
    xvd_set_colormap(xvdisplay->raster, xvdisplay->colormap);

    current_red_func = xvf_strcpy("M0");
    current_green_func = xvf_strcpy("M1");
    current_blue_func = xvf_strcpy("M2");

    XtInsertEventHandler(xvdisplay->raster, ButtonPressMask,
                         FALSE, add_cluster_from_img, NULL, XtListHead);

    XtInsertEventHandler(xvdisplay->raster, PointerMotionMask,
                         FALSE, highlight_cursor_position, NULL, XtListHead);

    return(True);
}

/****************************************************************
*
* Routine Name: init_colors()
*      Purpose: allocates colors to be used by spectrum
*        Input: none
*       Output: none
*   Written By: Mark Young
*
****************************************************************/
int init_colors()
{
	XColor	   color, exact;
	int	   screen  = XDefaultScreen(display);
        Colormap   colormap = XDefaultColormap(display, screen);
	static char *colornames[] =
                {"White", "Green", "Red", "Blue", "Orange"};

	/*
	 *  Get the black, white, & grey colors
	 */
	if (XAllocNamedColor(display, colormap, "black", &color, &exact))
	   black = color.pixel;
	else black = XBlackPixel(display, screen);

	if (XAllocNamedColor(display, colormap, "white", &color, &exact))
	   white = color.pixel;
	else white = XWhitePixel(display, screen);

	if (XAllocNamedColor(display, colormap, "grey", &color, &exact))
	   grey = color.pixel;
	else grey = white;

	/*
	 *  Get the RGB colors
	 */
	if (XAllocNamedColor(display, colormap, "red", &color, &exact))
	   red = color.pixel;
	else red = white;

	if (XAllocNamedColor(display, colormap, "green", &color, &exact))
	   green = color.pixel;
	else green = white;

	if (XAllocNamedColor(display, colormap, "blue", &color, &exact))
	   blue = color.pixel;
	else blue = white;

	/*
	 *  Get the CMY colors
	 */
	if (XAllocNamedColor(display, colormap, "cyan", &color, &exact))
	   cyan = color.pixel;
	else cyan = white;

	if (XAllocNamedColor(display, colormap, "magenta", &color, &exact))
	   magenta = color.pixel;
	else magenta = white;

	if (XAllocNamedColor(display, colormap, "yellow", &color, &exact))
	   yellow = color.pixel;
	else yellow = white;

	/*
	 *  Get the Plot colors
	 */
        X3D_allocate_named_colors(display, colornames, PlotColors,
                                  SpcPlotColornum,
                                  false, X3D_WHITE);

}

