 /*
  * Khoros: $Id: vmindis.h,v 1.1 1991/05/10 15:46:12 khoros Exp $
  */

 /*
  * $Log: vmindis.h,v $
 * Revision 1.1  1991/05/10  15:46:12  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vmindis.h
 >>>>            Author: Tom Sauer
 >>>> Date Last Updated: Tue Mar  5 22:21:03 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vmindis_h_
#define _vmindis_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vmindis Argument Structure
*
****************************************************************/

typedef struct _vmindis  {

/*
 *  input image (Required infile)
 */
char	*i1_file;	/* input image FILENAME */
int	 i1_flag;	/* input image FLAG */

/*
 *  input image (Required infile)
 */
char	*i2_file;	/* input image FILENAME */
int	 i2_flag;	/* input image FLAG */

/*
 *  output image specifying which vector belongs to what cluster (Required outfile)
 */
char	*o_file;	/* output image specifying which vector belongs to what cluster FILENAME */
int	 o_flag;	/* output image specifying which vector belongs to what cluster FLAG */

/*
 *   specifies the border width in pixels (default = 0) (Optional integer)
 */
int	 b_int; 	/*  specifies the border width in pixels (default = 0) INT */
int	 b_flag;	/*  specifies the border width in pixels (default = 0) FLAG */

}  vmindis_struct;

vmindis_struct *vmindis;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT1(image) \
    image = readimage(vmindis->i1_file); \
    if(image == NULL){ \
        (void) fprintf(stderr,"vmindis: Image could not be read\\n"); \
        exit(1); \
    }
#define READINPUT2(image) \
    center = readimage(vmindis->i2_file); \
    if(center == NULL){ \
        (void) fprintf(stderr,"vmindis: Image could not be read\\n"); \
        exit(1); \
    }
#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); \
        \
        (void) propertype(program, image, VFF_TYP_FLOAT, TRUE)
/* -include_macros_end */

#endif
