 /*
  * Khoros: $Id: dextract.h,v 1.2 1992/03/20 23:34:02 dkhoros Exp $
  */

 /*
  * $Log: dextract.h,v $
 * Revision 1.2  1992/03/20  23:34:02  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dextract.h
 >>>>            Author: Donna Koechner
 >>>> Date Last Updated: Wed Feb 19 09:00:04 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dextract_h_
#define _dextract_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dextract Argument Structure
*
****************************************************************/

typedef struct _dextract  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  Starting point for data subset (Optional integer)
 */
int	 x_int; 	/* Starting point for data subset INT */
int	 x_flag;	/* Starting point for data subset FLAG */

/*
 *  data processing direction (0 = down vectors, 1 = across bands) (Optional logical)
 */
int	 d_logic;	/* data processing direction (0 = down vectors, 1 = across bands) LOGIC */
int	 d_flag;  	/* data processing direction (0 = down vectors, 1 = across bands) FLAG */

/*----  these are an Optional mutually exclusive group ----*/
/*
 *  Extract rest of file (Required logical)
 */
int	 e_logic;	/* Extract rest of file LOGIC */
int	 e_flag;  	/* Extract rest of file FLAG */

/*
 *  Specify length (Required integer)
 */
int	 l_int; 	/* Specify length INT */
int	 l_flag;	/* Specify length FLAG */

/*-------------------------------------------*/

}  dextract_struct;

dextract_struct *dextract;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
    image = readimage(dextract->i_file); \
    if(image == NULL){ \
        (void) fprintf(stderr,"dextract: Image could not be read\n"); \
        exit(1); \
    }

#define CHECKTYPE(program, image) \
    if( ! (propertype(program,image,VFF_TYP_FLOAT,FALSE)) && \
        ! (propertype(program,image,VFF_TYP_COMPLEX,FALSE)) ) { \
          fprintf(stderr,"dextract: data storage type must be float or complex.\n"); \
          exit(1); \
    }

#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        (void) proper_dim(program,image,0,TRUE); \
        (void) proper_loc_type(program,image,VFF_LOC_IMPLICIT,TRUE)
/* -include_macros_end */

#endif
