 /*
  * Khoros: $Id: readimage.c,v 1.2 1991/07/15 06:06:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: readimage.c,v 1.2 1991/07/15 06:06:54 khoros Exp $";
#endif

 /*
  * $Log: readimage.c,v $
 * Revision 1.2  1991/07/15  06:06:54  khoros
 * HellPatch1
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

/*

    READIMAGE - Read an KHOROS image from the specified file. Special
                filenames are "-" which is STDIN and "#" which is
                STDERR.

                Machine dependencies are
                taken care of by converting the incoming data into
                the data format of the host.

    NOTE:       THIS CODE IS MACHINE DEPENDENT!

    Written:  Scott Wilson
    Date:     24-Feb-87

    Changes:  Mark Young  6/17/88
	      Changed all wait reads (added by Ron) to use block_read().
	      Also changed error response conditions to use freeimage()
	      in order to free failed image, and also changed all exit(1)
	      to return(NULL).
              Scott Wilson and Tom Sauer 11/23/88
              Added support for color map models - must scale image data
              size by number of color axes.
	      Scott Wilson 18-Feb-89 Updated to XV 3.0
	      Scott Wilson 31-May-89 Updated to XV 3.1
	      Scott Wilson  2-Feb-90 Added image cache support
              Scott Wilson 21-Jun-90 Modified for filenames instead of fd's
              Scott Wilson 22-Jun-90 Changed cache support
              Scott Wilson 6-Aug-90 Catch malloc of zero bytes (SYS V bug)
	      Scott Wilson 11-Dec-90 Added normal file locking
	      Scott Wilson 29-May-91 Fix "-" as input filename
*/

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vinclude.h"

struct xvimage
*readimage(filename)
char *filename;
{
    char buf[512];
    long *l, machtype();
    long source_machine,current_machine;
    int imgsize,mapsize,locsize,imgcnt,mapcnt,loccnt;
    char *malloc();
    struct xvimage *image, *readheader();
    short *s;
    float *f;
    int i, block_read();
    int read_compressed();
    int file;

    if (!vfullpath(filename,NULL,buf))
       return(NULL);

#ifdef CACHE
    if (khoros_cache) khlock();
#endif

#ifdef CACHE
    if (!khoros_cache)
#else
    if (1)
#endif
      {
        if ( (file = open_input(buf)) < 0)
          {
            (void)fprintf(stderr,"\nreadimage: unable to access file %s\n",
                          filename);
            return(NULL);
          }
      }
#ifdef CACHE
    else
      {
        holepath(buf);   /* Get the real full path */

        /* Special trap for "-" as filename */
        if (strcmp(buf,"-") == 0) file = -1;
	else file = find_image_in_cache(buf);

        if (file != -1) file = -(1000+file);
        else
          {
            khunlock(); /* Don't need to mess with the cache anymore */
            if ( (file = open_input(buf)) < 0)
              {
                fprintf(stderr,"\nreadimage: unable to access file %s\n",
                        filename);
                return(NULL);
              }
          }
      }
#endif

    /* If we ended up with a real file descriptor then lock it! */
    if (file >= 0) flock(file,LOCK_EX);
    
    /* Read the image header */
    image = readheader(file);
    if (image == NULL) 
      {
        krclose(file);
        return(NULL);
      }

    /* Get size of image components in bytes */
    if (! imagesize(image,&imgsize,&imgcnt,&mapsize,&mapcnt,&locsize,
	  &loccnt))
      {
        free(image);
        krclose(file);
        return(NULL);
      }

    /* Get space for image, map, and location data*/
    if (imgsize != 0) image->imagedata = (char *)malloc(imgsize);
    if (imgsize != 0 && image->imagedata == NULL)
      {
        fprintf(stderr,"\nreadimage: Not enough memory for image data.\n");
	freeimage(image);
        krclose(file);
        return(NULL);
      }
    if (mapsize != 0) image->maps = (char *)malloc(mapsize);
    if (mapsize != 0 && image->maps == NULL)
      {
        fprintf(stderr,"readimage: Not enough memory for maps.\n");
        freeimage(image);
        krclose(file);
        return(NULL);
      }
    if (locsize != 0) image->location = (float *)malloc(locsize);
    if (locsize != 0 && image->location == NULL)
      {
        fprintf(stderr,"readimage: Not enough memory for locations.\n");
        freeimage(image);
        krclose(file);
        return(NULL);
      }

    /* Read  maps */
    if (image->data_encode_scheme == VFF_DES_RAW)
      {
        if (block_read(file, image->maps, mapsize) != mapsize)
          {
            fprintf(stderr,"\nreadimage: ");
    	    fprintf(stderr,"Incorrect byte count reading maps!\n");
            freeimage(image);
            krclose(file);
            return(NULL);
          }
      }
    else
      {
        if (read_compressed(file,image->maps,mapsize,image) != mapsize)
          {
            fprintf(stderr,"\nreadimage: ");
    	    fprintf(stderr,"Unable to interpret compressed maps!\n");
            freeimage(image);
            krclose(file);
            return(NULL);
          }
      }

    /* Read  locations */
    if (image->data_encode_scheme == VFF_DES_RAW)
      {
        if (block_read(file,image->location, locsize) != locsize)
          {
            fprintf(stderr,"\nreadimage: ");
    	    fprintf(stderr,"Incorrect byte count reading locations!\n");
            freeimage(image);
            krclose(file);
            return(NULL);
          }
      }
    else
      {
        if (read_compressed(file,image->location,locsize,image) != locsize)
          {
            fprintf(stderr,"\nreadimage: ");
    	    fprintf(stderr,"Unable to interpret compressed locations!\n");
            freeimage(image);
            krclose(file);
            return(NULL);
          }
      }

    /* Read  image data */
    if (image->data_encode_scheme == VFF_DES_RAW)
      {
        if (block_read(file,image->imagedata, imgsize) != imgsize)
          {
            fprintf(stderr,"\nreadimage: ");
    	    fprintf(stderr,"Incorrect byte count reading image data!\n");
            freeimage(image);
            krclose(file);
            return(NULL);
          }
      }
    else
      {
        if (read_compressed(file,image->imagedata,imgsize,image) != imgsize)
          {
            fprintf(stderr,"\nreadimage: ");
    	    fprintf(stderr,"Unable to interpret compressed image data!\n");
            freeimage(image);
            krclose(file);
            return(NULL);
          }
      }

  krclose(file);

  /* See if machine conversion is necessary on the DATA */
  current_machine = machtype(NULL);
  source_machine = image->machine_dep;
  if (current_machine != source_machine)
    {
      switch(image->data_storage_type)
        {
          case VFF_TYP_BIT:
            break;
          case VFF_TYP_1_BYTE:
            break;
          case VFF_TYP_2_BYTE:
            s = (short *)image->imagedata;
            if (current_machine == VFF_DEP_IEEEORDER &&
                source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<imgcnt; i++) { dectoieees(s); s++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<imgcnt; i++) { ieeetodecs(s); s++; }
              }
            else if (current_machine == VFF_DEP_IEEEORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<imgcnt; i++) { nstoieees(s); s++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<imgcnt; i++) { ieeetonss(s); s++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<imgcnt; i++) { dectonss(s); s++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<imgcnt; i++) { nstodecs(s); s++; }
              }
            else
              {
                fprintf(stderr,"\nreadimage: Unknown machine type!\n");
		freeimage(image);
                return(NULL);
              }
            break;
          case VFF_TYP_4_BYTE:
            l = (long *)image->imagedata;
            if (current_machine == VFF_DEP_IEEEORDER &&
                source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<imgcnt; i++) { dectoieeel(l); l++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<imgcnt; i++) { ieeetodecl(l); l++; }
              }
            else if (current_machine == VFF_DEP_IEEEORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<imgcnt; i++) { nstoieeel(l); l++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<imgcnt; i++) { ieeetonsl(l); l++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<imgcnt; i++) { dectonsl(l); l++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<imgcnt; i++) { nstodecl(l); l++; }
              }
            else
              {
                fprintf(stderr,"\nreadimage: Unknown machine type!\n");
		freeimage(image);
                return(NULL);
              }
            break;
          case VFF_TYP_DOUBLE:
            fprintf(stderr,"\nreadimage: DOUBLE not yet supported!\n");
            freeimage(image);
            return(NULL);
            break;
          case VFF_TYP_FLOAT:
            f = (float *)image->imagedata;
            if (current_machine == VFF_DEP_IEEEORDER &&
                source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<imgcnt; i++) { dectoieeef(f); f++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<imgcnt; i++) { ieeetodecf(f); f++; }
              }
            else if (current_machine == VFF_DEP_IEEEORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<imgcnt; i++) { nstoieeef(f); f++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<imgcnt; i++) { ieeetonsf(f); f++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<imgcnt; i++) { dectonsf(f); f++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<imgcnt; i++) { nstodecf(f); f++; }
              }
            else
              {
                fprintf(stderr,"\nreadimage: Unknown machine type!\n");
		freeimage(image);
                return(NULL);
              }
            break;
          case VFF_TYP_COMPLEX:
            f = (float *)image->imagedata;
            if (current_machine == VFF_DEP_IEEEORDER &&
                source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<imgcnt*2; i++) { dectoieeef(f); f++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<imgcnt*2; i++) { ieeetodecf(f); f++; }
              }
            else if (current_machine == VFF_DEP_IEEEORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<imgcnt*2; i++) { nstoieeef(f); f++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<imgcnt*2; i++) { ieeetonsf(f); f++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<imgcnt*2; i++) { dectonsf(f); f++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<imgcnt*2; i++) { nstodecf(f); f++; }
              }
            else
              {
                fprintf(stderr,"\nreadimage: Unknown machine type!\n");
		freeimage(image);
                return(NULL);
              }
            break;
          default:
            fprintf(stderr,"\nreadimage: Unknown image ");
	    fprintf(stderr,"type: %d\n",image->data_storage_type);
            freeimage(image);
            return(NULL);
            break;
        }
    }

  /* Perform any machine conversion necessary on the map cell data */
  if (current_machine != source_machine)
    {
      switch(image->map_storage_type)
        {
          case VFF_MAPTYP_1_BYTE:
            break;
          case VFF_MAPTYP_2_BYTE:
            s = (short *)image->maps;
            if (current_machine == VFF_DEP_IEEEORDER &&
                source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<mapcnt; i++) { dectoieees(s); s++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<mapcnt; i++) { ieeetodecs(s); s++; }
              }
            else if (current_machine == VFF_DEP_IEEEORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<mapcnt; i++) { nstoieees(s); s++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<mapcnt; i++) { ieeetonss(s); s++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<mapcnt; i++) { dectonss(s); s++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<mapcnt; i++) { nstodecs(s); s++; }
              }
            else
              {
                fprintf(stderr,"\nreadimage: Unknown machine type!\n");
		freeimage(image);
                return(NULL);
              }
            break;
          case VFF_MAPTYP_4_BYTE:
            l = (long *)image->maps;
            if (current_machine == VFF_DEP_IEEEORDER &&
                source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<mapcnt; i++) { dectoieeel(l); l++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<mapcnt; i++) { ieeetodecl(l); l++; }
              }
            else if (current_machine == VFF_DEP_IEEEORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<mapcnt; i++) { nstoieeel(l); l++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<mapcnt; i++) { ieeetonsl(l); l++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<mapcnt; i++) { dectonsl(l); l++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<mapcnt; i++) { nstodecl(l); l++; }
              }
            else
              {
                fprintf(stderr,"\nreadimage: Unknown machine type!\n");
		freeimage(image);
                return(NULL);
              }
            break;
          case VFF_MAPTYP_DOUBLE:
            fprintf(stderr,"\nreadimage: DOUBLE not yet supported!\n");
            freeimage(image);
            return(NULL);
            break;
          case VFF_MAPTYP_FLOAT:
            f = (float *)image->maps;
            if (current_machine == VFF_DEP_IEEEORDER &&
                source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<mapcnt; i++) { dectoieeef(f); f++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<mapcnt; i++) { ieeetodecf(f); f++; }
              }
            else if (current_machine == VFF_DEP_IEEEORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<mapcnt; i++) { nstoieeef(f); f++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<mapcnt; i++) { ieeetonsf(f); f++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<mapcnt; i++) { dectonsf(f); f++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<mapcnt; i++) { nstodecf(f); f++; }
              }
            else
              {
                fprintf(stderr,"\nreadimage: Unknown machine type!\n");
		freeimage(image);
                return(NULL);
              }
            break;
          case VFF_MAPTYP_COMPLEX:
            f = (float *)image->maps;
            if (current_machine == VFF_DEP_IEEEORDER &&
                source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<mapcnt*2; i++) { dectoieeef(f); f++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<mapcnt*2; i++) { ieeetodecf(f); f++; }
              }
            else if (current_machine == VFF_DEP_IEEEORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<mapcnt*2; i++) { nstoieeef(f); f++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_IEEEORDER)
              {
                for (i=0; i<mapcnt*2; i++) { ieeetonsf(f); f++; }
              }
            else if (current_machine == VFF_DEP_NSORDER &&
                     source_machine  == VFF_DEP_DECORDER)
              {
                for (i=0; i<mapcnt*2; i++) { dectonsf(f); f++; }
              }
            else if (current_machine == VFF_DEP_DECORDER &&
                     source_machine  == VFF_DEP_NSORDER)
              {
                for (i=0; i<mapcnt*2; i++) { nstodecf(f); f++; }
              }
            else
              {
                fprintf(stderr,"\nreadimage: Unknown machine type!\n");
		freeimage(image);
                return(NULL);
              }
            break;
        }
    }

    /* Perform any required machine conversions on the location data */
    if (image->location_type == VFF_LOC_EXPLICIT &&
        current_machine != source_machine)
      {
        f = (float *)image->location;
        if (current_machine == VFF_DEP_IEEEORDER &&
            source_machine  == VFF_DEP_DECORDER)
          {
            for (i=0; i<loccnt; i++) { dectoieeef(f); f++; }
          }
        else if (current_machine == VFF_DEP_DECORDER &&
                 source_machine  == VFF_DEP_IEEEORDER)
          {
            for (i=0; i<loccnt; i++) { ieeetodecf(f); f++; }
          }
        else if (current_machine == VFF_DEP_IEEEORDER &&
                 source_machine  == VFF_DEP_NSORDER)
          {
            for (i=0; i<loccnt; i++) { nstoieeef(f); f++; }
          }
        else if (current_machine == VFF_DEP_NSORDER &&
                 source_machine  == VFF_DEP_IEEEORDER)
          {
            for (i=0; i<loccnt; i++) { ieeetonsf(f); f++; }
          }
        else if (current_machine == VFF_DEP_NSORDER &&
                 source_machine  == VFF_DEP_DECORDER)
          {
            for (i=0; i<loccnt; i++) { dectonsf(f); f++; }
          }
        else if (current_machine == VFF_DEP_DECORDER &&
                 source_machine  == VFF_DEP_NSORDER)
          {
            for (i=0; i<loccnt; i++) { nstodecf(f); f++; }
          }
        else
          {
           fprintf(stderr,"\nreadimage: Unknown machine type!\n");
	   freeimage(image);
           return(NULL);
          }
      }
        
    image->machine_dep = machtype(NULL);

    /* Return the whole mess to the caller */
    return(image);
}

krclose(file)
int file;
  {
#ifdef CACHE
    /* If reading from cache, reset the pointers so that subsequent
       reads start at the right place */
    if (file <= -1000) 
      {
        xvcache_reset_ptrs(file);
        khunlock();
      }
    else
#endif
      {
        flock(file,LOCK_UN);
        close(file);
      }
  }
