/******************************************************************************
* Bzr-Gen.c - Bezier generic routines.					      *
*******************************************************************************
* Written by Gershon Elber, Mar. 90.					      *
******************************************************************************/

#include "cagd_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Allocates the memory required for a new Bezier surface.		     M
*                                                                            *
* PARAMETERS:                                                                M
*   ULength:      Number of control points in the U direction.               M
*   VLength:      Number of control points in the V direction.               M
*   PType:        Type of control points (E2, P3, etc.).                     M
*                                                                            *
* RETURN VALUE:                                                              M
*   CagdSrfStruct *:   An uninitialized freeform Bezier surface.             M
*                                                                            *
* KEYWORDS:                                                                  M
*   BzrSrfNew, allocation                                                    M
*****************************************************************************/
CagdSrfStruct *BzrSrfNew(int ULength, int VLength, CagdPointType PType)
{
    CagdSrfStruct *Srf = CagdSrfNew(CAGD_SBEZIER_TYPE, PType, ULength,
								VLength);

    Srf -> UOrder = Srf -> ULength = ULength;
    Srf -> VOrder = Srf -> VLength = VLength;

    Srf -> UKnotVector = Srf -> VKnotVector = NULL;

    return Srf;
}

/*****************************************************************************
* DESCRIPTION:                                                               M
*   Allocates the memory required for a new Bezier curve.		     M
*                                                                            *
* PARAMETERS:                                                                M
*   Length:     Number of control points                                     M
*   PType:      Type of control points (E2, P3, etc.).                       M
*                                                                            *
* RETURN VALUE:                                                              M
*   CagdCrvStruct *:   An uninitialized freeform Bezier curve.               M
*                                                                            *
* KEYWORDS:                                                                  M
*   BzrCrvNew, allocation                                                    M
*****************************************************************************/
CagdCrvStruct *BzrCrvNew(int Length, CagdPointType PType)
{
    CagdCrvStruct *Crv = CagdCrvNew(CAGD_CBEZIER_TYPE, PType, Length);

    Crv -> Order = Crv -> Length = Length;

    Crv -> KnotVector = NULL;

    return Crv;
}
