/* ****************************************************************
 *                            geo.h
 * ****************************************************************
 * include file for the geometric utilities
 */
#ifndef GEO_H
#define GEO_H

#ifndef TRUE
#define TRUE    1
#endif TRUE
#ifndef FALSE
#define FALSE   0
#endif FALSE

/* common geometric constructs
 */
typedef struct {double  i, j, k;}        DIR_VECT;
typedef struct {double  x, y, z;}        POINT3;
typedef struct {double  x, y, z, h;}     POINT4;
typedef struct {POINT3      start;
		DIR_VECT    dir; }       LINE;

/* geometric manipulation routines
 */
double          geo_dot();      /* vector dot product */
DIR_VECT        geo_cross();    /* vector cross product */
double          geo_norm();     /* vector normalize */
double          geo_line();     /* vector between two points */
DIR_VECT        *geo_rfl();     /* reflected vector */
DIR_VECT        *geo_rfr();     /* refracted vector */
DIR_VECT        *geo_H();       /* H vector */
DIR_VECT        *geo_Ht();      /* H' vector */

#endif GEO_H
/* ************************************************************* */
