/*

  File: calc.h

  $Header$
  
  $Log$

  $Author$

*/


#ifndef _CALC_H_
#define _CALC_H_


class Point {
  double d_x, d_y, d_z;
 public:
  Point(const Atom &a, int i=0);
  Point(void) {d_x=0.0, d_y=0.0, d_z=0.0;}
friend class Torsion;
};

class Torsion{
 private:
  static Point X1;
  static Point X2;
  static Point X3;
  static Point X4;

  static void cross(Point &a, Point &b, Point &c);
  static double dot(Point &a, Point &b);
  static void vecdif(Point &a, Point &b, Point &c);
  static double angle(Point &a, Point &b, Point &c);
  static void dischk(Point &x, int *ichk);
  static double amag(Point &x);
  static double torsion_function(Point &A, Point &B, Point &C, Point &D);

 public:
  static double torsion_angle(const Atom &a, const Atom &b, 
			      const Atom &c, const Atom &d, int i=0);
};

class Calculate:public Torsion{
 private:
  static int is_ray_crossing_segment(const int &i, const double &phi,
					 const double &psi,
					 const torsion rcontour[],
					 const int extent);
 public:
  static double distance(const Atom &a, const Atom &b);
  static double distance(double x1, double y1, double z1,
		  double x2, double y2, double z2);
  static double distance(double x1, double y1, double x2, double y2);
  static int IsPointOnRamachandranContour(const double &phi, const double &psi);
};

#endif
