/* The IBM specific graphics routines for the 3d glasses viewer. This is
a modified  ibm.c from the PoVRay raytracer, its copyright and remarks
are below in their entirety.

John Swenson CIS 75300,2136

*/



/****************************************************************************
*                   ibm.c
*
*  This module implements the IBM-PC specific routines for PV-Ray.
*
*  from Persistence of Vision Raytracer 
*  Copyright 1991 Persistence of Vision Team
*---------------------------------------------------------------------------
*                       *IMPORTANT!*
*  This copyrighted software is freely distributable. The source and/or
* object code may be copied or uploaded to communications services so long as
* this notice remains at the top of each file.
* 
*  If any changes are made to the program, you must clearly indicate in the
* documentation and in the program startup message who it was who made the
* changes. The documentation should also describe what those changes were.
* 
*  This software may not be included in whole or in part into any commercial
* package without the express written consent of the PV-Team. It may,
* however, be included in other freely distributed software so long as proper
* credit for the software is given. No more than five dollars U.S. ($5) can
* be charged for the copying of this software and the media it is provided on,
* i.e. a shareware distribution company may only charge five U.S dollars or
* less for providing this software.
* 
*  This software is provided as is without any guarantees or warranty.
* Although the authors have attempted to find and correct any bugs in the
* software, they are not responsible for any damage caused by the use of the
* software. The authors are under no obligation to provide service,
* corrections, or upgrades to this package.
*-----------------------------------------------------------------------------
*  Despite all the legal stuff above, if you have any problems with the
* program the PV-Team would like to hear about them. Also, if you have any
* comments, questions or enhancements, please contact the PV-Team on the
* Compuserve Online Service in the COMART forum message section 16 (!GO
* COMART). The CIS COMART forum is devoted to computer generated artwork like
* raytracing, animation and fractals. For more information regarding the PV
* team see the file PVINF.TXT. For more information on Compuserve call
* (in the U.S.) 1-800-848-8990.
* 
*       Drew Wells
*       PV-Team Leader
*       CIS: 73767,1244
* 
* 
*  This program is based on the popular DKB raytracer version 2.12 written by
* David Buck, a PV-Team member.
*  (David Buck CIS: 70521,1371 Internet: dbuck@ccs.carleton.ca)
* 
*****************************************************************************/

/* Original IBM VGA "colour" output routines for MS/DOS by Aaron A. Collins.

   This will deliver approximate colorings using HSV values for the selection.
   The palette map is divided into 4 parts - upper and lower half generated
   with full and half "value" (intensity), respectively.  These halves are
   further halved by full and half saturation values of each range (pastels).
   There are three constant colors, black, white, and grey.  They are used
   when the saturation is low enough that the hue becomes undefined, and which
   one is selected is based on a simple range map of "value".  Usage of the
  palette is accomplished by converting the requested color RGB into an HSV
   value.  If the saturation is too low (< .25) then black, white or grey is
   selected.  If there is enough saturation to consider looking at the hue,
   then the hue range of 1-63 is scaled into one of the 4 palette quadrants
   based on its "value" and "saturation" characteristics.

   Further SVGA, MVGA mods by Aaron A. Collins:
   SVGA, MVGA assembler routines originally by John Bridges.
   VESA assembler routines from FRACTINT, by The Stone Soup Group
   AT&T VDC600 SVGA mods to DKB Trace 2.01 module IBM.C by John Gooding

   This file now represents the collective wisdom of the VGAKIT34 package,
   with support for all of the SVGA types known to mankind.  Seriously,
   VGAKIT34 is an excellent technical reference for IBM programmers wishing
   to do any sort of SVGA video access, and it encompasses nearly all of the
   SVGA adapters in use today.  It was written by John Bridges, a.k.a.
   CIS:73307,606, GENIE:J.BRIDGES.  It was originally coded in IBM 80x86
   assembler, and since DKBTrace is a completely "C"-based package, I have
   converted John's assembler routines all into "C".  These may be a tad bit
   slower, but they should be compatible across a wide variety of 80x86/(S)VGA
   machines.  Note if you have a regular cheapo VGA card like myself, included
   is "MODE13x" or MVGA (modified VGA) mode (some call it "tweaked", but I
   call it "Simulated SVGA"), which gives 360x480 on any reasonably register-
   compatible plain vanilla VGA card.  This mode gives a good simulated 640 by
   480 screen resolution.  I did not implement all the neat hi-res modes of
   all the various SVGA adapters, if you select a trace size bigger than the
   program and/or card can handle (most likely 640x480), it is dynamically
   scaled to fit the available resolution, so you'll be able to see a rough
   approximation of an 800x600 trace even on any el-cheapo VGA card at 320x200
   resolution.  The VESA VGA mode was freely adapted from FRACTINT, whose GIF
   reading routines we are already using in DKBTrace.  I hope my conversion
   of it works properly.

   There is still a reported problem with the EVEREX autodetect returning
   TRIDENT.  In fact EVEREX uses a TRIDENT chip set, but apparently there
   is some difference in operation.  There are cryptic diagnostic messages
   such as T0000, etc. printed as a result of the autodetection routines
   to help track down why the error is happening.  If you are experiencing
   problems with EVEREX or TRIDENT, make note of the letter-4 digit code you
   are given.  There is now an autodetect for VDC600 that I hope will work
   universally.  A similar problem as the EVEREX exists, in that the VDC600
   is detected as a PARADISE because it uses the PARADISE chip set.  I am now
   looking for what I believe to be the model number in the BIOS ROM of the
   VDC600 to differentiate between the two.  I hope this works  with all
   VDC600's, as I only had one example to work from.  Please send all bug
   reports to Aaron Collins at the "You Can Call Me RAY" BBS, the number is
   in the authors.txt document.


   PV-Ray Enhancements:

   (S)VGA B&W 64 Greyscale code courtesy of Grant Hess 6/21/91

   16/24-bit HGWS/TIGA code courtesy of Jay S. Curtis 11/15/90

   VGA "332" palette routines courtesy of Alexander Enzmann 7/20/91

   Additional support for VESA and Tseng Labs 256 and 32768 color modes by
   Charles Marslett  (CIS: 73317,3662).  Resolution is selected to be the
   lowest possible and still fit the image entirely on the screen. 4/28/91

*/

#include <dos.h>	/* MS-DOS specific - for int86() REGS struct, etc. */
#include <time.h>
#include "frame.h"
/* #include "pvproto.h"  */

#ifdef TURBOC
extern unsigned _stklen = 12288; /* fairly large stack for HEAVY recursion */
#define CLD asm cld
#define _asm asm
#else
#ifdef __WATCOMC__
#define CLD clear_direction()
void clear_direction(void);
#pragma aux clear_direction = 0xFC parm [] modify nomemory;
#else
#define CLD _asm cld
#endif
#endif

/* The supported VGA adapter types 1 - 9, A - G.  0 is for auto-detect. */

#define	BASIC_VGA	1		/* 1 - Tested: AAC */
#define	TSENG3		3		/* 3 - Tested: William Minus */
#define	TSENG4		4		/* 4 - Tested: William Minus */
#define	VDC600		5		/* 5 - Tested: John Gooding */
#define	OAKTECH		6		/* 6 - Untested */
#define	VIDEO7		7		/* 7 - Untested */
#define CIRRUS		8		/* 8 - Tested: AAC */
#define	PARADISE	9		/* 9 - Tested: John Degner */
#define	AHEADA		17		/* A - Untested */
#define	AHEADB		18		/* B - Untested */
#define	CHIPSTECH	19		/* C - Untested */
#define	ATIVGA		20		/* D - Tested: William Earl */
#define	EVEREX		21		/* E - Tested: A+B problem - Larry Minton */
#define	TRIDENT		22		/* F - Tested: A problem - Alexander Enzmann */

#define TRUECOLOR       25              /* this # or higher isn't an (S)VGA */
#define TIGA_16         25              /* O - Untested */
#define TIGA_24         26              /* P - Untested */


/* defines for display resolutions */

#define D320x200        1
#define D320x400        2
#define D360x480        3
#define D640x400        4
#define D640x480        5
#define D800x600        6






#define	MISCOUT		0x3c2		/* VGA chip msic output reg. addr */
#define	SEQUENCER	0x3c4		/* VGA chip sequencer register addr */
#define	CRTC		0x3d4		/* VGA chip crt controller reg addr */


char *vga_names[] = 
    {
    "",
    "Standard VGA",
    "",
    "Tseng Labs 3000 SVGA",
    "Tseng Labs 4000 SVGA",
    "AT&T VDC600 SVGA",
    "Oak Technologies SVGA",
    "Video 7 SVGA",
    "Video 7 Vega (Cirrus) VGA",
    "Paradise SVGA",
    "",
    "",
    "",
    "",	/* reserved */
    "",
    "",
    "",
    "Ahead Systems Ver. A SVGA",
    "Ahead Systems Ver. B SVGA",
    "Chips & Technologies SVGA",
    "ATI SVGA",
    "Everex SVGA",
    "Trident SVGA",
    "",
    "",
    "",
    "",
    "", /* spare SVGAs */
    "",
    "",
    "",
    "Hercules GWS/TIGA 16-bit",	/* here on is reserved for non-SVGA cards */
    "Hercules GWS/TIGA 24-bit"
    };


unsigned int vptbl[] =		/* CRTC register values for MODE13x */
    {
    0x6b00,	/* horz total */
    0x5901,	/* horz displayed */
    0x5a02,	/* start horz blanking */
    0x8e03U,	/* end horz blanking */
    0x5e04,	/* start h sync */
    0x8a05U,	/* end h sync */
    0x0d06,	/* vertical total */
    0x3e07,	/* overflow */
    0x4009,	/* cell height */
    0xea10U,	/* v sync start */
    0xac11U,	/* v sync end and protect cr0-cr7 */
    0xdf12U,	/* vertical displayed */
    0x2d13,	/* offset */
    0x0014,	/* turn off dword mode */
    0xe715U,	/* v blank start */
    0x0616,	/* v blank end */
    0xe317U	/* turn on byte mode */
};

unsigned int vptbl2[] =          /* CRTC register values for MODE324 */
    {
    0x5f00,     /* horz total */
    0x4f01,     /* horz displayed */
    0x5002,     /* start horz blanking */
    0x8203U,    /* end horz blanking */
    0x5404,     /* start h sync */
    0x8005U,    /* end h sync */
    0xbf06,     /* vertical total */
    0x1f07,     /* overflow */
    0x4009,	/* cell height */
    0x9c10U,    /* v sync start */
    0x8e11U,    /* v sync end and protect cr0-cr7 */
    0x8f12U,    /* vertical displayed */
    0x2813,     /* offset */
    0x0014,	/* turn off dword mode */
    0x9615U,    /* v blank start */
    0xb916,     /* v blank end */
    0xe317U	/* turn on byte mode */
};






extern int screen_height, screen_width;
extern char DisplayRes;
int svga_width = 640;		/* default SVGA width/height, */
int svga_height = 480;		/* unless we find otherwise... */
int lastx, lasty, lastline;	/* Pixel / Line Caches */
int whichvga = BASIC_VGA;       /* BASIC_VGA mode by default */
int whichres = D320x200;
int vga_512K = FALSE;		/* Flag for whether or not >= 512K VGA mem */
unsigned char cur_page = 255;	/* SVGA current page (bank) number */
unsigned int map_code = 0;	/* default map code is 0 */
unsigned long gran = 65536L;	/* SVGA granule size (64K by default) */
unsigned char vesa_granularity = 1;	/* VESA default to 64K granules */
/* void (_cdecl *vesa_bankswitch)(void); * ptr to VESA bankswitch function */
unsigned char answer[257];		/* answer area for VESA BIOS calls */
int vesamode;				/* cur. VESA BIOS supported mode */
int dither_matrix[4][4]={	{0,8,2,10},	/* HGWS/TIGA dither matrix */
				{12,4,14,6},	/* this may not be needed? */
				{3,11,1,9},
				{15,7,13,5}
			};
char hpt[3];			/* HWGS/TIGA information passing area */
char _far *hptr=hpt;		/* HWGS/TIGA information passing area ptr */

int Color_Bits;


extern char DisplayFormat, PaletteOption;
extern int page2, size_512k, size_1024k;
extern int image_1_byte, image_2_byte, invert_image;
extern int port_adr;
extern FILE *df;
extern int xmode;


int auto_detect_vga(void);
int cirrus(void);
int chkbank(unsigned int, unsigned int);
void palette_init(void);
void newbank(void);
void set_palette_register(unsigned, unsigned, unsigned, unsigned);
void hsv_to_rgb(DBL, DBL, DBL, unsigned *, unsigned *, unsigned *);
void rgb_to_hsv(unsigned, unsigned, unsigned, DBL *, DBL *, DBL *);
#ifdef __WATCOMC__
int matherr(struct exception *);
#else
int _cdecl matherr(struct exception *);
#endif
void set_start_address(int);
void set_color_map(IMAGE_COLOUR *,int);

void display_init(width, height) /* Set video to requested or best mode */
int width, height;
   {
   union REGS inr, outr;
   struct SREGS segs;
   unsigned char _far *fp;
   unsigned int _far *mp;
   unsigned int u, granule, vesamodes[32];
/* unsigned int tmp_word, tmp_word1; */
   int i, maxvesamode;
   long l, lt;
   int show_display_type = FALSE;


   if(size_1024k)
        size_512k = 0;


   lastline = -1;		/* make sure we display the 1st line... */
   screen_height = height;	/* requested screen height and width */
   screen_width = width;
   if (DisplayFormat == '?'){  
     DisplayFormat = '0';
     show_display_type = TRUE;
     }
    
   if (DisplayFormat != '0')	/* if not 0, some display type specified */
	  whichvga = (int)(DisplayFormat - '0');	/* de-ASCII-fy selection */
   else
	{
	whichvga = auto_detect_vga();
	printf("Display detected: (%c) %s Adapter", whichvga + '0', vga_names[whichvga]);
	if (whichvga < TRUECOLOR)   /*  if not a True-Color graphics card */
	    printf(", with %s 512K RAM\n", vga_512K ? ">=" : "<");
	lt = l = time(&l);
  if(show_display_type)    /* If display format is ? */
	  while (time(&l) < lt + 5)	/* display detected VGA type for 5 secs */
	    ;
	}
   whichres = (int)(DisplayRes - '0');        /* de-ASCII-fy selection */
   if(whichres == 0)
        whichres = 1;


   if(whichvga == BASIC_VGA && whichres == D360x480)
   {
        printf(" You must specify an SVGA board to use 360 x 480\n");
        exit(1);
   }

    if(whichres == D360x480)
    {
        inr.x.ax = 0x0013;
        svga_width = 360;
        svga_height = 480;
    }
    if(whichres == D320x200 || whichres == D320x400)
        whichvga = BASIC_VGA;

   switch (whichvga)
        {
        case BASIC_VGA:
            switch(whichres)
            {
                case D320x200:
                    inr.x.ax = 0x0013;
                    svga_width = 320;
                    svga_height = 200;
                    break ;
                default :
                    inr.x.ax = 0x0013;
                    svga_width = 320;
                    svga_height = 400;
                    break;
            }
            break;
        case VDC600:
            switch(whichres)
            {
                case D360x480:
                    break;
                default:
                    inr.x.ax = 0x005E;   /* setup to VGA 640x400x256 (mode 5EH) */
                    svga_height = 400;   /* This is the only SVGA card w/400 Lines */
            }
	    break;
        case OAKTECH:
            switch(whichres)
            {
                case D360x480:
                    break;
                default:
                    inr.x.ax = 0x0053;   /* setup to VGA 640x480x256 most SVGAs */
                    break;
            }
	    break;
	case AHEADA:
        case AHEADB:
            switch(whichres)
            {
                case D360x480:
                    break;
                default:
                    inr.x.ax = 0x0061;
                    break;
            }
	    break;
        case EVEREX:
            switch(whichres)
            {
                case D360x480:
                    break;
                default:
                    inr.x.ax = 0x0070;   /* BIOS Mode 0x16 for EV-678? */
                    inr.h.bl = 0x30;
                    break;
            }
	    break;
        case ATIVGA:
            switch(whichres)
            {
                case D360x480:
                    break;
                default:
                    inr.x.ax = 0x0062;
                    break;
            }
	    break;
        case TRIDENT:
            switch(whichres)
            {
                case D360x480:
                    break;
                default:
                    inr.x.ax = 0x005d;
                    break;
            }
	    break;
        case VIDEO7:
            switch(whichres)
            {
                case D360x480:
                    break;
                default:
                    inr.x.ax = 0x6f05;
                    inr.h.bl = 0x67;
                    break;
            }
	    break;
        case CHIPSTECH:
            switch(whichres)
            {
                case D360x480:
                    break;
                case D640x400:
                    inr.x.ax = 0x0078;
                    svga_height = 400;
                    break;
                default:
                    inr.x.ax = 0x0079;
                    break;
            }
	    break;
        case PARADISE:
            switch(whichres)
            {
                case D360x480:
                    break;
                default:
                    inr.x.ax = 0x005f;
                    break;
            }
	    break;
	case TSENG3:
        case TSENG4:
            switch(whichres)
            {
                case D360x480:
                    break;
                case D640x400:
                    inr.x.ax = 120;
                    svga_height = 400;
                    break;
                case D800x600:
                    inr.x.ax = 0x0030;
                    svga_width = 800;
                    svga_height = 600;
                    break;
                default:
                    inr.x.ax = 0x002E;
                    break;
            }
	    break;
        default:                /* BASIC_VGA */
            whichvga = BASIC_VGA;
            whichres = D320x200;
	    inr.x.ax = 0x0013;	/* setup to VGA 320x200x256 (mode 13H) */
	    svga_width = 320;	/* allow scaling to run at 320x200 */
	    svga_height = 200;
	}

    int86(0x10, &inr, &outr);   /* do the BIOS video mode sel. call */
    if (whichres == D360x480)    /* Tweak VGA registers to get higher res! */
	{
        outpw(SEQUENCER, 0x0604);   /* disable chain 4 */
        outpw(SEQUENCER, 0x0f02);   /* allow writes to all planes */
        for (u = 0; u < 65535; u++) /* clear the whole screen */
        {
	    fp = MK_FP(0xA000, u);
	    *fp = 0;		    /* set all bytes to 0 */
        }
        outpw(SEQUENCER, 0x0C04);   /* enable chain 4 */
	outpw(SEQUENCER, 0x0100);   /* synchronous reset */
	outp(MISCOUT, 0xe7);	    /* use 28 mhz dot clock */
	outpw(SEQUENCER, 0x0300);   /* restart sequencer */
	outp(CRTC, 0x11);	    /* ctrl register 11, please */
	outp(CRTC+1, inp(CRTC+1) & 0x7f); /* write-prot cr0-7 */

	for (i = 0; i < 17; i++)    /* write CRTC register array */
	    outpw(CRTC, vptbl[i]);
	}
     if (whichres == D320x400)    /* Tweak VGA registers to get higher res! */
	{
	outpw(SEQUENCER, 0x0604);   /* disable chain 4 */
	outpw(SEQUENCER, 0x0f02);   /* allow writes to all planes */

        for (u = 0; u < 65535; u++) /* clear the whole screen */
	    {
	    fp = MK_FP(0xA000, u);
	    *fp = 0;		    /* set all bytes to 0 */
	    }

	outp(CRTC, 0x11);	    /* ctrl register 11, please */
	outp(CRTC+1, inp(CRTC+1) & 0x7f); /* write-prot cr0-7 */

	for (i = 0; i < 17; i++)    /* write CRTC register array */
            outpw(CRTC, vptbl2[i]);
        }
     if (whichres == D320x200)    /* Tweak VGA registers for page flipping */
	{
	outpw(SEQUENCER, 0x0604);   /* disable chain 4 */
	outpw(SEQUENCER, 0x0f02);   /* allow writes to all planes */

        for (u = 0; u < 65535; u++) /* clear the whole screen */
	    {
	    fp = MK_FP(0xA000, u);
	    *fp = 0;		    /* set all bytes to 0 */
	    }

	outp(CRTC, 0x11);	    /* ctrl register 11, please */
        outp(CRTC+1, inp(CRTC+1) & 0x7f); /* write-prot cr0-7 */
        /* xmode of 2 seems to work */
        switch(xmode)
        {
            case 0:
                outpw(CRTC, 0x0014);
                outpw(CRTC, 0xa317);
                break;
            case 1:
                outpw(CRTC, 0x4014);
                outpw(CRTC, 0xa317);
                break;
           case 2:
                outpw(CRTC, 0x0014);
                outpw(CRTC, 0xe317);
                break;
            case 3:
                outpw(CRTC, 0x4014);
                outpw(CRTC, 0xe317);
                break;
        }
        }
/*   palette_init(); */  /* if we get here it has a normal 256 color palette DAC */

   if (whichvga == CHIPSTECH) {	/* (not sure why this is necessary) */
      outpw(0x46E8, 0x001E);	/* put chip in setup mode */
      outpw(0x103, 0x0080);	/* enable extended registers */
      outpw(0x46E8, 0x000E);	/* take chip out of setup mode */
      outp(0x3D6, 0x10);
      }

}


int auto_detect_vga()		/* Autodetect (S)VGA Adapter Type */
    {
    return(1);
}




void set_color_map(gif_color_map,colourmap_size)
IMAGE_COLOUR *gif_color_map;
int colourmap_size;
{
    int i;


    for(i = 0; i < colourmap_size ; i++)
    {
        set_palette_register(i,gif_color_map[i].Red,gif_color_map[i].Green,
                                gif_color_map[i].Blue);
    }

}




void display_close()   /* setup to Text 80x25 (mode 3) */
    {
    union REGS inr, outr;
    int adrtop;

    outpw(0x3d4,0x000c);

    set_start_address(0);

	{
	inr.x.ax = 0x0003;
	int86(0x10, &inr, &outr);
	}
    return;
    }

void new_image()
{
    lastline = -1;
}

void display_plot (x, y, color)   /* plot a single color pixel */
   int x, y;
   unsigned char color;
   {
   union REGS inr;
   register unsigned char  svga_page;
   unsigned char _far *fp;
   unsigned int svga_word;
   unsigned long svga_loc;
   DBL h, s, v, fx, fy;

   if (!x)			/* first pixel on this line? */
	{
	lastx = -1;		/* reset cache, make sure we do the 1st one */
	lasty = lastline;	/* set last line do to prior line */
	}

   if (screen_height > svga_height)	/* auto-scale Y */
	{
	fy = (DBL)y / ((DBL)screen_height / (DBL)svga_height);
	y = (int)fy;		/* scale y to svga_height */
	if (y <= lasty)		/* discard if repeated line */
	    return;
	lastline = y;		/* save current working line */
	}

   if (screen_width > svga_width)		/* auto-scale X */
	{
	fx = (DBL)x / ((DBL)screen_width / (DBL)svga_width);
	x = (int)fx;		/* scale x to svga_width */
	if (x <= lastx)		/* discard if repeated pixel */
	    return;
	lastx = x;		/* save most recent pixel done */
	}



   switch (whichvga)	/* decide on (S)VGA bank switching scheme to use */
	{
           case BASIC_VGA:      /* must be like a tweaked mode to page switch */
                svga_word = 1 << (x & 3);       /* form bit plane mask */
                svga_word = (svga_word << 8) | 2;
                outpw(SEQUENCER, svga_word);    /* tweak the sequencer */
                fp = MK_FP(0xA000, (80 * y + (x >> 2)) + ((1 << 15) * page2));
                break;
	   default:		/* actual bank switch for all SVGA cards */
		svga_loc=((unsigned long)svga_width) * y + x;
		svga_page=(unsigned char)(svga_loc/gran);
                svga_loc %= gran;
                if(page2)                   /* if writing to second "page" */
                {
                     if(size_1024k)           /* second page starts at half */
                        svga_page += 8;     /* the max mem size */
                     if(size_512k)
                        svga_page += 4;
                }
		if (cur_page != svga_page)	/* if not in correct bank */
		{
                     /*   _disable(); */
		    cur_page = svga_page;	/* set new working bank */
		    newbank();
                    /*    _enable(); */
		}
		fp = MK_FP(0xA000, (unsigned int)svga_loc);
		break;
	}

   *fp = color;		/* write normalized pixel color val to bitplane */

   return;
   }

void newbank()		/* Perform SVGA bank switch on demand - Voila! */
{
    register unsigned char tmp_byte, tmp_byte1;
    register unsigned int tmp_word;
    union REGS regs;
    static unsigned char xlateT3[] = {0x40, 0x49, 0x52, 0x5B, 0x64, 0x6D,
	    0x76, 0x7F};
    static unsigned char xlateT4[] = {0x00, 0x11, 0x22, 0x33, 0x44, 0x55,
	    0x66, 0x77, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF};


    switch (whichvga)
        {
	case VDC600:			/* AT&T VDC 600 */
	    tmp_byte = (unsigned char) (cur_page << 4);	/* was >> 12... */
	    outpw(0x03CE,0x050F);
	    outp(0x03CE,0x09);
	    outp(0x03CF, tmp_byte);
	    break;
	case OAKTECH:			/* Oak Technology OTI-067 */
	    tmp_byte = (unsigned char)(cur_page & 0x0F);
	    outp(0x3DF, (tmp_byte << 4) | tmp_byte);
	    break;
	case AHEADA:			/* Ahead Systems Ver A */
	    outpw(0x3CE, 0x200F);	/* enable extended registers */
	    tmp_byte = (unsigned char)(inp(0x3CC) & 0xDF);  /* bit 0 */
	    if (cur_page & 1)
		    tmp_byte |= 0x20;
	    outp(0x3C2, tmp_byte);
	    outp(0x3CF, 0);		   /* bits 1, 2, 3 */
	    tmp_word = (unsigned int)((cur_page >> 1 )|(inp(0x3D0) & 0xf8));
	    outpw(0x3CF, tmp_word << 8);
	    break;
	case AHEADB:			/* Ahead Systems Ver B */
	    outpw(0x3CE, 0x200F);	/* enable extended registers */
	    tmp_word = (unsigned int)((cur_page << 4) | cur_page);
	    outpw(0x3CF, (tmp_word << 8) | 0x000D);
	    break;
	case EVEREX:			/* Everex SVGA's */
	    outp(0x3C4, 8);
	    if (cur_page & 1)
		 tmp_word = (unsigned int)(inp(0x3C5) | 0x80);
	    else tmp_word = (unsigned int)(inp(0x3C5) & 0x7F);
	    outpw(0x3C4, (tmp_word << 8) | 0x0008);
	    tmp_byte = (unsigned char)(inp(0x3CC) & 0xDF);
	    if (!(cur_page & 2))
		 tmp_byte |= 0x20;
	    outp(0x3C2, tmp_byte);
	    break;
	case ATIVGA:			/* ATI VGA Wonder */
	    outp(0x1CE, 0xB2);
	    tmp_word = (unsigned int)((cur_page << 1) | (inp(0x1CF) & 0xE1));
	    outpw(0x1CE, (tmp_word << 8) | 0x00B2);
	    break;
	case TRIDENT:
	    outp(0x3CE, 6);		/* set page size to 64K */
	    tmp_word = (unsigned int)(inp(0x3CF) | 4) << 8;
	    outpw(0x3CE, tmp_word | 0x0006);
	    outp(0x3C4, 0x0b);		/* switch to BPS mode */
	    inp(0x3C5);			/* dummy read?? */
	    tmp_word = (unsigned int)(cur_page ^ 2) << 8;
	    outpw(0x3C4, tmp_word | 0x000E);
	    break;
	case VIDEO7:			/* Video-7 VRAM, FastRAM SVGA cards */
	    tmp_byte1 = tmp_byte = (unsigned char)(cur_page & 0x0F);
	    outpw(0x3C4, 0xEA06);
	    tmp_word = (unsigned int)(tmp_byte & 1) << 8;
	    outpw(0x3C4, tmp_word | 0x00F9);
	    tmp_byte &= 0x0C;
	    tmp_word = (unsigned int)(tmp_byte >> 2 | tmp_byte) << 8;
	    outpw(0x3C4, tmp_word | 0x00F6);
	    tmp_word |= (inp(0x3C5) & 0xF0) << 8;
	    outpw(0x3C4, tmp_word | 0x00F6);
	    tmp_byte = (unsigned char)((tmp_byte1 << 4) & 0x20);
	    outp(0x3C2, (inp(0x3CC) & 0xDF) | tmp_byte);
	    break;
	case CHIPSTECH:			/* Chips & Technology VGA Chip Set */
/*	    outpw(0x46E8, 0x001E);	* put chip in setup mode */
/*	    outpw(0x103, 0x0080);	* enable extended registers */
/*	    outpw(0x46E8, 0x000E);	* take chip out of setup mode */
/*	    tmp_word = (unsigned int)(cur_page << 2) << 8; * 64K -> 16K */
/*	    outpw(0x3D6, tmp_word | 0x0010); */
            outpw(0x3D6, ((cur_page << 2) << 8) | 0x10); /* this is all that's necessary?? */
	    break;
	case PARADISE:			/* Paradise, Professional, Plus */
	    outpw(0x3CE, 0x050F);	/* turn off VGA reg. write protect */
	    tmp_word = (unsigned int)(cur_page << 4) << 8;
	    outpw(0x3CE, tmp_word | 0x0009);
	    break;
	case TSENG3:			/* Tseng 3000 - Orchid, STB, etc. */
/*	    tmp_byte = (unsigned char)(cur_page & 0x07); */
/*	    tmp_byte1 = (unsigned char)((tmp_byte << 3) | tmp_byte); */
/*	    outp(0x3CD, tmp_byte1 | 0x40);		 */
	    outp(0x3CD, xlateT3[cur_page & 0x07]);
	    break;
	case TSENG4:			/* Tseng 4000 - Orchid PD+, etc. */
/*	    tmp_byte = (unsigned char)(cur_page & 0x0F); */
/*	    tmp_byte1 = (unsigned char)((tmp_byte << 4) | tmp_byte); */
/*	    outp(0x3BF, 3);		* enable access to extended regs */
/*	    outp(0x3D8, 0xA0);		* this may not be necessary! */
/*		outp(0x3CD, tmp_byte1); */
	    outp(0x3CD, xlateT4[cur_page & 0x0F]);
	    break;
        }
    return;
}

void set_palette_register (Val, Red, Green, Blue)
   unsigned Val;
   unsigned Red, Green, Blue;
   {
   union REGS Regs;

   Regs.x.ax = 0x1010;              /* Set one palette register function */
   Regs.x.bx = Val;                 /* the palette register to set (color#)*/
   Regs.h.dh = (char)(Red >> 2);  /* set the gun values (6 bits ea.) */
   Regs.h.ch = (char)(Green >> 2);
   Regs.h.cl = (char)(Blue >> 2);
   int86(0x10, &Regs, &Regs);       /* Do the video interrupt */
   }


void set_image_1()
{
    int bank;

    page2 = 0;
    if(size_512k)
        bank = 4;
    if(size_1024k)
        bank = 8;
    if(!size_1024k && !size_512k)
        bank = 1;

    bank = bank * page2;
    set_start_address(bank);            /* change picture on display */

    if(invert_image )    /* set the glasses */
        outp(port_adr, image_2_byte);
    else
        outp(port_adr, image_1_byte);
}

void set_image_2()
{
    int bank;


    page2 = 1;
    if(size_512k)
        bank = 4;
    if(size_1024k)
        bank = 8;
    if(!size_1024k && !size_512k)
        bank = 1;

    bank = bank * page2;
    set_start_address(bank);            /* change picture on display */

    if(invert_image )    /* set the glasses */
        outp(port_adr, image_1_byte);
    else
        outp(port_adr, image_2_byte);
}

void set_start_address(bank)
int bank;
{
    int adrtop;
    int temp_word;

    switch(whichvga)
    {
        case BASIC_VGA:
            if(bank)
                outpw(0x3d4, 0x800c);
            else
                outpw(0x3d4, 0x000c);
            break;
        case TSENG3:
        case TSENG4:
            outp(0x3d4,0x33);
            adrtop =  (bank >> 2);
            outp(0x3d5,adrtop);
            break;
        case VIDEO7 :
            outpw(0x3C4, 0xEA06);
            outp(0x3c4,0xf6);
            adrtop = inp(0x3c5);
            adrtop = adrtop | (bank >> 2) << 4;
            outp(0x3c5,adrtop);
            break;
        case TRIDENT:
            adrtop = (bank >> 2) ;
            outp(0x3CE, 6);             /* set page size to 64K */
            temp_word = (unsigned int)(inp(0x3CF) | 4) << 8;
            outpw(0x3CE, temp_word | 0x0006);
            outp(0x3C4, 0x0b);          /* switch to BPS mode */
            outp(0x3c5,0);              /* put in old mode */
            outp(0x3c4,0x0e);
            temp_word = inp(0x3c5);
            temp_word &= 0xfe;
            temp_word |= adrtop > 1;
            outp(0x3c5,temp_word);       /* set '512' bit in old mode */
            outp(0x3d4,0x1e);
            temp_word = inp(0x3d5);
            temp_word = ((temp_word | 0x80) & 0x20) | (adrtop & 1);
            outp(0x3d5,temp_word);
            break;
        case CHIPSTECH:
            outp(0x3d6,0x4);
            temp_word = inp(0x3d7);
            temp_word |= 4;
            outp(0x3d7,temp_word);
            outp(0x3d6,0x0c);
            outp(0x3d7, (bank >> 2) );
            break;
        case PARADISE:
            outp(0x3ce,0x0d);
            temp_word = inp(0x3cf);
            temp_word &= 0xe3;
            temp_word |= (bank >> 2) << 3;
            outp(0x3cf,temp_word);
            break;
        case ATIVGA:
            adrtop = bank >> 2;
            outp(0x1ce,0xb6);
            temp_word = inp(0x1cf);
            temp_word &= 0xfe;
            temp_word |= 1;
            outp(0x1cf,temp_word);
            outp(0x1ce,0xb0);
            temp_word = inp(0x1cf);
            temp_word &= 0xbf;
            temp_word |= ((adrtop & 1) << 6);
            outp(0x1cf,temp_word);
            outp(0x1ce,0xa3);
            temp_word = inp(0x1cf);
            temp_word &= 0xef;
            temp_word |= ((adrtop & 2) << 3);
            outp(0x1cf,temp_word);
            break;

    }
}


#if !__STDC__

/* ANSI Standard psuedo-random number generator */

static unsigned long int next = 1;

int rand()
   {
   next = next * 1103515245L + 12345L;
   return ((int) (next / 0x10000L) & 0x7FFF);
   }

void srand(seed)
   unsigned int seed;
   {
   next = seed;
   }

#endif



/* Math Error exception struct format:
	int type;		- exception type - see below
	char _FAR_ *name;	- name of function where error occured
	long double arg1;	- first argument to function
	long double arg2;	- second argument (if any) to function
	long double retval;	- value to be returned by function
*/

#ifdef __WATCOMC__
#define EDOM	7	/* MSC is 33 */
#define ERANGE	8	/* MSC is 34 */

int matherr(e)
#else
int _cdecl matherr(e)
#endif
   struct exception *e;
   {

   return (1);	/* Indicate the math error was corrected... */
   }
