/**********************************************************************
MPEG-4 Audio VM

This software module was originally developed by
  Y.B. Thomas Kim and S.H. Park (Samsung AIT)
and edited by
  Y.B. Thomas Kim (Samsung AIT) on 1997-11-06

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.

**********************************************************************/

#ifndef	_sam_dec_h_
#define	_sam_dec_h_

#include "common.h"
#include "bitstream.h"
#include "tf_main.h"
#include "sam_tns.h"

#ifdef __cplusplus
extern "C" {
#endif


/* --- Init BSAC-decoder --- */
void sam_decode_init(void);

/* ----- Decode one frame with the BSAC-decoder  ----- */
int	sam_decode_frame(
	BsBitStream *fixed_stram,
	BsBitStream *gc_sttram[MAX_TIME_CHANNELS],
	int	target_br,
	double	**coef,
	int	*block_type,
	Window_shape *window_Shape);

int sam_decode_bsac_data(int target_br,
	int stereo_mode,
	int windowSequence[],
	int scalefactors[][112],
	int groupInfo[][7],
	int samples[][1024],
	int maxSfb[],
	int maxScalefactor[],
	int	ms_mask[],
	int	is_info[],
	int	nch);

void sam_decode_bsac_stream(
	int	windowSequence[],
	int enc_scale,
	int target,
	int samples[][1024],
	int maxScalefactor[],
	int scalefactors[][112],
	int maxSfb[],
	int	groupInfo[][7],
	int	ms_mask[],
	int	stereo_mode,
	int	is_info[],
	int	swb_offset[][114],
	int frameLength,
	int	nch);

void sam_dequantization(int target_br,
	int windowSequence,
	int scalefactors[],
	int groupInfo[],
	int samples[],
	int maxSfb,
	int	is_info[],
	float spectrums[],
	int ch);

void sam_intensity(int windowSequence,
	int	groupInfo[],
	float spectrum[][1024],
	int	factors[][112],
	int is_info[], 
	int	ms_mask[],
	int	pred[][50],
	int	maxSfb);

void sam_ms_stereo(int windowSequence,
	int groupInfo[],
	float spectrum[][1024],
	int ms_mask[],
	int maxSfb);

void sam_prediction(int windowSequence, int lpflag[], float coef[], int ch);
void sam_predict(int windowSequence, int lpflag[], float coef[], int sfb[], int ch);
void sam_predict_reset(int windowSequence, int prstflag[], int ch);

void sam_tns_data(int windowSequence, int maxSfb, float spect[1024], sam_TNS_frame_info *tns);
void sam_tns_decode_subblock(int windowSequence, float *spec, int maxSfb, int *sfbs, sam_TNSinfo *tns_info);

int sam_get_region_info(int *groupInfo, int *startRegion, int *endRegion);

void sam_start_decoding(int , int);
int sam_decode_symbol(int *, int *, double *);

int sam_i2cb(int ch, int i);
void sam_setBsacdec2BitBuffer(BsBitStream *fixed_stream);
long sam_getbits(int n);
int sam_getUsedBits(void);
void sam_predinit(void);

#ifdef __cplusplus
}
#endif

#endif /* #ifndef	_sam_dec_h_ */
