C     ***************
      SUBROUTINE INIT(
C     ***************
     >                NX,NY,NZ,NT,
     >                NXYZH,NXYTH,NXZTH,NYZTH,
     >                NXYH,NXZH,NXTH,NYZH,NYTH,NZTH,
     >                NXE,NXYE,NXYZE,
     >                NVH,NVE,NXYZ,
     >                SEED,START,
     >                LINKS,WK1,
     >                GCB,GTS,LCB,
     >                GX,GY,GZ,GT,
     >                GXY,GXZ,GXT,GYZ,GYT,GZT,
     >                LX,LY,LZ,LT,
     >                LXY,LXZ,LXT,LYZ,LYT,LZT)
C
C
C     SUBROUTINE INIT  GENERATES  THE INITIAL LATTICE CONFIGURATION AND
C     PREPARES INDEX LISTS FOR GATHERING THE TWO DIFFERENT  CHESS BOARD
C     COLOURS . IT ALTHOUGH GENERATES INDEX LISTS FOR  GATHERING  THOSE
C     LINK  VARIABLES  WHICH  HAVE  TO  BE  EXCHANGED WITH NEIGHBOURING
C     PROCESSES   DURING   THE  LINK   UPDATE.   THE  CHOICE  OF  START
C     CONFIGURATION IS CONTROLED BY THE VARIABLE 'START'  ( 1 : ORDERED
C     START, 0 : DISORDERED START ).  THE   RANDOM  NUMBER GENERATOR IS
C     INITIALIZED BY THE VARIABLE 'SEED'.
C
C
C     LATEST REVISION - NOV. 1989; E.KEHL
C
C
      DOUBLE PRECISION     LINKS(NVE,18,4),
     >                     WK1(NVH,18),
     >                     ZERO,ONE
C
C
      INTEGER  GCB(NVH,2),GTS(NXYZ),
     >         LCB(2),
     >         SEED,START
C
      INTEGER  GX(NYZTH,2,4),GY(NXZTH,2,4),
     >         GZ(NXYTH,2,4),GT(NXYZH,2,4)
C
      INTEGER  GXY(NZTH,2,4),GXZ(NYTH,2,4),
     >         GXT(NYZH,2,4),GYZ(NXTH,2,4),
     >           GYT(NXZH,2,4),GZT(NXYH,2,4)
C
      INTEGER  LX(2,4),LY(2,4),
     >         LZ(2,4),LT(2,4)
C
      INTEGER  LXY(2,4),LXZ(2,4),
     >         LXT(2,4),LYZ(2,4),
     >         LYT(2,4),LZT(2,4)
C
      INTEGER  FX(4),FY(4),FZ(4),FT(4)
C
C
      PARAMETER( ZERO = 0.D0 )
      PARAMETER( ONE  = 1.D0 )
C
C
C     DEFINITION OF STATEMENT FUNCTION LPA (LATTICE POINT ADDRESS):
C
C
      LPA(IX,IY,IZ,IT) = IX + ( IY - 1 ) * NXE + ( IZ - 1 ) * NXYE  +
     >                                           ( IT - 1 ) * NXYZE
C
C
C     INITIALIZATION OF THE RANDOM NUMBER GENERATOR
C
C
      CALL VDRSET(SEED)
C
C
C     GENERATION OF INDEX LISTS FOR GATHERING LINK VARAIABLES OF
C     EVEN OR ODD LATTICE POINTS
C
C
C     **********
      CALL HYPPL(
C     **********
     >           NXE,NXYE,NXYZE,
     >           GCB,LCB,NVH,2,2,2,2,NX+1,NY+1,NZ+1,NT+1 )
C
C
C     GENERATION OF AN INDEX LIST FOR GATHERING THE LOWEST T-SLICE
C
C
      ILP = 0
C
      DO 10 K = 2,NZ+1
      DO 10 J = 2,NY+1
      DO 10 I = 2,NX+1
C
      ILP = ILP + 1
      GTS(ILP) = LPA(I,J,K,2)
C
   10 CONTINUE
C
C
C     GENERATION OF INDEX LISTS FOR SENDING (RECEIVING) HYPERPLANES
C
C
      FX(1) = NX + 1
      FX(2) = 2
      FX(3) = 1
      FX(4) = NX + 2
C
      FY(1) = NY + 1
      FY(2) = 2
      FY(3) = 1
      FY(4) = NY + 2
C
      FZ(1) = NZ + 1
      FZ(2) = 2
      FZ(3) = 1
      FZ(4) = NZ + 2
C
      FT(1) = NT + 1
      FT(2) = 2
      FT(3) = 1
      FT(4) = NT + 2
C
C
C     **********
      CALL HYP3D(
C     **********
     >           NX,NY,NZ,NT,
     >           NXYZH,NXYTH,NXZTH,NYZTH,
     >           NXE,NXYE,NXYZE,
     >           GX,GY,GZ,GT,
     >           LX,LY,LZ,LT,
     >           FX,FY,FZ,FT )
C
C
C     **********
      CALL HYP2D(
C     **********
     >           NX,NY,NZ,NT,
     >           NXYH,NXZH,NXTH,NYZH,NYTH,NZTH,
     >           NXE,NXYE,NXYZE,
     >           GXY,GXZ,GXT,GYZ,GYT,GZT,
     >           LXY,LXZ,LXT,LYZ,LYT,LZT,
     >           FX,FY,FZ,FT )
C
C
C     GENERATION OF START CONFIGURATION
C
C
      DO 15 ILD = 1,4
      DO 15 ISM = 1,18
      DO 15 IVL = 1,NVE
   15 LINKS(IVL,ISM,ILD) = ZERO
C
C
      IF( START .EQ. 1 ) THEN
C
C
C         ORDERED START
C
C
          DO 20 ILD = 1,4
          DO 20 L   = 2,NT+1
          DO 20 K   = 2,NZ+1
          DO 20 J   = 2,NY+1
          DO 20 I   = 2,NX+1
C
             LPX = LPA(I,J,K,L)
C
             LINKS(LPX,1,ILD) = ONE
             LINKS(LPX,5,ILD) = ONE
             LINKS(LPX,9,ILD) = ONE
C
  20      CONTINUE
C
      ENDIF
C
      IF( START .EQ. 0 ) THEN
C
C
C         DISORDERED START
C
C
          DO 30 ILD = 1,4
          DO 30 ICC = 1,2
C
C
C            RANDOM CHOICE OF THE FIRST TWO COLUMNS OF WK1
C
C
             DO 40 ISM = 1,6
                CALL VDRAND( NVH,WK1(1,ISM  ) )
                CALL VDRAND( NVH,WK1(1,ISM+9) )
   40        CONTINUE
C
C
C         ***********
          CALL RENORM( NVH,WK1 )
C         ***********
C
C
          NVL = LCB(ICC)
C         ***********
          CALL SCATER( NVE,NVL,LINKS(1,1,ILD),NVH,WK1,GCB(1,ICC),0 )
C         ***********
C
C
   30     CONTINUE
C
      ENDIF
C
C
      RETURN
      END
