C     ****************
      SUBROUTINE CRTPG(
C     ****************
     >                 NS,NT,NP,
     >                 NPX,NPY,NPZ,NPT,
     >                 LPX,LPY,LPZ,LPT,
     >                 ICCOS            )
C
C
      INTEGER    LPX(0:NPX),LPY(0:NPY),LPZ(0:NPZ),LPT(0:NPT),
     >           ICCOS(NP)
C
C
C     PARTITION THE LATTICE
C
C
      DO 1 I=1,NPX
      LPX(I) = NS / NPX
    1 CONTINUE
      DO 2 J=1,NPY
      LPY(J) = NS / NPY
    2 CONTINUE
      DO 3 K=1,NPZ
      LPZ(K) = NS / NPZ
    3 CONTINUE
      DO 4 L=1,NPT
      LPT(L) = NT / NPT
    4 CONTINUE
C
      NRX = NS - LPX(1) * NPX
      NRY = NS - LPY(1) * NPY
      NRZ = NS - LPZ(1) * NPZ
      NRT = NT - LPT(1) * NPT
C
      DO 10 IX = 1,NRX
      LPX(IX) = LPX(IX) + 1
   10 CONTINUE
C
      DO 20 IY = 1,NRY
      LPY(IY) = LPY(IY) + 1
   20 CONTINUE
C
      DO 30 IZ = 1,NRZ
      LPZ(IZ) = LPZ(IZ) + 1
   30 CONTINUE
C
      DO 40 IT = 1,NRT
      LPT(IT) = LPT(IT) + 1
   40 CONTINUE
C
C
C     CALCULATE THE CHESS BOARD COLOUR OFFSET
C
C
      LPX(0) = 0
      LPY(0) = 0
      LPZ(0) = 0
      LPT(0) = 0
C
C
C     LATTICE COORDINATES
C
C
      LPTS = 1
      DO 50 IT = 1,NPT
      LPTS = LPTS + LPT( IT-1 )
C
      LPZS = 1
      DO 60 IZ = 1,NPZ
      LPZS = LPZS + LPZ( IZ-1 )
C
      LPYS = 1
      DO 70 IY = 1,NPY
      LPYS = LPYS + LPY( IY-1 )
C
      LPXS = 1
      DO 80 IX = 1,NPX
      LPXS = LPXS + LPX( IX-1 )
C
C
C     EVEN OR ODD
C
C
      LPS  = LPXS + LPYS + LPZS + LPTS
      LPC  = LPS  / 2
      LPC  = LPC  * 2
C
      IP = IX + ( IY - 1 ) * NPX + ( IZ - 1 ) * NPX * NPY
     >                           + ( IT - 1 ) * NPX * NPY * NPZ
C
      IF( LPC .EQ. LPS ) THEN
          ICCOS(IP) = 0
      ELSE
          ICCOS(IP) = 1
      ENDIF
C
   80 CONTINUE
   70 CONTINUE
   60 CONTINUE
   50 CONTINUE
C
C
      RETURN
      END
