
      SUBROUTINE FLOPS(IO,NC,TSTEPS,RCUT,TIME)

      INTEGER     IO, NC, NTOT, TSTEPS
      REAL        RCUT, BOXLX, BOXLY, BOXLZ
      DOUBLE PRECISION TIME
      INTEGER     NPROSX, NPROSY, NPROSZ

      COMMON/PROCS/NPROSX,NPROSY,NPROSZ

      PARAMETER(PIRED = 88/21)

      NTOT = 4*NC*NC*NC

      BOXLX = 1.0/NPROSX
      BOXLY = 1.0/NPROSY
      BOXLZ = 1.0/NPROSZ

      MX = INT(BOXLX/RCUT)+2
      MY = INT(BOXLY/RCUT)+2
      MZ = INT(BOXLZ/RCUT)+2

      MULT = (MX-2)*(MY-2)*(MZ-2)
      MXRED = MX-4
      MYRED = MY-4
      MZRED = MZ-4

      NCMARK = NTOT/(MULT*NPROSX*NPROSY*NPROSZ)
      FORCE1 = (PIRED*MULT*RCUT**3)/(27*BOXLX*BOXLY*BOXLZ)
      FORCE2 = (8+4*(MXRED+MYRED+MZRED)+
     1        2*(MXRED*MYRED+MXRED*MZRED+MYRED*MZRED))/MULT
      FORCE3 = (FORCE1*5*13*NCMARK*MXRED*MYRED*MZRED)/MULT
     
      FCOUNT = 30*NTOT+13.5*NTOT*NCMARK*((9+35*FORCE1)*
     1         (FORCE2+1)+5*FORCE1*FORCE3)

      BENCH=TSTEPS*FCOUNT/TIME/1E6
      SIMBEN=0.03*TSTEPS/TIME

      WRITE(IO,*)
      WRITE(IO,*)'CALCULATION FINISHED.'
      WRITE(IO,*)
      WRITE(IO,*)'Data type - REAL*4'
      WRITE(IO,*)'TOTAL NUMBER OF NOMINAL FLOPS  = ',INT(FCOUNT),' flop'
      WRITE(IO,*)'NUMBER OF TIME-STEPS           = ',TSTEPS,' tstep'
      WRITE(IO,*)
      WRITE(IO,*)'********************************************'
      WRITE(IO,*)
      WRITE(IO,'( 4(A, F7.3, A/))')
     *     'ELAPSED TIME            =',TIME,' s' ,
     *     'TEMPORAL PERFORMANCE    =',TSTEPS/TIME,' tstep/s',
     *     'SIMULATION PERFORMANCE  =',SIMBEN,' sim-ps/s',
     *     'BENCHMARK PERFORMANCE   =',BENCH,' Mflop/s'
      WRITE(IO,*)
      WRITE(IO,*)'********************************************'

      END
