/* PVM testing routines version 1.0 */

#include <stdio.h>
#include <pvm3.h>
#include <stdlib.h>
#include <sys/time.h> 
#include "inc.h"
#define malloc(n)  pvm_alloc((n),"xxx") 
#define free(p)    pvm_free(p) 

#define JOINED   10
#define BYE      12
#define TESTMSG  11
#define RECVD    12
#define HOSTNO   13
#define CIRCLED  10
#define PASSITON 11
#define GRP_SIZE 12
#define BUF_TEST 15
#define PAR_TID  24
#define RESULT   25
#define MY_TEST  27
#define PAR_TEST 26
#define FIVE_WAIT 10000000
#define WAIT      3000000
#define SNOOZ     3
#define VTST     17

main(argc,argv)
int argc;
char **argv;
{

/* section A (test selection and execution) */


  if (strcmp(argv[1],"test08") == 0)
    test08_sl();
  else if (strcmp(argv[1],"test10") == 0)
    test10_sl();
  else if (strcmp(argv[1],"test15") == 0)
    test15_sl();
  else if (strcmp(argv[1],"test16") == 0)
    test16_sl();
  else if (strcmp(argv[1],"test17") == 0)
    test17_sl();
  else if (strcmp(argv[1],"test18") == 0)
    test18_sl();
  else if (strcmp(argv[1],"test19") == 0)
    test19_sl();
  else if (strcmp(argv[1],"test22") == 0)
    test22_sl();
  else if (strcmp(argv[1],"test24") == 0)
    test24_sl();
  else if (strcmp(argv[1],"test25") == 0)
    test25_sl();
  else if (strcmp(argv[1],"test28") == 0)
    test28_sl();
  else if (strcmp(argv[1],"test29") == 0)
    test29_sl();
  else if (strcmp(argv[1],"msgslv") == 0)
    msgtst_sl();
  else if (strcmp(argv[1],"version_slv") == 0)
    version_slv();
  else if (strcmp(argv[1],"testver") == 0)
    testver();

/* section A end */

  pvm_exit();
  exit(0);
}


int testver()
{
  int mytid, par_tid;
  char ver[25];

  mytid   = pvm_mytid();
  par_tid = pvm_parent();
  strcpy(ver,"1.0");

  pvm_initsend(0);
  pvm_pkstr(ver);
  pvm_send(par_tid, VTST);
}

int version_slv()
{
  int mytid, par_tid;
  char ver[25];

  mytid   = pvm_mytid();
  par_tid = pvm_parent();
  strcpy(ver,pvm_version());

  pvm_initsend(0);
  pvm_pkstr(ver);
  pvm_send(par_tid, VTST);
}
  
int test08_sl()
{
	int mytid;
	int par_tid;

	mytid = pvm_mytid();
	par_tid = pvm_parent();

	pvm_joingroup("testgrp8");
	pvm_initsend(0);
	pvm_send(par_tid, JOINED);
	pvm_recv(-1, BYE);
	pvm_lvgroup("testgrp8");

}

int test10_sl()
{
	int mytid;
	int parent;
	int inum;

	mytid = pvm_mytid();
	parent = pvm_parent();
	inum = pvm_joingroup("testgrp10");
	pvm_initsend(0);
	pvm_send(parent, JOINED);
	pvm_recv(parent, BYE);
	pvm_lvgroup("testgrp10");

}


/*
 * slave for testing group bcast
 */

int test15_sl()
{
	int mytid, parent;
	int inum;

	mytid = pvm_mytid();
	parent = pvm_parent();
	inum = pvm_joingroup("testgrp15");
	pvm_initsend(0);
	pvm_send(parent, JOINED);
	pvm_recv(parent, TESTMSG);
	pvm_initsend(0);
	pvm_send(parent, RECVD);
	pvm_lvgroup("testgrp15");

}





/*
 * slave for testing group bcast
 */

int test16_sl()
{
	int mytid;
	int parent;
	int inum;
	int nhost;

	mytid = pvm_mytid();
	parent = pvm_parent();
	pvm_recv(parent, HOSTNO);
	pvm_upkint(&nhost,1,1);
	inum = pvm_joingroup("testgrp16");
	pvm_barrier("testgrp16",nhost+1);
	pvm_lvgroup("testgrp16");

}

int test17_sl()
{
	int mytid;
	int parent;
	int inum;
	int nhost;
	int inst;
	int next_inst;
	int next_tid;

	mytid = pvm_mytid();
	parent = pvm_parent();
	inum = pvm_joingroup("testgrp17");
	pvm_recv(-1, GRP_SIZE);
	pvm_upkint(&nhost,1,1);
	pvm_barrier("testgrp17", nhost);
	inst = pvm_getinst("testgrp17", mytid);
	pvm_initsend(0);
	if (inst == (nhost-1))
	    next_inst = 0;
	else
	    next_inst = inst+1;
	next_tid = pvm_gettid("testgrp17", next_inst);
	if (inst == 0) {
	    pvm_send(next_tid, PASSITON);
	    pvm_recv(-1, PASSITON);
	    pvm_initsend(0);
	    pvm_send(parent, CIRCLED);
	}
	else {
	    pvm_recv(-1, PASSITON);
	    pvm_send(next_tid, PASSITON);
	}
	pvm_lvgroup("testgrp17");

}

int test18_sl()
{
	int mytid;
	int parent;
	int inum;
	int nhost;
	int inst;
	int next_inst;
	int next_tid;

	mytid = pvm_mytid();
	parent = pvm_parent();
	inum = pvm_joingroup("testgrp18");
	pvm_initsend(0);
	pvm_send(parent, JOINED);
	pvm_recv(-1, BYE);
	pvm_lvgroup("testgrp18");

}

int test19_sl()
{
	int mytid;
	int parent;
	int inum;
	int nhost;
	int inst;
	int next_inst;
	int next_tid;

	mytid = pvm_mytid();
	parent = pvm_parent();
	inum = pvm_joingroup("testgrp19");
	pvm_initsend(0);
	pvm_send(parent, JOINED);
	pvm_recv(-1, BYE);
	pvm_lvgroup("testgrp19");

}

int test22_sl()
{
	int mytid;
	int parent;


	mytid = pvm_mytid();
	parent = pvm_parent();
	pvm_initsend(0);
	pvm_send(parent, BUF_TEST);

}

int test24_sl()
{
	int mytid;
	int parent;
	int tparent;
	int no=0;
	int yes=1;

	mytid = pvm_mytid();
	parent = pvm_parent();
	pvm_recv(-1, PAR_TID);
	pvm_upkint(&tparent,1,1);
	pvm_initsend(0);
	if (tparent == parent)
	    pvm_pkint(&yes,1,1);
	else
	    pvm_pkint(&no,1,1);
	pvm_send(parent,RESULT);

}



int test25_sl()
{
	int mytid;
	int partid, cnt, i;

	mytid = pvm_mytid();
	partid = pvm_parent();

	pvm_initsend(0);
	pvm_pkint(&mytid,1,1);
	pvm_send(partid,MY_TEST);
        for (i = 0; i < FIVE_WAIT; i++)
           cnt = 1;  
	pvm_initsend(0);
	pvm_pkint(&partid,1,1);
	pvm_send(partid,PAR_TEST);

}


int test28_sl()
{
	int mytid;

	mytid = pvm_mytid();
	for (;;);
}


int test29_sl()
{

  int mytid, i, cnt;

  mytid = pvm_mytid();

  for (i = 0; i < WAIT; i++)
     cnt = 1;  

}


int msgtst_sl()
{
    int mytid;                                     /* my task id */
    int *tids,k;                                     /* task ids   */
    int temp,j,n, me, i, nproc, master, msgtype, size, code;
    int *intres, broad, who, mess, sndme, bytes, stat;
    int fltsiz, intsiz, dblsiz, lngsiz, shtsiz, bytsiz, cpxsiz;
    int dcxsiz, strsiz,sum,crc,cnt=0,direct,oldval, tstmod, bufid;
    int uinsiz, ushsiz, ulnsiz, gsize,parent,ptid,err=0;
    int crccnt = 0, crcc[100], crcerr, crcr[100],cntr=0;
    unsigned int *uinres; 
    float *fltres,dec,*cpxres;
    double *dblres,*dcxres;
    float fnltim=0.0,sec,usec;
    char strres[12],pack[3],*bytres,*buf,loc[256],where[256],packer[10];
    char tmp[500];
    long *lngres,elpstim;
    struct timeval etime[2], stime[2];
    unsigned long *ulnres;
    short *shtres;
    unsigned short *ushres;
    FILE *sout,*dfp;

    /* enroll in pvm */

    mytid = pvm_mytid();
    if (mytid < 0) 
    {
      sprintf(loc,"ERROR ENROLLING SLAVE IN PVM (SLAVE)");
      pvm_perror( loc );
    }

    master = pvm_parent();
    if (master < 0)
    {
      sprintf(loc,"ERROR OBTAINING PARENT'S TASK ID (SLAVE)");
      pvm_perror( loc );
    }      

    /* Receive initial data from master */

    bufid = pvm_recv( -1, -1 );
    if (bufid < 0)
    {
      sprintf(loc,"ERROR RECEIVING INIT DATA (SLAVE)");
      pvm_perror( loc );
    }

    stat = pvm_bufinfo( bufid, &bytes, &msgtype, &master);
    if (stat < 0)
    {
      sprintf(loc,"ERROR GETTING BUFFER INFO FOR INIT DATA (SLAVE)");
      pvm_perror( loc );
    }


    stat = pvm_setrbuf( bufid );
    if (stat < 0)
    {
      sprintf(loc,"ERROR SETTING RECEIVE BUFFER FOR INIT DATA (SLAVE)");
      pvm_perror( loc );
    } 

    /* unpack init data from master */

    strcpy(packer,"SLAVE");

    msgtype = 0;

    stat = pvm_upkint(&nproc, 1, 1);
    if (stat < 0)
    {
      sprintf(loc,"ERROR UNPACKING INIT DATA [# OF PROCESSES] (%s)",packer);
      pvm_perror( loc );
    }

    tids = (int *)malloc(nproc*sizeof(int));

    unpackdat( &size, &me, &mess, crcr, intres, fltres, dblres, strres,
               lngres, shtres, bytres, cpxres, dcxres, uinres, ushres,ulnres,
               &nproc, pack,&broad, &code, &direct, tids, &n, &tstmod, 
               msgtype, packer );

    /* clear receive buffer for init data */
 
    stat = pvm_freebuf( bufid );
    if (stat < 0)
    {
      sprintf(loc,"ERROR CLEARING RECEIVE BUFFER FOR INIT DATA (SLAVE)");
      pvm_perror ( loc );
    }

    
    /* implement routing options selected by user */

    if (direct == 1)
    {
      oldval = pvm_setopt(PvmRoute, PvmDontRoute);
      if (oldval < 0)
      {
        sprintf(loc,"ERROR SELECTING DAEMON ROUTING (SLAVE)");
        pvm_perror( loc );
      }
    }
    if (direct == 2)
    {
      oldval = pvm_setopt(PvmRoute, PvmRouteDirect);
      if (oldval < 0)
      {
        sprintf(loc,"ERROR SELECTING DIRECT ROUTING (SLAVE)");
        pvm_perror( loc );
      }
    }

    /* Determine which slave I am (0 -- nproc-1) */

    for( i=0; i<nproc ; i++ ){
       if( mytid == *(tids+i) ){ me = i; break; }
    }


    sprintf(packer,"SLAVE%d",me);

    if (tstmod == 1)
    {
      stat = pvm_joingroup( "slave" );
      if (stat < 0)
      {
       sprintf(loc,"ERROR SLAVE PROCESS # %d UNABLE TO JOIN GROUP (%s)",me,packer);
       pvm_perror( loc );
      }

    }
    else if (tstmod == 2)
    {
      
      stat = pvm_joingroup( "head" );
      if (stat < 0)
      {
       sprintf(loc,"ERROR SLAVE PROCESS # %d UNABLE TO JOIN GROUP (%s)",me,packer);
       pvm_perror( loc );
      }
    }

    else if (tstmod == 3)
    {
      stat = pvm_joingroup( "triangle" );
      if (stat < 0)
      {
       sprintf(loc,"ERROR SLAVE PROCESS # %d UNABLE TO JOIN GROUP (%s)",me,packer);
       pvm_perror( loc );
      }
    }

    /* allocate space for message array */

    if (*pack == 'y' || *pack == 'Y')
    {

      fltres =(float*)malloc(fltsiz=size*sizeof(float));
      intres =(int*)malloc(intsiz=size*sizeof(int));
      dblres =(double*)malloc(dblsiz=size*sizeof(double)); 
      lngres =(long*)malloc(lngsiz=size*sizeof(long));
      shtres =(short*)malloc(shtsiz=size*sizeof(short));
      bytres =(char*)malloc(bytsiz=size*sizeof(char)+5);
      cpxres =(float*)malloc(cpxsiz=2*size*sizeof(float)); 
      dcxres =(double*)malloc(dcxsiz=2*size*sizeof(double));
      uinres =(unsigned int *)malloc(uinsiz=size*sizeof(unsigned int));
      ushres =(unsigned short *)malloc(ushsiz=size*sizeof(unsigned short));
      ulnres =(unsigned long *)malloc(ulnsiz=size*sizeof(unsigned long));
      
      strsiz = sizeof(strres);;

      /* estimate size of message arrays */

      sum = 2*size*strsiz+n;
   
      /* create buffer for CRC calculation */

      buf = (char *)malloc(sum); 

    }

    for( j = 0; j < n ; j++ )
    {

      msgtype = 5;

      if (tstmod != 3)
      {

        /* if the bombardment test is selected then generate the necessary
           data to send to master */

        sndme   = me;

        if (*pack == 'y' || *pack == 'Y')
	{

          gen(me, size, j, fltres, intres, dblres, lngres, shtres, bytres,
              cpxres, dcxres, strres, uinres, ushres, ulnres);

        }

        /* initialize message buffer for sending the message */

        stat = pvm_initsend( code );
        if (stat < 0)
        {
          sprintf(loc,"ERROR PREPARING BUFFER FOR MESSAGE (%s)",packer);
          pvm_perror( loc );
        }

        if (*pack == 'y' || *pack == 'Y')
           packdat(size, sndme, fltres, intres, dblres, lngres, shtres,
                 bytres, cpxres, dcxres, strres, uinres, ushres, ulnres, code, 
                 nproc, n, j, sum, crcc, pack, broad, direct, tids, tstmod, 
                 msgtype, packer);


        msgsend(tstmod, me, tids, msgtype, stime, etime, j, master, broad);

        if (tstmod == 2)
	{
          bufid = pvm_recv( master, -1 );
          if (bufid < 0)
	  {
            sprintf(loc,"ERROR PROCESS %d RECEVING MESSAGE",me);
            pvm_perror( loc );
          }


          if (*pack == 'y' || *pack =='Y')
	  {
             unpackdat( &size, &who, &mess, crcr, intres, fltres, dblres, 
                        strres, lngres, shtres, bytres, cpxres, dcxres, 
                        uinres,ushres, ulnres,&nproc, pack,&broad, &code, 
                        &direct, tids, &n, &tstmod, msgtype, packer);

             for( k = 0 ; k < size; k++)
               error(fltres, intres, dblres, strres, lngres, shtres, 
                     bytres, cpxres, dcxres, uinres, ushres, ulnres, who, 
                     mess, k, &err);

             fcstab_init();

             for(i = 0; i < size; i++)
             {
               sprintf(tmp,"%f",*(fltres+i));
               cnt = strlen(tmp);
  
               if (i == 0)
                 strcpy(buf,tmp);
               else
                 strncat(buf,tmp,cnt);

             }

             cnt = strlen(buf);
             crcc[0] = hoot(buf, cnt);
             cnt = 0;

             fcstab_init();

             for(i = 0; i < size; i++)
             {
               sprintf(tmp,"%d",*(intres+i));
               cnt = strlen(tmp);

               if (i == 0)
                 strcpy(buf,tmp);
               else
                 strncat(buf,tmp,cnt);
 
             }

             cnt = strlen(buf);
             crcc[1] = hoot(buf, cnt);
             cnt = 0;

             fcstab_init();

             for(i = 0; i < size; i++)
             {
               sprintf(tmp,"%f",*(dblres+i));
               cnt = strlen(tmp);
 
               if (i == 0)
                 strcpy(buf,tmp);
               else
                 strncat(buf,tmp,cnt);
  
             }

             cnt = strlen(buf);
             crcc[2] = hoot(buf, cnt);
             cnt = 0;

             fcstab_init();
 
             for(i = 0; i < size; i++)
             {
               sprintf(tmp,"%f",*(cpxres+i));
               cnt = strlen(tmp);

               if (i == 0)
                 strcpy(buf,tmp);
               else
                 strncat(buf,tmp,cnt);

             }

             cnt = strlen(buf);
             crcc[3] = hoot(buf, cnt);
             cnt = 0;

             fcstab_init();

             for(i = 0; i < size; i++)
             {
               sprintf(tmp,"%f",*(dcxres+i));
               cnt = strlen(tmp);

               if (i == 0)
                 strcpy(buf,tmp);
               else
                 strncat(buf,tmp,cnt);

             }

             cnt = strlen(buf);
             crcc[4] = hoot(buf, cnt);
             cnt = 0;

             fcstab_init();

             for(i = 0; i < size; i++)
             {
               sprintf(tmp,"%d",*(shtres+i));
               cnt = strlen(tmp);

               if (i == 0)
                 strcpy(buf,tmp);
               else
                 strncat(buf,tmp,cnt);

             }

             cnt = strlen(buf);
             crcc[5] = hoot(buf, cnt);
             cnt = 0;

             fcstab_init();

             for(i = 0; i < size; i++)
             {
               sprintf(tmp,"%d",*(lngres+i));        
               cnt = strlen(tmp);

               if (i == 0)
                 strcpy(buf,tmp);
               else
                 strncat(buf,tmp,cnt);

             }

             cnt = strlen(buf);
             crcc[6] = hoot(buf, cnt);
             cnt = 0;

             fcstab_init();

             for(i = 0; i< size; i++)
             {
               sprintf(tmp,"%d",*(uinres+i));        
               cnt = strlen(tmp);

               if (i == 0)
                 strcpy(buf,tmp);
               else
                 strncat(buf,tmp,cnt);

             }

             cnt = strlen(buf);
             crcc[7] = hoot(buf, cnt);
             cnt = 0;

             fcstab_init();

             for(i = 0; i < size; i++)
             {
               sprintf(tmp,"%d",*(ushres+i)); 
               cnt = strlen(tmp);

               if (i == 0)
                 strcpy(buf,tmp);
               else
                 strncat(buf,tmp,cnt);

             }
 
             cnt = strlen(buf);
             crcc[8] = hoot(buf, cnt);
             cnt = 0;

             fcstab_init();

             for(i = 0; i < size; i++)
             {
               sprintf(tmp,"%d",*(ulnres+i));
               cnt = strlen(tmp);

               if (i == 0)
                 strcpy(buf,tmp);
               else
                 strncat(buf,tmp,cnt);

             }

             cnt = strlen(buf);
             crcc[9] = hoot(buf, cnt);
             cnt = 0;

             fcstab_init();

             for(i = 0; i < size; i++)
             {
               sprintf(tmp,"%s",strres);
               cnt = strlen(tmp);

               if (i == 0)
                 strcpy(buf,tmp);
               else
                 strncat(buf,tmp,cnt);

             }
  
             cnt = strlen(buf);
             crcc[10] = hoot(buf, cnt);
             cnt = 0;

             fcstab_init();

             for(i = 0; i < size; i++)
             {
               sprintf(tmp,"%c",*(bytres+i)); 
               cnt = strlen(tmp);
 
               if (i == 0)
                 strcpy(buf,tmp);
               else
                 strncat(buf,tmp,cnt);

             }

             cnt = strlen(buf);
             crcc[11] = hoot(buf, cnt);     
             cnt = 0;

             for(i = 0; i < 12; i++)
	     {
               crcerr = (crcc[i] - crcr[i]);
               if (crcerr !=0 )
                 crccnt++;
             }

          }
        }
      }
      else 
      {

        sndme = 0;

        if (me == 0)
          ptid = master;
        else 
          ptid = tids[0]; 

        bufid = pvm_recv( ptid, -1);
        if (bufid < 0)
	{
          sprintf(loc,"ERROR PROCESS %d RECEVING MESSAGE",me);
          pvm_perror( loc );
        }

        stat = pvm_bufinfo( bufid, &bytes, &msgtype, &ptid);
        if (stat < 0)
        {
          sprintf(loc,"ERROR GETTING BUFFER INFO FOR MESSAGE (%s)",packer);
          pvm_perror( loc );
        }      

        stat = pvm_setrbuf( bufid );
        if (stat < 0)
        {
          sprintf(loc,"ERROR SETTING RECEIVE BUFFER FOR MESSAGE (%s)",packer);
          pvm_perror( loc );
        } 

        if (*pack == 'y' || *pack =='Y')
        {
         unpackdat( &size, &who, &mess, crcr, intres, fltres, dblres, strres,
                    lngres, shtres, bytres, cpxres, dcxres, uinres,ushres,
                    ulnres,&nproc, pack,&broad, &code, &direct, tids, &n, 
                    &tstmod, msgtype, packer );
        }

        if (msgtype != 5)
          msgtype = 5;


        /* initialize message buffer for sending the message */

        stat = pvm_initsend( code );
        if (stat < 0)
        {
          sprintf(loc,"ERROR PREPARING BUFFER FOR MESSAGE (%s)",packer);
          pvm_perror( loc );
        }

        /* pack data and calculate the CRC to send to master */

        if (*pack == 'y' || *pack == 'Y')
           packdat(size, sndme, fltres, intres, dblres, lngres, shtres,
                bytres, cpxres, dcxres, strres, uinres, ushres, ulnres, code, 
                nproc, n, j, sum, crcc, pack, broad, direct, tids, tstmod, 
                msgtype, packer);

        msgsend(tstmod, me, tids, msgtype, stime, etime, j, master,broad);


      }

      usec   = ((float)(abs(etime[0].tv_usec - stime[0].tv_usec)))/1.0e06;
      sec    = ((float)(abs(etime[0].tv_sec - stime[0].tv_sec)));
      fnltim = fnltim + (sec + usec);

      /* call barrier to synchronize the message number sent to master */


      if (tstmod == 1)
      {
        gsize = pvm_gsize( "slave");
        if (gsize < 0)
        {
          sprintf(loc,"ERROR OBTAINING GROUP SIZE (%s)",packer);
          pvm_perror( loc );
        }

        stat = pvm_barrier("slave", nproc);
        if (stat < 0)
        {
          sprintf(loc,"ERROR CALLING BARRIER FOR SYNCHRONIZATION (%s)",packer);
          pvm_perror( loc );
        }

      }

    }

  /* send timing information to master */


  if (tstmod == 3)
  {
    stat = pvm_barrier("triangle",3);
    if (stat < 0)
    {
      sprintf(loc,"ERROR SETTING BARRIER FOR SYNCHRONIZATION (%s)",packer);
      pvm_perror( loc );
    }
  }

  msgtype = 200;
  bufid = pvm_initsend( code );      
  if (bufid < 0)
  {
    sprintf(loc,"ERROR PREPARING BUFFER TO SEND TIMING DATA (%s)",packer);
    pvm_perror( loc );
  }

  stat = pvm_pkint( &me, 1, 1 );
  if (stat < 0)
  {
    sprintf(loc,"ERROR PACKING TIMING DATA [PROCESS ID] (%s)",packer);
    pvm_perror( loc );
  }
  stat = pvm_pkint( &crccnt, 1, 1 );
  if (stat < 0)
  {
    sprintf(loc,"ERROR PACKING CRC ERROR COUNTER (%s)",packer);
    pvm_perror( loc );
  }
  stat = pvm_pkint( &err, 1, 1 );
  if (stat < 0)
  {
    sprintf(loc,"ERROR PACKING MESSAGE ERROR COUNTER (%s)",packer);
    pvm_perror( loc );
  }
  stat = pvm_pkfloat( &fnltim, 1, 1);
  if (stat < 0)
  {
    sprintf(loc,"ERROR PACKING TIMING DATA [TIMING RESULT] (%s)",packer);
    pvm_perror( loc );
  }


  if (mytid == tids[1])
  {
    for (i = 0; i < 5000000; i++)
      stat = 0;
  }

  stat = pvm_send( master, msgtype );
  if (stat < 0)
  {
    sprintf(loc,"ERROR SENDING TIMING DATA (%s)",packer);
    pvm_perror( loc );
  }

  if (tstmod == 2)
  {
    stat = pvm_barrier("head",2 );
    if (stat < 0)
    {
      sprintf(loc,"ERROR CALLING BARRIER FOR SYNCHRONIZATION (%s)",packer);
      pvm_perror( loc );
    }
    stat = pvm_lvgroup( "head" );
    if (stat < 0)
    {
      sprintf(loc,"ERROR PROCESS # %d UNABLE TO LEAVE GROUP",me);
      pvm_perror( loc );
    }
  }

  /* Program finished. Leave group before stopping */

  else if (tstmod == 1)
  {
    stat = pvm_lvgroup( "slave" );
    if (stat < 0)
    {
      sprintf(loc,"ERROR PROCESS # %d UNABLE TO LEAVE GROUP",me);
      pvm_perror( loc );
    }

  }
  else 
  {

    stat = pvm_lvgroup( "triangle" );
    if (stat < 0)
    {
      sprintf(loc,"ERROR PROCESS # %d UNABLE TO LEAVE GROUP",me);
      pvm_perror( loc );
    }

  }

  if (pack[0] == 'y' || pack[0] == 'Y')
  {
    free(fltres);
    free(intres);
    free(bytres);
    free(dblres);
    free(cpxres);
    free(dcxres);
    free(lngres);
    free(shtres);
    free(ulnres);
    free(ushres);
    free(uinres);
    free(buf);
  }

  free(tids);

}








