
      DOUBLE PRECISION FUNCTION RAND (SEED)
C     -------------------------
      INTEGER SEED

C------ Random number generator (uses the INMOS algorithm)

        DOUBLE PRECISION A, IRANGE, MOSPOS
        PARAMETER (     A =    1664525.0D0,
     1             IRANGE = 4294967296.0D0,
     2             MOSPOS = 2147483647.0D0)
        DOUBLE PRECISION RSEED

        RSEED = SEED
        IF (SEED .LT. 0) RSEED = RSEED + IRANGE
        RSEED = MOD ((A * RSEED) + 1.0, IRANGE)
        RAND  = RSEED / IRANGE
        IF (RSEED .GT. MOSPOS) RSEED = RSEED - IRANGE
        SEED  = RSEED

      END
