
      SUBROUTINE INIPSI( PSI, PSIDOT)
C     --------------------------------

      INTEGER VSIZE
      COMMON /VECLEN/ VSIZE
      DOUBLE PRECISION  PSI( VSIZE ), PSIDOT( VSIZE )

C     -------------------------------------------------------------------
C     |  Initialise {psi} at t = -(1/2):                                |
C     |                                                                 |
C     |      {psi}  =  {z1 + i.z2}/omega  -  half.h * {psidot}          |
C     |                                                                 |
C     |  where z1, z2 are normally distributed with std.dev = SQRT(2).  |
C     |                                                                 |
C     |  N.B.1   !! We assume that 'omega' = 1. !!                      |
C     |  N.B.2   !! Need {psidot} to be defined already !!              |
C     -------------------------------------------------------------------
      INTEGER  NSWEEP
      INTEGER  MAXIT, SIGFIG
      DOUBLE PRECISION     H,  HALFH,  MQUARK,  MSQ 
      COMMON / PARAMS / H,HALFH,MQUARK,MSQ,NSWEEP,MAXIT,SIGFIG

      CALL RANDV ( PSI )
      CALL ADDSCV ( PSI, PSI, - HALFH, PSIDOT )
      END
