C     **************
      SUBROUTINE PRO(NVH,NVL,IPM,WK3,WK2,WK1)
C     **************
C
C
      DOUBLE PRECISION WK1(NVH,18),WK2(NVH,18),WK3(NVH,18),
     >                 ZERO
C
      PARAMETER( ZERO = 0.E0 )
C
C
C     SU(3) MULTIPLICATION
C
C     1) U * U , ( IPM .EQ. 1 )
C
C        C(I,J) = A(I,L) * B(L,J)
C
C               = [ RE A(I,L) + I IM A(I,L) ] * [ RE B(L,J) + I IM B(L,J) ]
C
C        =>
C
C        RE C(I,J) =   RE A(I,L) * RE B(L,J) - IM A(I,L) * IM B(L,J)
C        IM C(I,J) =   RE A(I,L) * IM B(L,J) + IM A(I,L) * RE B(L,J)
C
C                                                  SUM OVER L=1,2,3
C            _
C     2) U * U , ( IPM .EQ. 2 )
C
C                           *
C        C(I,J) = A(I,L) * B(J,L)
C
C               = [ RE A(I,L) + I IM A(I,L) ] * [ RE B(J,L) - I IM B(J,L) ]
C
C        =>
C
C        RE C(I,J) =   RE A(I,L) * RE B(J,L) + IM A(I,L) * IM B(J,L)
C        IM C(I,J) = - RE A(I,L) * IM B(J,L) + IM A(I,L) * RE B(J,L)
C
C                                                  SUM OVER L=1,2,3
C        _   _
C     3) U * U , ( IPM .EQ. 3 )
C
C                  *        *
C        C(I,J) = A(I,L) * B(J,L)
C
C               = [ RE A(L,I) - I IM A(L,I) ] * [ RE B(L,J) - I IM B(L,J) ]
C
C        =>
C
C        RE C(I,J) =   RE A(L,I) * RE B(L,J) - IM A(L,I) * IM B(L,J)
C        IM C(I,J) = - RE A(L,I) * IM B(L,J) - IM A(L,I) * RE B(L,J)
C
C
C                                                  SUM OVER L=1,2,3
C
C     FOR AN OPTIMIZED VERSION OF THIS PROGRAM, THE LOOP OVER
C     L SHOULD BE  WRITTEN  OUT  EXPLICITLY, IN ORDER TO SAVE
C     LOAD AND STORE OPERATIONS
C
C
      DO 1 ISM = 1,18
      DO 1 IVL = 1,NVL
    1 WK3(IVL,ISM) = ZERO
C
      IF( IPM .EQ. 1 ) THEN
C
          DO 10 I=1,3
          DO 10 J=1,3
          DO 10 L=1,3
C
             DO 2 IVL = 1,NVL
             WK3(IVL,I+3*(J-1)  ) = WK3(IVL,I+3*(J-1)  )
     >     + WK2(IVL,I+3*(L-1)  ) * WK1(IVL,L+3*(J-1)  )
     >     - WK2(IVL,I+3*(L-1)+9) * WK1(IVL,L+3*(J-1)+9)
    2        CONTINUE
C
             DO 3 IVL = 1,NVL
             WK3(IVL,I+3*(J-1)+9) = WK3(IVL,I+3*(J-1)+9)
     >     + WK2(IVL,I+3*(L-1)  ) * WK1(IVL,L+3*(J-1)+9)
     >     + WK2(IVL,I+3*(L-1)+9) * WK1(IVL,L+3*(J-1)  )
    3        CONTINUE
C
   10 CONTINUE
C
      ENDIF
C
      IF( IPM .EQ. 2 ) THEN
C
          DO 20 I=1,3
          DO 20 J=1,3
          DO 20 L=1,3
C
             DO 4 IVL = 1,NVL
             WK3(IVL,I+3*(J-1)  ) = WK3(IVL,I+3*(J-1)  )
     >     + WK2(IVL,I+3*(L-1)  ) * WK1(IVL,J+3*(L-1)  )
     >     + WK2(IVL,I+3*(L-1)+9) * WK1(IVL,J+3*(L-1)+9)
    4        CONTINUE
C
             DO 5 IVL = 1,NVL
             WK3(IVL,I+3*(J-1)+9) = WK3(IVL,I+3*(J-1)+9)
     >     - WK2(IVL,I+3*(L-1)  ) * WK1(IVL,J+3*(L-1)+9)
     >     + WK2(IVL,I+3*(L-1)+9) * WK1(IVL,J+3*(L-1)  )
    5        CONTINUE
C
   20 CONTINUE
C
      ENDIF
C
      IF( IPM .EQ. 3 ) THEN
C
          DO 30 I=1,3
          DO 30 J=1,3
          DO 30 L=1,3
C
             DO 6 IVL = 1,NVL
             WK3(IVL,I+3*(J-1)  ) = WK3(IVL,I+3*(J-1)  )
     >     + WK2(IVL,L+3*(I-1)  ) * WK1(IVL,J+3*(L-1)  )
     >     - WK2(IVL,L+3*(I-1)+9) * WK1(IVL,J+3*(L-1)+9)
    6        CONTINUE
C
             DO 7 IVL = 1,NVL
             WK3(IVL,I+3*(J-1)+9) = WK3(IVL,I+3*(J-1)+9)
     >     - WK2(IVL,L+3*(I-1)  ) * WK1(IVL,J+3*(L-1)+9)
     >     - WK2(IVL,L+3*(I-1)+9) * WK1(IVL,J+3*(L-1)  )
    7        CONTINUE
C
   30 CONTINUE
C
      ENDIF
C
C
      RETURN
      END
C
C
