#include <stdio.h>
#include "defines.h"
#include "externs.h"



/* ----------------------------------------
		parse_term()

   Parses a term and if valid fills in a struct_term. 
   Calls get_token() as needed. Will return a flag to show
   result. If valid, the global ptr "termptr" contains a
   pointer to a valid term_type structure, all filled in.
   May return:
		VALID_TERM	termptr->filled in term
		BOGUS_TERM	termptr undefined
		NO_TERM		termptr	undefined (implies EOL)

   Remember, a term is defined as:

      term ::= [<string> '='] <string> [',' <constraintlist>] |
                [<shortcommand>] <string> [',' <constraintlist>]

   ---------------------------------------- */

parse_term () {
int state;
int done;
	logit ("parse_term:", "into parse_term\n");

	if((token = get_token()) == EOL) {
		logit ("parse_term:", "empty line");
		return (NO_TERM);
	}

/* else allocate a term structure for reply */
	termptr = (struct term_type *) malloc (sizeof(struct term_type));

	termptr->command        = SEARCH_ALL;
	termptr->command_type   = SEARCH_COMMAND;
	termptr->constraints[0] = '\0';
	termptr->attribute[0]   = '\0';
	termptr->value[0]       = '\0';
	termptr->nextptr	= NULL;

/* now set initial state for the Finite State Machine */

	switch (token) {
	case COMMAND:
			logit ("parse_term:", "COMMAND state");
			logit ("parse_term:", "Command has been set");
			termptr->command = token_value;
			state = COMMAND_STATE;
			break;

	case STRING:	logit ("parse_term:", "START_STRING state");
			logit ("parse_term: string is:", token_string);
			state = START_STRING_STATE;
			set_cmd(termptr, token_string);
			if (termptr->command == HELP) {
				state = COMMAND_STATE;
			}

			break;

	default:	return (BOGUS_TERM);
	}

logit ("parse_term:", "now loop processing elements of a term");

    done = 0;

    while (!done) {
        logit ("parse_term:", "looping");

        token = get_token();

        switch (state) {
    case COMMAND_STATE:
                logit ("parse_term:", "in COMMAND state");
                switch (token) {
            case STRING:
                logit ("parse_term: arg string is: ", token_string);
                strcpy (termptr->value, token_string);
                state = IN_STRING_STATE;
		continue;
	    default:
                done=NO_STRING;
		continue;
		}

	case START_STRING_STATE:
	    logit ("parse_term:", "in START STRING state");
                switch (token) {
	    case EQUALS:
			logit ("parse_term:", "found search command");
			logit ("parse_term: Command is:", termptr->value);
			composed(termptr);
			state = COMMAND_STATE;
			continue;
	    case STRING:
			logit ("parse_term:", "multi-strings, IN_STRING state");
			logit ("parse_term: string is: ", token_string);
			state = IN_STRING_STATE;
			continue;
	    case COMMA:
			logit ("parse_term:", "into constraints");
			state = START_CONSTRAINTS_STATE;
			continue;
	    case COLON:
			logit ("parse_term:", "pushback token");
			ptr--;
	    case EOT:
			logit ("parse_term:", "end of term");
			done =VALID_TERM;
			continue;
	    case EOL:
			logit ("parse_term:", "End of Line");
			done = VALID_TERM;
			continue;
	    default:
			logit ("parse_term:", "Bogus character in term");
			return (BOGUS_TERM);
		}/* end switch for START_STRING */

	case IN_STRING_STATE:
	    logit ("parse_term:", "in STRING state");
		switch (token) {
		case STRING:
			logit ("parse_term:", "adding another string");
			logit ("parse_term: string is: ", token_string);
			strcat (termptr->value, token_string);
			continue;
		case COMMA:
			logit ("parse_term:", "reached constraints");
			state = START_CONSTRAINTS_STATE;
			continue;
	        case COLON:
			logit ("parse_term:", "pushback token");
			ptr--;
                case EOT:
			logit ("parse_term:", "end of term");
			done =VALID_TERM;
			continue;
                case EOL:
			logit ("parse_term:", "End of Line");
			done = VALID_TERM;
			continue;
                default:
			logit ("parse_term:", "Bogus command in string");
			return (BOGUS_TERM);
		} /* end switch for IN_STRING_STATE */

	case START_CONSTRAINTS_STATE:
	    logit ("parse_term:", "start CONSTRAINTS state");
		switch (token) {
		case STRING:
			logit ("parse_term:", "adding first constraint");
			logit ("parse_term: string is: ", token_string);
			strcpy (termptr->constraints, token_string);
			state = IN_CONSTRAINTS_STATE;
			continue;
		case COLON:
			logit ("parse_term:", "pushback token");
			ptr--;
	    case EOL:
	    case EOT:
			logit ("parse_term:", "end of term");
			done = VALID_TERM;
			continue;
	    default:
			logit ("parse_term:", "BOGUS CONSTRAINT!!");
			return (BOGUS_TERM);

		}

	case IN_CONSTRAINTS_STATE:
	    logit ("parse_term:", "in CONSTRAINTS state");
		switch (token) {
		case STRING:
			logit ("parse_term:", "adding another constraint");
			logit ("parse_term: string is: ", token_string);
			strcat (termptr->constraints, " ");
			strcat (termptr->constraints, token_string);
			continue;
		case COLON:
			logit ("parse_term:", "pushback token");
			ptr--;
		case EOL:
		case EOT:
			logit ("parse_term:", "end of term");
			done = VALID_TERM;
			continue;
		default:
			logit ("parse_term:", "BOGUS CONSTRAINT!!");
			return (BOGUS_TERM);

		}
	default:
		logit ("parse_term:", "BOGUS STATE!!");
		return (BOGUS_TERM);
	} /* end switch for STATE */
    }

/* now validate term */

	logit ("parse_term:", "validate term");

	return (validate_term(termptr));

}

set_cmd (termptr, ptr)
struct term_type *termptr;
char *ptr;  {

	logit ("set_cmd:", "into set_cmd()");

	if (system_cmd (termptr, ptr)) {
		return;
	}
	search_cmd (termptr, ptr);

}

search_cmd(termptr, ptr)
struct term_type *termptr;
char *ptr; {

	logit ("search_cmd:", "into search_cmd");

	termptr->command_type = SEARCH_COMMAND;

	if (!strcmp("attribute", ptr)) {
		logit ("search_cmd:", "found ATTRIBUTE");
		termptr->command  = ATTRIBUTE;
		return (0);
	}

	if (!strcmp("value", ptr)) {
		logit ("search_cmd:", "found VALUE");
		termptr->command  = VALUE;
		return (0);
	}

	if (!strcmp("handle", ptr)) {
		logit ("search_cmd:", "found HANDLE");
		termptr->command  = HANDLE;
		return (0);
	}

	if (!strcmp("type", ptr)) {
		logit ("search_cmd:", "found TYPE");
		termptr->command  = TYPE;
		return (0);
	}

	if (!strcmp("help", ptr)) {
		logit ("search_cmd:", "found HELP");
		termptr->command  = HELP;
		return (0);
	}

/* else where's looking at either a composed "<attribute> = <value>" command */
/* or a "SEARCHALL <string>" command. in the first case we put in the        */
/* <attribute> string, and set up for the <value> */

	logit ("search_cmd:", "compose attribute");

	strcpy (termptr->attribute, ptr);
	strcpy (termptr->value, ptr);
	return (1); /* indicates need to find value... */


}

system_cmd(termptr, ptr)
struct term_type *termptr;
char *ptr; {

	logit ("system_cmd:", "into system_cmd");


	if (!strcmp("list", ptr)) {
		logit ("system_cmd:", "found LIST");
		termptr->command  = LIST_TEMPLATE;
		termptr->command_type = SYSTEM_COMMAND;
		return (1);
	}

	if (!strcmp("show", ptr)) {
		logit ("system_cmd:", "found SHOW");
		termptr->command  = SHOW_TEMPLATE;
		termptr->command_type = SYSTEM_COMMAND;
		return (1);
	}

	if (!strcmp("constraints", ptr)) {
		logit ("system_cmd:", "found CONSTRAINTS");
		termptr->command  = LIST_CONSTRAINTS;
		termptr->command_type = SYSTEM_COMMAND;
		return (1);
	}

	return (0);
}

validate_term (termptr)
struct term_type *termptr;  {

	logit ("validate_term:", "into validate_term");

	switch (termptr->command_type) {
	case SYSTEM_COMMAND:
		return (VALID_TERM);

	case SEARCH_COMMAND:
		switch (termptr->command) {
		case HELP:
			return (VALID_TERM);

		case ATTRIBUTEVAL:
			if (!strlen(termptr->attribute)) {
				logit ("validate_term:", "NO ATTRIBUTE!");
				return (BOGUS_TERM);
			}

		case ATTRIBUTE:
		case VALUE:
		case HANDLE:
		case TEMPLATE:
		case SEARCH_ALL:
			if (!strlen(termptr->value)) {
				logit ("validate_term:", "NO VALUE!");
				return (BOGUS_TERM);
			}
			else {
				return (VALID_TERM);
			}
			

		default:
			logit ("validate_term:", "BAD COMMAND!");
			return (BOGUS_TERM);
		}
	default:
		logit ("validate_term:","BOGUS COMMAND TYPE!");
		return (BOGUS_TERM);
	}
	
}

composed (termptr)
struct term_type *termptr; {

	logit ("composed:", "into composed()");

	if (termptr->command == SEARCH_ALL) {
	/* then we have a composed command, so fix */
			termptr->command  = ATTRIBUTEVAL;
	}


}
