/*
    ut32.c      the main source code for the 32 bit UT DLL
		ut32.dll is loaded by a 32 bit application,
		sets up the UT for use by both sides
		needs w32sut.h and w32sut32.lib from the March 1993 NT SDK
*/

#define W32SUT_32
#define CALC_SRV_ADDTWO       0   //indicate type of 32 bit function
#define CALC_SRV_SUBTWO       1
#define CALC_SRV_MULTTWO      2
#define CALC_SRV_DIVTWO       3
#define SUM_ARRAY             4

#include <windows.h>
#include "w32sut.h"
#include "ut32.h"

UT32PROC  pfnUTProc=NULL;

int       cProcessesAttached = 0;
long      a, b, ret, ArraySize, ArraySum, sum, SizeofArray, Index; 
long      *SumAddress;

BOOL 
DllInit(HANDLE hInst, DWORD fdwReason, LPVOID lpReserved)
{
    if ( fdwReason == DLL_PROCESS_ATTACH ) {
	 if ( cProcessesAttached++ ) {
	 return(TRUE);
    }
/*  UTRegister sets up the UT for both directions
    It is the key function in ut32.dll 
    to use (16->32) thunk, both valid (32->16) and (16->32) thunks must be set up */    

    return UTRegister( hInst,        // ut32.dll module handle
		       "UT16.DLL",   // name of 16 bit thunk dll
		       "CBInit",     // name of 16 bit exported initialization function, receives 16->32 thunk address in ut16.dll
		       "UTProc",     // name of 16 bit (32->16) thunk function exported from ut16.DLL
		       &pfnUTProc,   // global variable to receive (32->16) thunk address
		       &CB32,        // address of (16->32) thunk function in ut32.dll
		       NULL          // no shared memory set up from 32 bit side
		     );
    } 
    else if ( fdwReason == DLL_PROCESS_DETACH ) {
       if ( --cProcessesAttached == 0 ) {
	   UTUnRegister( hInst );
       }
    }
}

/*      (32 -> 16) thunk functions */

long AddTwo(LPDWORD *Arrayn)
{
	ret= (long)(* pfnUTProc)(Arrayn,CALC_SRV_ADDTWO, NULL);
	return(ret);
}

long SubTwo(LPDWORD *Arrayn)
{
	ret= (long) (* pfnUTProc)(Arrayn,CALC_SRV_SUBTWO, NULL);
	return(ret);
}

long MultTwo(LPDWORD *Arrayn)
{
	ret= (long) (* pfnUTProc)(Arrayn,CALC_SRV_MULTTWO, NULL);
	return(ret);
}

long DivTwo(LPDWORD *Arrayn)
{
	ret= (long) (* pfnUTProc)(Arrayn,CALC_SRV_DIVTWO, NULL);
	return(ret);
}

/*      32 bit functions called from 32 bit side */

long AddTwoDLL32(LPDWORD *Arrayn)
{       
	a=*Arrayn;
	b=*(++Arrayn);
	ret=a+b;
	return(ret);
}

long SubTwoDLL32(LPDWORD *Arrayn)
{
	a=*Arrayn;
	b=*(++Arrayn);
	ret=a-b;
	return(ret);
}

long MultTwoDLL32(LPDWORD *Arrayn)
{
	a=*Arrayn;
	b=*(++Arrayn);
	ret=a*b;
	return(ret);
}

long DivTwoDLL32(LPDWORD *Arrayn)
{
	a=*Arrayn;
	b=*(++Arrayn);
	ret=a/b;
	return(ret);

}

/*      (16->32) thunk function 
	arguments must be distributed due to fixed UT parameters */

long WINAPI CB32(LPDWORD *Arrayn, DWORD dwFunc)
{    
    switch (dwFunc) {
	case CALC_SRV_ADDTWO:
		a=*Arrayn;
		b=*(++Arrayn);
		*(++Arrayn)=a+b;
		return(1l);
 
	case CALC_SRV_SUBTWO:
		a=*Arrayn;
		b=*(++Arrayn);
		*(++Arrayn)=a-b;
		return(1l);
    
	case CALC_SRV_MULTTWO:
		a=*Arrayn;
		b=*(++Arrayn);
		*(++Arrayn)=a*b;
		return(1l);
    
	case CALC_SRV_DIVTWO:
		a=*Arrayn;
		b=*(++Arrayn);
		*(++Arrayn)=a/b;
		return(1l);

	case SUM_ARRAY:
		sum=0;
		SizeofArray=*Arrayn;
		Arrayn++;
		SumAddress=Arrayn;
		for (Index=0;Index<(SizeofArray); Index++)
			{  Arrayn++;
			   b=*Arrayn;
			   sum += b; }
		*SumAddress=sum;
		return(1l);
	};   
}


