#include <string.h>
#include <iostream.h>
#include "strclass.h"

#define THIS    String
#define BASE    Object
DEFINE_CLASS(String, Object);

// 9/21/90
void String::printOn(ostream& strm) const
{
    strm << str;
}

//////////////////////////////////////////////////
// constructors
//////////////////////////////////////////////////
String::String(const String &s)
{
    refs = s.refs;
    (*refs)++;
    iSize = s.iSize;
    str = s.str;
}

String::String(const char *s)
{
    refs = new int;
    *refs = 1; // refs must be a pointer because
               // two string objects might refer
               // to the same int *.  A reference
               // to either should update the SAME
               // reference counter.  This would not
               // be possible if each String object
               // maintained a private reference
               // count.
    iSize = strlen(s);
    str = new char[iSize + 1];
    strcpy(str, s);
}

String::String(const int length)
{
    iSize = length;
    str = new char[iSize + 1];
    str[0] = '\0';
    refs = new int;
    *refs = 1;
}

//////////////////////////////////////////////////
// destructor
//////////////////////////////////////////////////
String::~String()
{
    if (--(*refs) == 0)
    {
        delete str;
        delete refs;
    }
}

//////////////////////////////////////////////////
// assignment
//////////////////////////////////////////////////
String& String::operator=(const String &s)
{
    (*s.refs)++;
    if (--(*refs) == 0)
    {
        delete refs;
        delete str;
    }
    refs = s.refs;
    iSize = s.iSize;
    str = s.str;
    return *this;
}

String& String::operator=(const char *s)
{
    if (--(*refs) == 0)
    {
        delete refs;
        delete str;
    }
    refs = new int;
    *refs = 1;
    iSize = strlen(s);
    str = new char[iSize + 1];
    strcpy(str, s);
    return *this;
}

//////////////////////////////////////////////////
// comparison
//////////////////////////////////////////////////
int operator==(const String &s1, const String &s2)
{
    return strcmp(s1.str, s2.str)==0;
}

int operator!=(const String &s1, const String &s2)
{
    return strcmp(s1.str, s2.str)!=0;
}

int operator<(const String &s1, const String &s2)  // not in text
{
    return strcmp(s1.str, s2.str)<0;
}

//////////////////////////////////////////////////
// concatenation
//////////////////////////////////////////////////
String& operator+(const String &s1, const String &s2)
{
    String *s3 = new String(strlen(s1.str)+strlen(s2.str)+1);
    strcpy(s3->str, s1.str);
    strcat(s3->str, s2.str);
    return *s3;
}


//////////////////////////////////////////////////
// ostream output
//////////////////////////////////////////////////
ostream &operator<<(ostream &os, const String &s)
{
    return os << s.str;
}

//////////////////////////////////////////////////
// hash
// -gmv 4/19/93
//////////////////////////////////////////////////
unsigned String::hash() const
{
    register unsigned h = 0;
    char *s = str;

    
    // while (i--) h^=(*vp++)->hash();
    while (*s) h^=(*s++);
    return h;
}

//////////////////////////////////////////////////
// isEqual
// -gmv 4/19/93
//////////////////////////////////////////////////
bool String::isEqual(const Object& ob) const
{
    return ob.isSpecies(class_String) && *this==*(String*)&ob;
}

//////////////////////////////////////////////////
// compare
// -gmv 4/19/93
//////////////////////////////////////////////////
int String::compare(const Object& ob) const
{
    return strcmp(str, ((String*)&ob)->str);
}

//////////////////////////////////////////////////
// toUpper, toLower
// 4/26/93 -gmv
//////////////////////////////////////////////////
void String::toUpper() const
{
    strupr(str);
}

void String::toLower() const
{
    strlwr(str);
}

