#include "linkob.h"

#define THIS    LinkOb
#define BASE    Link
DEFINE_CLASS(LinkOb,Link);

LinkOb::LinkOb(const Object& newval)
{
    val = (Object*)&newval;
}

unsigned LinkOb::capacity() const     { return val->capacity(); }

int LinkOb::compare(const Object& ob) const  { return ob.compare(*val); }

void LinkOb::deepenShallowCopy()
{
    BASE::deepenShallowCopy();
    val = val->deepCopy();
}

unsigned LinkOb::hash() const        { return val->hash(); }

bool LinkOb::isEqual(const Object& ob) const
{
    return ob.isEqual(*val);
}

void LinkOb::printOn(ostream& strm) const
{
    strm << className() << "("; val->printOn(strm); strm << ")";
}

unsigned LinkOb::size() const         { return val->size(); }

Object* LinkOb::value() const { return val; }

Object* LinkOb::value(const Object& newval)
{
    Object* temp = val;
    val = (Object*)&newval;
    return temp;
}
