/* IdentDict.c -- implementation of Identifier Dictionary

Function:
    
An IdentDict is like a Dictionary, except keys are compared using
isSame() rather than isEqual().

*/

#include "identdic.h"
#include "lookupke.h"

#define THIS    IdentDict
#define BASE    Dictionary
DEFINE_CLASS(IdentDict,Dictionary);

IdentDict::IdentDict(unsigned size) : Dictionary(size) {}

IdentDict::IdentDict(const IdentDict& d) : Dictionary(d) {}

void IdentDict::operator=(const IdentDict& d)
{
    this->Dictionary::operator=(d);
}

int IdentDict::findIndexOf(const Object& ob) const
/*
Search this IdentDict for a LookupKey with the same key object as the
argument.

Enter:
    ob = pointer to LookupKey to search for

Returns:
    index of object if found or of nil slot if not found
    
Algorithm L, Knuth Vol. 3, p. 519
*/
{
    register int i;
    Object* keyob = ((LookupKey*)&ob)->key();
    for (i = h((int)keyob); contents[i]!=nil; i = (i-1)&mask) {
        if (((LookupKey*)contents[i])->key()->isSame(*keyob)) return i;
    }
    return i;
}

Object* IdentDict::atKey(const Object& key) const
{
    return Dictionary::atKey(LookupKey(key));
}

Object* IdentDict::atKey(const Object& key, const Object& newValue)
{
    return Dictionary::atKey(LookupKey(key), newValue);
}

LookupKey& IdentDict::assocAt(const Object& key) const
{
    return Dictionary::assocAt(LookupKey(key));
}

bool IdentDict::includesKey(const Object& key) const
{
    return Dictionary::includesKey(LookupKey(key));
}
