/*

MALLOC.C - Windows Global Memory Allocation Library
	   Initialisation/main module

*/


#pragma hdrfile "MALLOC.SYM"
#define STRICT
#include <windows.h>
#include <winstyle.h>
#include <dos.h>
#pragma hdrstop

#include <wmalloc.h>


#define TEST_ID		0x41A5


static HWND hWnd = NULL;
static HINSTANCE hInst;
static char *TEST_CLASS = "TestClass",
	    *TESTMESSAGE = MALLOC_MESSAGE;
static UINT uTestMsg;


LRESULT CALLBACK TestProc (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
static void _gethwnd (void);


// Procedure to initialise the DLL.
#pragma argsused
int CALLBACK LibMain (HINSTANCE hInstance, WORD DataSeg,
		      WORD HeapSize, LPSTR lpArgv)
  {WNDCLASS cl;

   // Store the instance handle of the DLL for future use
   hInst = hInstance;

   // Register communications class
   cl.style = CS_GLOBALCLASS;
   cl.lpfnWndProc = TestProc;
   cl.cbClsExtra = 0;
   cl.cbWndExtra = 0;
   cl.hInstance = hInst;
   cl.hIcon = NULL;
   cl.hCursor = NULL;
   cl.hbrBackground = NULL;
   cl.lpszMenuName = NULL;
   cl.lpszClassName = TEST_CLASS;
   if (!RegisterClass (&cl)) return 0;

   uTestMsg = RegisterWindowMessage (TESTMESSAGE);

   // If the data segment is locked, unlock it
   if (HeapSize) UnlockData (0);

   return 1;
  } // end LibMain

// DLL termination procedure
#pragma argsused
int FAR PASCAL WEP (int iParam)
  {return 1;
  } // end WEP


LRESULT CALLBACK TestProc (HWND hWndTest, UINT msg, WPARAM wParam, LPARAM lParam)
  {if (msg == WM_COMMAND)
     {if (wParam == TEST_ID && HIWORD (lParam) == MAL_ACK)
	{hWnd = (HWND) LOWORD (lParam);
	} // endif
      return 0;
     } // endif
   return DefWindowProc (hWndTest, msg, wParam, lParam);
  } // end TestProc


static void _gethwnd (void)
  {HWND hwndTest;

   hwndTest = CreateWindow (TEST_CLASS, "", WS_OVERLAPPED,
      0, 0, 0, 0, NULL, NULL, hInst, NULL);
   if (hwndTest == NULL) return;
   ShowWindow (hwndTest, SW_HIDE);
   SendMessage (HWND_BROADCAST, uTestMsg, (WPARAM) hwndTest,
      MAKELPARAM (0, TEST_ID));
   DestroyWindow (hwndTest);

   if (hWnd == NULL)
     {WinExec ("_MALLOC.EXE", SW_HIDE);
      hwndTest = CreateWindow (TEST_CLASS, "", WS_OVERLAPPED,
	 0, 0, 0, 0, NULL, NULL, hInst, NULL);
      if (hwndTest == NULL) return;
      ShowWindow (hwndTest, SW_HIDE);
      SendMessage (HWND_BROADCAST, uTestMsg, (WPARAM) hwndTest,
	 MAKELPARAM (0, TEST_ID));
      DestroyWindow (hwndTest);
     } // endif
  } // end gethwnd


void far * WINAPI gmalloc (DWORD dwSize)
  {void far *lpPtr;

   if (hWnd == NULL) _gethwnd();
   if (hWnd == NULL) return NULL;
   lpPtr = (void far *) SendMessage (hWnd, MAL_ALLOC, 0, dwSize);
   return lpPtr;
  } // end gmalloc


void far * WINAPI grealloc (void far *lpPtr, DWORD dwSize)
  {REALLOCSTRUCT Ra;
   void far *lpPoint;

   if (hWnd == NULL) return NULL;
   Ra.dwSize = dwSize;
   Ra.lpPtr = lpPtr;
   lpPoint = (void far *) SendMessage (hWnd, MAL_REALLOC, 0,
      (LPARAM) (LPREALLOCSTRUCT) &Ra);
   return lpPoint;
  } // end grealloc


void WINAPI gfree (void far *lpPtr)
  {if (hWnd == NULL) return;
   SendMessage (hWnd, MAL_FREE, 0, (LPARAM) lpPtr);
  } // end gfree


BOOL WINAPI gisptr (void far *lpPtr)
  {HGLOBAL handle;

   handle = (HGLOBAL) LOWORD (GlobalHandle ((UINT) FP_SEG (lpPtr)));
   if (handle == NULL) return FALSE;
   if (FP_OFF (lpPtr) != NULL) return FALSE;
   return TRUE;
  } // end gisptr


