(******************************************************************************
*                                   tpDESQ                                    *
* Turbo-Pascal 6.0 DESQview interface unit, (c) 1991, Loewy Ron.              *
******************************************************************************)
unit tpDESQ;

interface

uses
   crt
   ,dos
   ;

const
   DESQviewActive : boolean = false; { true if running under DESQview }
   DESQviewMajor  : byte    = 0;
   DESQviewMinor  : byte    = 0;

procedure detectDESQview;
function getDESQviewTextBuffer : pointer;
procedure DESQviewApiCall(func : word);
procedure DESQviewPause;
procedure DESQviewBeginCritical;
procedure DESQviewEndCritical;
procedure makeDESQviewAware;

implementation

var
   regs  : registers;

(******************************************************************************
*                               detectDESQview                                *
* Set DESQviewActive flag to TRUE if DV is active, and set Major and Minor    *
* DESQview version.                                                           *
******************************************************************************)
procedure detectDESQview;
begin
   regs.cx := $4445;
   regs.dx := $5351; { date cx = DE, dx = SQ }
   regs.ax := $2B01; { dos set date function }
   msdos(regs);
   if (regs.al = $ff) then
      DESQviewActive := false { if dos detected an error, no DV active }
   else begin
      DESQviewActive := true;
      DESQviewMajor  := regs.bh;
      DESQviewMinor  := regs.bl;
   end;
end; {detectDESQview}

(******************************************************************************
*                            getDESQviewTextBuffer                            *
******************************************************************************)
function getDESQviewTextBuffer;
begin
   regs.ah := $fe; { DESQview get buffer function API }
   intr($10, regs);
   getDESQviewTextBuffer := ptr(word(regs.es), word(regs.di));
end; {getDESQviewTextBuffer}

(******************************************************************************
*                               DESQviewApiCall                               *
******************************************************************************)
procedure DESQviewApiCall; assembler;
asm
   push ds
   push bp
   push sp
   push ss
   mov ax, $101A  ; { switch to DV stack }
   int $15
   mov ax, func   ; { perform API call }
   int $15
   mov ax, $1025  ; { switch off DV stack }
   int $15
   pop ss
   pop sp
   pop bp
   pop ds
end; {DESQviewApiCall}

(******************************************************************************
*                                DESQviewPause                                *
* give up programs time slice, (Waiting for an event ... )                    *
******************************************************************************)
procedure DESQviewPause;
begin
   DESQviewApiCall($1000);
end; {DESQviewPause}

(******************************************************************************
*                            DESQviewBeginCritical                            *
* Tell DV not to slice away until a DESQviewEndCritical is issued             *
******************************************************************************)
procedure DESQviewBeginCritical;
begin
   DESQviewApiCall($101B);
end; {DESQviewBeginCritical}

(******************************************************************************
*                             DESQviewEndCritical                             *
******************************************************************************)
procedure DESQviewEndCritical;
begin
   DESQviewApiCall($101C);
end; {DESQviewEndCritical}

(******************************************************************************
*                              makeDESQviewAware                              *
******************************************************************************)
procedure makeDESQviewAware;
begin
   directVideo := false;
end; {makeDESQviewAware}

(******************************************************************************
*                                    MAIN                                     *
******************************************************************************)
begin
   detectDESQview;
end.
