{$LIST+}
{$INCLUDE: 'A:FILKQQ.INC'}
{$INCLUDE: 'A:FILUQQ.INC'}

program okimode;

USES	FILUQQ;

{
This program will set the mode of the Okidata Microline 92 printer.

Author: Stephen L. Billard
}

CONST
	MaxFunctions	=	20;
	MaxRequests	=	40;
	HT		=	 9;
	CR		=	13;
	CAN		=	24;
	ESC		=	27;
	PICA		=	30;
	ELITE		=	28;
	COMPRESS	=	29;
	DOUBLE		=	31;
	SIXLPI		=	54;
	EIGHTLPI	=	56;
	labeleq		=	'lpt1:';

TYPE
	descriptionstr  =       lstring(80);
	requeststr      =       lstring(15);
	Functiontype    =       RECORD
				  escape: boolean;
				  code: char;
				  description: descriptionstr;
				end;
	RequestListType =	RECORD
				  tag: integer;
				  text: requeststr;
				end;
VAR
	OUTPUT:			TEXT;
	printer:		FILE of char;
	request:		requeststr;
	cmdline:		lstring(255);
	desc:			descriptionstr;
	erc:			word;
	clear,
	sublen,
	inx:			integer;
	notified:		boolean;
	tchr:			char;
	Functions:		RECORD
				  count: integer;
				  action: Array [0..Maxfunctions-1] of
						 Functiontype;
				end;
	Requests:		RECORD
				  count: integer;
				  requestlist: Array [0..Maxrequests-1] of
						      RequestListType;
				end;

function CreateFcn(const escmode: boolean;
		   const fcncode: char;
		   const text: descriptionstr): integer;
  begin
  with Functions do
    begin
    with action [count] do
      begin
      escape := escmode;
      code := fcncode;
      description := text;
      end;
    createfcn := count;
    count := succ(count);
    end;
  end {CreateFcn};

procedure CreateReq(const fcn: integer; const req: requeststr);
  begin
  with Requests do
    begin
    with requestlist [count] do
      begin
      tag := fcn;
      text := req;
      end;
    count := succ(count);
    end;
  end {CreateReq};

function Match(const requested: requeststr): integer;

  var i: integer;
      tstr:      requeststr;
  begin
  match := -1;
  With Requests do
    begin
    i := count;
    repeat
      begin
      i := pred(i);
      with requestlist [i] do
	begin
	tstr := text;
	if tstr.len >= requested.len then
	  begin
	  tstr.len := requested.len;
q	  if tstr = requested then
	    begin
	    match := tag;
	    BREAK;
	    end;
	  end;
	end;
      end
    until i = 0;
    end;
  end {Match};

procedure Send(const fcn: integer);
  begin
  with Functions.action [fcn] do
    begin
    if escape then
      write(printer, chr(esc));
    write(printer, code);
    end;
  end {Send};

procedure SetTabStops(const spaces: integer);

const	nstops	=	16;

var	stop,
	inx:		integer;

  begin
  write(printer, chr(ESC));
  write(printer, chr(HT));
  write(printer, chr(CR));	{clear tab stops}
  
  write(printer, chr(ESC));
  write(printer, chr(HT));
  for stop := 1 to nstops do
    begin
    eval(encode(request, stop * spaces:3));
    for inx := 1 to 3 do
      begin
      tchr := request [inx];
      if tchr = ' ' then
        tchr := '0';
      write(printer, tchr);
      end;
    if stop < nstops then
      write(printer, ',');
    end;
  write(printer, chr(CR));
  end {SetTabStops};

begin
Assign(OUTPUT, 'con:');
rewrite(OUTPUT);

Assign(printer, labeleq);
rewrite(printer);

Functions.Count := 0;
Requests.Count := 0;
notified := false;

desc := '10 characters per inch set.';
inx := createfcn(false, chr(pica), desc);
request := '10cpi';
createreq(inx, request);
request := 'pica';
createreq(inx, request);

desc := '12 characters per inch set.';
inx := createfcn(false, chr(elite), desc);
request := '12cpi';
createreq(inx, request);
request := 'elite';
createreq(inx, request);

desc := '17 characters per inch set.';
inx := createfcn(false, chr(compress), desc);
request := '17cpi';
createreq(inx, request);
request := 'compressed';
createreq(inx, request);

desc := 'Correspondence quality print selected.';
inx := createfcn(true, '1', desc);
request := 'correspondence';
createreq(inx, request);
request := 'letter';
createreq(inx, request);

desc := 'Data processing mode selected.';
inx := createfcn(true, '0', desc);
request := 'dataprocessing';
createreq(inx, request);

desc := 'Normal print selected.';
inx := createfcn(true, 'I', desc);
request := 'normal';
createreq(inx, request);

desc := 'Double width print selected.';
inx := createfcn(false, chr(double), desc);
request := 'double';
createreq(inx, request);

desc := 'Half-dot emphasized print selected.';
inx := createfcn(true, 'T', desc);
request := 'emphasized';
createreq(inx, request);

desc := 'Half-dot enhanced print selected.';
inx := createfcn(true, 'H', desc);
request := 'enhanced';
createreq(inx, request);

desc := '6 lines per inch set.';
inx := createfcn(true, chr(sixlpi), desc);
request := '6lpi';
createreq(inx, request);

desc := '8 lines per inch set.';
inx := createfcn(true, chr(eightlpi), desc);
request := '8lpi';
createreq(inx, request);

desc := 'Printer modes reset to defaults.';
inx := createfcn(false, chr(can), desc);
request := 'clear';
createreq(inx, request);
clear := inx;

send(clear);
settabstops(8);

erc := ppmuqq(0, adr NULL, cmdline);
if erc <> 0 then
  abort('Parameter retrieval failure', 0, erc);

sublen := scanne(retype(integer, cmdline.len), ' ', cmdline, 1);
if sublen > 0 then
  delete(cmdline, 1, sublen);

while cmdline.len > 0 do
  begin
  
  request := NULL;
  sublen := scaneq(retype(integer, cmdline.len), ' ', cmdline, 1);
  if retype(word, sublen) >= sizeof(request) then
    request.len := sizeof(request)-1
  else
    request.len := retype(word, sublen);
  for inx := 1 to retype(integer, request.len) do
    begin
    tchr := cmdline [inx];
    if (ord(tchr) <= ord('Z')) and (ord(tchr) >= ord('A')) then
      tchr := chr(ord(tchr) + 32);     {down shift}
    request [inx] := tchr;
    end;
  delete(cmdline, 1, sublen);
  if cmdline.len > 0 then
    begin
    sublen := scanne(retype(integer, cmdline.len), ' ', cmdline, 1);
    delete(cmdline, 1, sublen);
    end;
  
  inx := match(request);
  if inx < 0 then
    begin
    writeln(OUTPUT);
    writeln(OUTPUT, '''',request,''' is not a valid function.');
    writeln(OUTPUT);
    if not notified then
      begin
      writeln(OUTPUT, 'The following are the valid functions:');
      writeln(OUTPUT);
      with requests do
	begin
	inx := pred(count);
	repeat
	  begin
	  write(OUTPUT, requestlist [inx].text);
	  if ((count - inx) mod 3) = 0 then
	    writeln(OUTPUT)
	  else
	    begin
	    write(OUTPUT, chr(HT));
	    if requestlist [inx].text.len < 16 then
	      write(OUTPUT, chr(HT));
	    if requestlist [inx].text.len < 8 then
	      write(OUTPUT, chr(HT));
	    end;
	  inx := pred(inx);
	  end
	until inx < 0;
	if (count mod 3) <> 0 then
	  writeln(OUTPUT);
	end;
      writeln(OUTPUT);
      notified := true;
      end;
    end
  else
    begin
    send(inx);
    writeln(OUTPUT, functions.action [inx].description);
    end;

  end;

end.

