UNIT Encryption ;

{

   This UNIT will encrypt files for you in a unique way:  Record by record in
   memory.  As each record is written, it is encrypted.  To read them back, the
   program merely reads in the record and then decrypts it - IN MEMORY.  The
   files are never again decrypted, thus preventing an abnormal termination
   from leaving sensitive data totally bare.  The actual Encryption and
   Decryption statements are deleted from this file to prevent trouble with
   exporting encryption technology.  The accompanying READ.ME file has more
   information about how to replace it ;-).  The method explained is VERY basic
   and is intended to stop casual snooping more than experienced hackers ( who
   will get into what they have access to! ) so be wary of them!

   This unit is considered Copy Righted.  See the READ.ME file for procedure
   and function explanations and more on the copy right.

}


                                  INTERFACE




CONST
       UNEXPECTED_END_SOURCE                     = 1000 ;
       NOT_ENOUGH_MEMORY                         = 1001 ;


VAR
       EncryptError                              : WORD ;



 PROCEDURE   ReadEncrypt( VAR f                  : FILE ;
                          VAR buffer                    ;
                              size               : WORD ) ;

 PROCEDURE   WriteEncrypt( VAR f                 : FILE ;
                           VAR buffer                   ;
                               size              : WORD ) ;

 PROCEDURE   SeekEncrypt( VAR f                  : FILE ;
                              size               : WORD ;
                              position           : LONGINT ) ;

 FUNCTION    FilePosEncrypt( VAR f               : FILE ;
                                 size            : WORD )
                                                 : LONGINT ;

 FUNCTION    FileSizeEncrypt( VAR f              : FILE )
                                                 : LONGINT ;

 PROCEDURE   ResetEncrypt( VAR f                 : FILE ) ;

 PROCEDURE   ReWriteEncrypt( VAR f               : FILE ) ;


                                IMPLEMENTATION


USES
       AsmRoutines ,
       DOS ,
       CRT ;





 PROCEDURE   ReadEncrypt( VAR f                  : FILE ;
                          VAR buffer                    ;
                              size               : WORD ) ;

  TYPE
       Decrypter                                 =
           ARRAY [ 1 .. 1 ] OF BYTE ;

  VAR
       numRead                                   : WORD ;
       tSize                                     : LONGINT ;
       deCrypt                                   : Decrypter
                                                   ABSOLUTE
                                                   buffer ;


   BEGIN  {  ReadEncrypt  }

     BlockRead( f , buffer , size , numRead ) ;

     IF ( numRead < size )
      THEN
          EncryptError := UNEXPECTED_END_SOURCE

      ELSE
          EncryptError := 0 ;

     tSize := size ;

     WHILE ( tSize > 0 )
      DO
       BEGIN  {  WHILE  }

         {   Insert decryption statement here - see READ.ME  }

         DEC ( tSize ) ;

       END ;  {  WHILE  }

   END ;  {  ReadEncrypt  }






 PROCEDURE   WriteEncrypt( VAR f                 : FILE ;
                           VAR buffer                   ;
                               size              : WORD ) ;

  TYPE
       Decrypter                                 =
           ARRAY [ 1 .. 1 ] OF BYTE ;

  VAR
       numWritten                                : WORD ;

       tSize                                     : LONGINT ;

       deCrypt                                   : Decrypter
         ABSOLUTE
         buffer ;

       tempBuffer                                : POINTER ;

   BEGIN  {  WriteEncrypt  }

     IF ( MaxAvail < size )
      THEN
       BEGIN

         EncryptError := NOT_ENOUGH_MEMORY ;

         Exit ;

       END ;  {  IF  }

     GetMem ( tempBuffer , size ) ;

     Move ( buffer , tempBuffer^ , size ) ;

     tSize := size ;

     WHILE ( tSize > 0 )
      DO
       BEGIN  {  WHILE  }

         {  Insert encryption statement here - see READ.ME  }

         DEC ( tSize ) ;

       END ;  {  WHILE  }

     BlockWrite( f , buffer , size , numWritten ) ;

     Move ( tempBuffer^ , buffer , size ) ;

     FreeMem ( tempBuffer , size ) ;

     IF ( numWritten < size )
      THEN
          EncryptError := DosError

      ELSE
          EncryptError := 0 ;

   END ;  {  WriteEncrypt  }




 PROCEDURE   SeekEncrypt( VAR f                  : FILE ;
                              size               : WORD ;
                              position           : LONGINT ) ;

   BEGIN  {  SeekEncrypt  }

     Seek ( f , ( position * size ) ) ;

   END ;  {  SeekEncrypt  }





 FUNCTION    FileSizeEncrypt( VAR f              : FILE )
                                                 : LONGINT ;

   BEGIN  {  FileSizeEncrypt  }

     FileSizeEncrypt := FileSize ( f ) ;

   END ;  {  FileSizeEncrypt  }





 FUNCTION    FilePosEncrypt( VAR f               : FILE ;
                                 size            : WORD )
                                                 : LONGINT ;

   BEGIN  {  FilePosEncrypt  }

     FilePosEncrypt := FilePos ( f ) DIV  size ;

   END ;  {  FilePosEncrypt  }




 PROCEDURE   ResetEncrypt( VAR f                 : FILE ) ;

   BEGIN  {  ResetEncrypt  }

     ReSet ( f , 1 ) ;

   END ;  {  ResetEncrypt  }






 PROCEDURE   ReWriteEncrypt( VAR f               : FILE ) ;

   BEGIN  {  ReWriteEncrypt  }

     ReWrite ( f , 1 ) ;

   END ;  {  ReWriteEncrypt  }





BEGIN

  EncryptError := 0 ;                       {  no error yet !  }

END.   {  *****  Encryption  *****  }