/*
 * Decompiled with CFR 0.152.
 */
package com.jxcell.server.image.plugins;

import com.jxcell.server.image.plugins.B;
import com.jxcell.server.image.plugins.J;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class F
extends B {
    public boolean bUseTrueColor = true;
    public boolean bIncludeAlpha = false;
    private OutputStream EYFN;
    private final ByteArrayOutputStream I = new ByteArrayOutputStream(8192);

    public F() {
        this.isHILO = true;
    }

    public final void saveToStream(Image image, int n, OutputStream outputStream, boolean bl) {
        this.stream = outputStream;
        int[] nArray = this.grab(image, n);
        this.Depth(nArray);
        try {
            this.makeHeader(this.bUseTrueColor ? (this.bIncludeAlpha ? 6 : 2) : 3);
            this.makeComment("Copyright", "GreenPoint, Inc.");
            this.makeComment("Software", "WebCharts 3D");
            if (!this.bUseTrueColor) {
                byte[] byArray = new byte[this.Width * this.Height];
                for (int i = 0; i < this.Width * this.Height; ++i) {
                    byArray[i] = (byte)this.colorTable.indexOf(nArray[i]);
                }
                this.makePalette();
                this.makePixels(this.getPixels(byArray));
            } else {
                this.makePixels(this.getPixels(nArray));
            }
            this.makeFooter();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private void Depth(int[] nArray) {
        if (!this.bUseTrueColor) {
            this.colorTable = new J();
            for (int i = 0; i < this.Width * this.Height && !this.bUseTrueColor; ++i) {
                this.colorTable.addElement(nArray[i]);
                if (this.colorTable.size() <= 256) continue;
                this.bUseTrueColor = true;
            }
        }
        if (!this.bUseTrueColor) {
            if (this.colorTable.size() <= 2) {
                this.Depth = 1;
            } else if (this.colorTable.size() <= 4) {
                this.Depth = 2;
            } else if (this.colorTable.size() <= 16) {
                this.Depth = 4;
            } else if (this.colorTable.size() <= 256) {
                this.Depth = 8;
            }
        } else {
            this.Depth = 8;
        }
    }

    public final void makeHeader(int n) {
        this.writeString("\u0089PNG\r\n\u001a\n");
        this.writeLong(13);
        this.Height();
        this.writeString("IHDR");
        this.writeLong(this.Width);
        this.writeLong(this.Height);
        this.write((byte)this.Depth);
        this.write((byte)n);
        this.write((byte)0);
        this.write((byte)0);
        this.write((byte)0);
        this.I();
    }

    public final void makeComment(String string, String string2) {
        this.writeLong(string.length() + 1 + string2.length());
        this.Height();
        this.writeString("tEXt");
        this.writeString(string);
        this.writeByte((byte)0);
        this.writeString(string2);
        this.I();
    }

    public final void makePalette() {
        this.writeLong(3 * this.colorTable.size());
        this.Height();
        this.writeString("PLTE");
        for (int i = 0; i < this.colorTable.size(); ++i) {
            this.write((byte)(this.colorTable.at(i) >> 16 & 0xFF));
            this.write((byte)(this.colorTable.at(i) >> 8 & 0xFF));
            this.write((byte)(this.colorTable.at(i) & 0xFF));
        }
        this.I();
    }

    public final void makePixels(byte[] byArray) {
        this.writeLong(byArray.length);
        this.Height();
        this.writeString("IDAT");
        this.writeBytes(byArray);
        this.I();
    }

    public final void makeFooter() {
        this.writeLong(0);
        this.Height();
        this.writeString("IEND");
        this.I();
    }

    private void Height() {
        this.EYFN = this.stream;
        this.stream = new CheckedOutputStream(this.stream, new CRC32());
    }

    private void I() {
        long l = ((CheckedOutputStream)this.stream).getChecksum().getValue();
        this.stream = this.EYFN;
        this.writeLong((int)l);
    }

    private DeflaterOutputStream Width() {
        this.I.reset();
        return new DeflaterOutputStream((OutputStream)this.I, new Deflater(1));
    }

    public final byte[] getPixels(byte[] byArray) {
        this.addElement(this.Width(), byArray);
        return this.I.toByteArray();
    }

    public final byte[] getPixels(int[] nArray) {
        this.at(this.Width(), nArray);
        return this.I.toByteArray();
    }

    private void addElement(DeflaterOutputStream deflaterOutputStream, byte[] byArray) {
        int n = 8 / this.Depth;
        int n2 = this.Width / n * n;
        for (int i = 0; i < this.Height; ++i) {
            int n3 = i * this.Width;
            deflaterOutputStream.write(0);
            this.compressRow(i, byArray);
            deflaterOutputStream.write(byArray, n3, (this.Width + n - 1) / n);
            deflaterOutputStream.flush();
        }
        deflaterOutputStream.finish();
    }

    private void at(DeflaterOutputStream deflaterOutputStream, int[] nArray) {
        byte[] byArray = new byte[this.Width * (this.bIncludeAlpha ? 4 : 3)];
        int n = 0;
        for (int i = 0; i < this.Height; ++i) {
            deflaterOutputStream.write(0);
            int n2 = 0;
            for (int j = 0; j < this.Width; ++j) {
                int n3 = nArray[n++];
                byArray[n2++] = (byte)(n3 >> 16 & 0xFF);
                byArray[n2++] = (byte)(n3 >> 8 & 0xFF);
                byArray[n2++] = (byte)(n3 & 0xFF);
                if (!this.bIncludeAlpha) continue;
                byArray[n2++] = (byte)(n3 >> 24 & 0xFF);
            }
            deflaterOutputStream.write(byArray);
            deflaterOutputStream.flush();
        }
        deflaterOutputStream.finish();
    }
}

