/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sql.OffsetDST;
import oracle.sql.TRANSDUMP;

public class TIMEZONETAB {
    private static Hashtable zonetab = new Hashtable();
    private static int OFFSET_HOUR = 20;
    private static int OFFSET_MINUTE = 60;
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int BYTE_SIZE = 10;

    public static void addTrans(byte[] byArray, int n2) {
        int[] nArray = new int[BYTE_SIZE];
        int n3 = byArray[0] & 0xFF;
        Vector<OffsetDST> vector = new Vector<OffsetDST>(n3);
        int n4 = 1;
        while (n4 < n3 * BYTE_SIZE) {
            int n5 = 0;
            while (n5 < BYTE_SIZE) {
                nArray[n5] = byArray[n5 + n4] & 0xFF;
                ++n5;
            }
            int n6 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, n6);
            calendar.set(2, nArray[2] - 1);
            calendar.set(5, nArray[3]);
            calendar.set(11, nArray[4] - 1);
            calendar.set(12, nArray[5] - 1);
            calendar.set(13, nArray[6] - 1);
            calendar.set(14, 0);
            long l2 = calendar.getTime().getTime();
            int n7 = (nArray[7] - OFFSET_HOUR) * HOUR_MILLISECOND + (nArray[8] - OFFSET_MINUTE) * MINUTE_MILLISECOND;
            byte by = (byte)nArray[9];
            vector.addElement(new OffsetDST(new Timestamp(l2), n7, by));
            n4 += BYTE_SIZE;
        }
        zonetab.put(new Integer(n2 & 0x1FF), vector);
    }

    public static boolean checkID(int n2) {
        int n3 = n2 & 0x1FF;
        int[] nArray = new int[zonetab.size()];
        nArray = TIMEZONETAB.getIDs();
        int n4 = 0;
        while (n4 < zonetab.size()) {
            if (n3 == nArray[n4]) break;
            ++n4;
        }
        return n4 == zonetab.size();
    }

    public static void displayTable(int n2) {
        Vector vector = new Vector();
        Timestamp timestamp = new Timestamp(0L);
        boolean bl = false;
        boolean bl2 = false;
        vector = (Vector)zonetab.get(new Integer(n2));
        Enumeration enumeration = vector.elements();
        int n3 = 0;
        while (n3 < vector.size()) {
            System.out.print(((OffsetDST)vector.elementAt(n3)).getTimestamp().toString());
            System.out.print("    " + ((OffsetDST)vector.elementAt(n3)).getOFFSET());
            System.out.println("    " + ((OffsetDST)vector.elementAt(n3)).getDSTFLAG());
            ++n3;
        }
    }

    private static int[] getIDs() {
        int[] nArray = new int[zonetab.size()];
        int n2 = 0;
        Enumeration enumeration = zonetab.keys();
        while (enumeration.hasMoreElements()) {
            nArray[n2++] = (Integer)enumeration.nextElement();
        }
        return nArray;
    }

    public static byte getLocalOffset(Calendar calendar, int n2, OffsetDST offsetDST) throws NullPointerException, SQLException {
        Vector vector = new Vector();
        int n3 = 0;
        byte by = 0;
        Calendar calendar2 = Calendar.getInstance();
        Calendar calendar3 = Calendar.getInstance();
        Calendar calendar4 = Calendar.getInstance();
        calendar4.setTime(new Timestamp(calendar.getTime().getTime()));
        int n4 = 0;
        int n5 = 0;
        Calendar calendar5 = Calendar.getInstance();
        calendar5.set(1, calendar4.get(1));
        calendar5.set(2, calendar4.get(2));
        calendar5.set(5, 1);
        calendar5.set(11, 0);
        calendar5.set(12, 0);
        calendar5.set(13, 0);
        calendar5.set(14, 0);
        Timestamp timestamp = new Timestamp(calendar5.getTime().getTime());
        boolean bl = false;
        vector = (Vector)zonetab.get(new Integer(n2 & 0x1FF));
        Enumeration enumeration = vector.elements();
        int n6 = 0;
        while (enumeration.hasMoreElements()) {
            if (timestamp.before(((OffsetDST)enumeration.nextElement()).getTimestamp())) {
                if (n6 == 0) {
                    throw new SQLException();
                }
                n4 = n6 - 1;
                n5 = n6;
                n3 = n6;
                break;
            }
            ++n6;
        }
        if (n6 == vector.size()) {
            n3 = n6 - 1;
        } else {
            int n7 = ((OffsetDST)vector.elementAt(n4)).getOFFSET();
            int n8 = ((OffsetDST)vector.elementAt(n5)).getOFFSET();
            byte by2 = ((OffsetDST)vector.elementAt(n4)).getDSTFLAG();
            byte by3 = ((OffsetDST)vector.elementAt(n5)).getDSTFLAG();
            calendar2.setTime(((OffsetDST)vector.elementAt(n4)).getTimestamp());
            calendar3.setTime(((OffsetDST)vector.elementAt(n5)).getTimestamp());
            calendar2.add(10, n7 / HOUR_MILLISECOND);
            calendar2.add(12, n7 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
            calendar3.add(10, n8 / HOUR_MILLISECOND);
            calendar3.add(12, n8 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
            boolean bl2 = calendar4.before(calendar2);
            if (bl2) {
                n3 -= 2;
            } else if (calendar4.before(calendar3) && !calendar4.equals(calendar3)) {
                --n3;
            } else if (by2 < by3) {
                calendar4.add(10, -1);
                if (calendar4.before(calendar2)) {
                    --n3;
                }
            }
            if (by2 < by3) {
                calendar3.add(10, -1);
                if (calendar3.after(calendar)) {
                    by = 0;
                } else {
                    calendar3.add(10, 1);
                    by = calendar3.after(calendar) ? (byte)1 : 0;
                }
            } else if (by3 < by2) {
                calendar3.add(10, 1);
                if (calendar3.before(calendar)) {
                    by = 0;
                } else {
                    calendar3.add(10, -1);
                    by = calendar3.after(calendar) ? (byte)0 : 1;
                }
            }
        }
        offsetDST.setOFFSET(((OffsetDST)vector.elementAt(n3)).getOFFSET());
        offsetDST.setDSTFLAG(((OffsetDST)vector.elementAt(n3)).getDSTFLAG());
        return by;
    }

    public static int getOffset(Calendar calendar, int n2) throws NullPointerException, SQLException {
        Vector vector = new Vector();
        int n3 = 0;
        boolean bl = false;
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        vector = (Vector)zonetab.get(new Integer(n2 & 0x1FF));
        Enumeration enumeration = vector.elements();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            if (timestamp.before(((OffsetDST)enumeration.nextElement()).getTimestamp())) {
                if (n4 != 0) break;
                throw new SQLException();
            }
            ++n4;
        }
        n3 = n4 - 1;
        return ((OffsetDST)vector.elementAt(n3)).getOFFSET();
    }

    public static void updateTable(Connection connection, int n2) throws SQLException, NullPointerException {
        byte[] byArray = TRANSDUMP.getTransitions(connection, n2);
        if (byArray == null) {
            throw new NullPointerException();
        }
        TIMEZONETAB.addTrans(byArray, n2);
    }
}

