/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class LobPlsqlUtil {
    static boolean PLSQL_DEBUG = false;
    static final int MAX_PLSQL_SIZE = 32512;
    static final int MAX_PLSQL_INSTR_SIZE = 32512;
    static final int MAX_CHUNK_SIZE = 32512;

    public static long plsql_read(BLOB bLOB, long l2, long l3, byte[] byArray) throws SQLException {
        return LobPlsqlUtil.plsql_read(bLOB.getConnection(), bLOB, 2004, l2, l3, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long plsql_write(BLOB bLOB, long l2, byte[] byArray, int n2) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        int n3 = 0;
        oracleCallableStatement = (OracleCallableStatement)bLOB.getConnection().prepareCall("begin dbms_lob.write (?, ?, ?, ?); end;");
        try {
            int n4 = Math.min(n2, 32512);
            byte[] byArray2 = new byte[n4];
            oracleCallableStatement.registerOutParameter(1, 2004);
            while (n3 < n2) {
                n4 = Math.min(n2 - n3, 32512);
                System.arraycopy(byArray, n3, byArray2, 0, n4);
                oracleCallableStatement.setBLOB(1, bLOB);
                oracleCallableStatement.setInt(2, n4);
                oracleCallableStatement.setLong(3, l2 + (long)n3);
                oracleCallableStatement.setBytes(4, byArray2);
                oracleCallableStatement.execute();
                n3 += n4;
                bLOB.setLocator(oracleCallableStatement.getBLOB(1).getLocator());
            }
            Object var10_8 = null;
            if (oracleCallableStatement == null) return n3;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return n3;
    }

    public static long plsql_length(BLOB bLOB) throws SQLException {
        return LobPlsqlUtil.plsql_length(bLOB.getConnection(), bLOB, 2004);
    }

    public static long plsql_hasPattern(BLOB bLOB, byte[] byArray, long l2) throws SQLException {
        return LobPlsqlUtil.plsql_hasPattern(bLOB.getConnection(), bLOB, 2004, byArray, l2);
    }

    public static long plsql_isSubLob(BLOB bLOB, BLOB bLOB2, long l2) throws SQLException {
        return LobPlsqlUtil.plsql_isSubLob(bLOB.getConnection(), bLOB, 2004, bLOB2, l2);
    }

    public static long plsql_getChunkSize(BLOB bLOB) throws SQLException {
        return LobPlsqlUtil.plsql_getChunkSize(bLOB.getConnection(), bLOB, 2004);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long plsql_read(CLOB cLOB, long l2, long l3, char[] cArray) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        int n2 = 0;
        int n3 = 1;
        try {
            try {
                Object var9_7 = null;
                boolean bl = false;
                OracleConnection oracleConnection = cLOB.getConnection();
                DBConversion dBConversion = oracleConnection.conversion;
                boolean bl2 = DBConversion.isCharSetMultibyte(dBConversion.getAccessCharSet());
                if (bl2) {
                    n3 = oracleConnection.db_access.getMaxCharSize();
                }
                oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin dbms_lob.read(?, ?, ?, ?); end;");
                int n4 = 0;
                int n5 = 0;
                byte[] byArray = null;
                char[] cArray2 = new char[32512];
                if (cLOB.isNCLOB()) {
                    oracleCallableStatement.setFormOfUse(1, (short)2);
                    oracleCallableStatement.setFormOfUse(4, (short)2);
                    if (dBConversion.IsNCharFixedWith()) {
                        n3 = 2;
                    }
                }
                oracleCallableStatement.setCLOB(1, cLOB);
                oracleCallableStatement.registerOutParameter(2, 2);
                oracleCallableStatement.registerOutParameter(4, 12);
                while ((long)n2 < l3) {
                    n5 = (int)Math.min(l3 - (long)n2, (long)(32512 / n3));
                    oracleCallableStatement.setInt(2, n5);
                    oracleCallableStatement.setLong(3, l2 + (long)n2);
                    oracleCallableStatement.execute();
                    n4 = oracleCallableStatement.getInt(2);
                    byArray = oracleCallableStatement.getBytes(4);
                    int n6 = 0;
                    n6 = cLOB.isNCLOB() ? dBConversion.NCHARBytesToJavaChars(byArray, byArray.length, cArray2) : dBConversion.CHARBytesToJavaChars(byArray, byArray.length, cArray2);
                    if (n6 != n4) {
                        DBError.check_error(37, null);
                    }
                    System.arraycopy(cArray2, 0, cArray, n2, n4);
                    n2 += n4;
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 1403) {
                    throw sQLException;
                }
                Object var20_19 = null;
                if (oracleCallableStatement == null) return n2;
                oracleCallableStatement.close();
                return n2;
            }
            Object var20_18 = null;
            if (oracleCallableStatement == null) return n2;
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
                oracleCallableStatement = null;
            }
            throw throwable;
        }
        oracleCallableStatement.close();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long plsql_write(CLOB cLOB, long l2, char[] cArray, int n2) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        OracleConnection oracleConnection = cLOB.getConnection();
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            String string = null;
            int n4 = 0;
            DBConversion dBConversion = oracleConnection.conversion;
            boolean bl3 = DBConversion.isCharSetMultibyte(dBConversion.getAccessCharSet());
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin dbms_lob.write (?, ?, ?, ?); end;");
            if (cLOB.isNCLOB()) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.registerOutParameter(1, 2005);
            if (!bl3 && !cLOB.isNCLOB()) {
                while (n3 < n2) {
                    oracleCallableStatement.setCLOB(1, cLOB);
                    oracleCallableStatement.setLong(3, l2 + (long)n3);
                    n4 = Math.min(n2 - n3, 32512);
                    string = new String(cArray, n3, n4);
                    oracleCallableStatement.setInt(2, n4);
                    oracleCallableStatement.setString(4, string);
                    oracleCallableStatement.execute();
                    n3 += n4;
                    cLOB.setLocator(oracleCallableStatement.getCLOB(1).getLocator());
                }
            } else {
                int n5 = oracleConnection.db_access.getC2SNlsRatio();
                int n6 = dBConversion.getMaxCharbyteSize();
                if (cLOB.isNCLOB()) {
                    n6 = dBConversion.getMaxNCharbyteSize();
                    if (dBConversion.IsNCharFixedWith()) {
                        n5 = 2;
                    }
                }
                int n7 = 32512 / n5;
                int n8 = Math.min(n7 / n6, n2);
                int n9 = n8 / 3;
                int n10 = 100;
                byte[] byArray = new byte[n8 * n6];
                char[] cArray2 = new char[n8];
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                boolean bl4 = false;
                boolean bl5 = true;
                while (n3 < n2) {
                    oracleCallableStatement.setCLOB(1, cLOB);
                    oracleCallableStatement.setLong(3, l2 + (long)n3);
                    bl4 = false;
                    n14 = 0;
                    n15 = 0;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bl5 = true;
                    while (!bl4) {
                        if (n12 != 0) {
                            bl5 = false;
                            byteArrayOutputStream.write(byArray, 0, n12);
                            n14 += n12;
                            n12 = 0;
                            n15 += n13;
                            n13 = 0;
                        }
                        if (bl5) {
                            n13 = Math.min(n8, n2 - n11);
                            bl5 = false;
                        } else {
                            n13 = Math.min(n9, n2 - n11);
                            if (n13 * n6 + n14 > n7 && n13 > n10) {
                                n13 = n10;
                            }
                        }
                        if (n13 > 0) {
                            int n16 = 0;
                            while (n16 < n13) {
                                cArray2[n16] = cArray[n11 + n16];
                                ++n16;
                            }
                            n11 += n13;
                            n12 = cLOB.isNCLOB() ? dBConversion.javaCharsToNCHARBytes(cArray2, n13, byArray) : dBConversion.javaCharsToCHARBytes(cArray2, n13, byArray);
                            if (n14 + n12 <= n7) {
                                byteArrayOutputStream.write(byArray, 0, n12);
                                n15 += n13;
                                n14 += n12;
                                n12 = 0;
                                n13 = 0;
                                if (n14 != n7) continue;
                                bl4 = true;
                                continue;
                            }
                            bl4 = true;
                            continue;
                        }
                        bl4 = true;
                    }
                    if (n15 > 0) {
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        oracleCallableStatement.setInt(2, n15);
                        if (cLOB.isNCLOB()) {
                            oracleCallableStatement.setFormOfUse(4, (short)2);
                        }
                        oracleCallableStatement.setInternalBytes(4, byArray2, 1);
                        oracleCallableStatement.execute();
                        n3 += n15;
                        cLOB.setLocator(oracleCallableStatement.getCLOB(1).getLocator());
                        continue;
                    }
                    if (n3 >= n2) continue;
                    DBError.throwSqlException(1);
                }
            }
            Object var32_31 = null;
            if (oracleCallableStatement == null) return n3;
        }
        catch (Throwable throwable) {
            Object var32_32 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return n3;
    }

    public static long plsql_length(CLOB cLOB) throws SQLException {
        return LobPlsqlUtil.plsql_length(cLOB.getConnection(), cLOB, 2005);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long plsql_hasPattern(CLOB cLOB, char[] cArray, long l2) throws SQLException {
        if (cArray == null || l2 <= 0L) {
            return 0L;
        }
        OracleConnection oracleConnection = cLOB.getConnection();
        long l3 = cArray.length;
        long l4 = LobPlsqlUtil.plsql_length(oracleConnection, cLOB, 2005);
        if (l3 == 0L || l3 > l4 - l2 + 1L || l2 > l4) {
            return 0L;
        }
        if (l3 <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection)) {
            long l5;
            OracleCallableStatement oracleCallableStatement = null;
            try {
                oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin ? := dbms_lob.instr(?, ?, ?); end;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (cLOB.isNCLOB()) {
                    oracleCallableStatement.setFormOfUse(2, (short)2);
                    oracleCallableStatement.setFormOfUse(3, (short)2);
                }
                oracleCallableStatement.setCLOB(2, cLOB);
                oracleCallableStatement.setString(3, new String(cArray));
                oracleCallableStatement.setLong(4, l2);
                oracleCallableStatement.execute();
                l5 = oracleCallableStatement.getLong(1);
                Object var13_10 = null;
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                oracleCallableStatement.close();
                oracleCallableStatement = null;
                throw throwable;
            }
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            return l5;
        }
        int n2 = 0;
        long l6 = l2;
        boolean bl = false;
        long l7 = 0L;
        while (!bl) {
            if (l3 > l4 - l6 + 1L) {
                return 0L;
            }
            n2 = 0;
            int n3 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l3 - (long)n2);
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, n2, cArray2, 0, n3);
            long l8 = LobPlsqlUtil.plsql_hasPattern(cLOB, cArray2, l6);
            if (l8 == 0L) {
                return 0L;
            }
            l7 = l8;
            n2 += n3;
            l6 = l8 + (long)n3;
            boolean bl2 = true;
            while (bl2) {
                n3 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l3 - (long)n2);
                cArray2 = new char[n3];
                System.arraycopy(cArray, n2, cArray2, 0, n3);
                l8 = LobPlsqlUtil.plsql_hasPattern(cLOB, cArray2, l6);
                if (l8 == l6) {
                    l6 += (long)n3;
                    if ((long)(n2 += n3) != l3) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l8 == 0L) {
                    return 0L;
                }
                l6 = l8 - (long)n2;
                bl2 = false;
            }
        }
        return l7;
    }

    public static long plsql_isSubLob(CLOB cLOB, CLOB cLOB2, long l2) throws SQLException {
        if (cLOB2 == null || l2 <= 0L) {
            return 0L;
        }
        OracleConnection oracleConnection = cLOB.getConnection();
        long l3 = LobPlsqlUtil.plsql_length(oracleConnection, cLOB2, 2005);
        long l4 = LobPlsqlUtil.plsql_length(oracleConnection, cLOB, 2005);
        if (l3 == 0L || l3 > l4 - l2 + 1L || l2 > l4) {
            return 0L;
        }
        if (l3 <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection)) {
            char[] cArray = new char[(int)l3];
            cLOB2.getChars(1L, (int)l3, cArray);
            return LobPlsqlUtil.plsql_hasPattern(cLOB, cArray, l2);
        }
        int n2 = 0;
        long l5 = l2;
        boolean bl = false;
        long l6 = 0L;
        while (!bl) {
            if (l3 > l4 - l5 + 1L) {
                return 0L;
            }
            n2 = 0;
            int n3 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l3 - (long)n2);
            char[] cArray = new char[n3];
            cLOB2.getChars(n2 + 1, n3, cArray);
            long l7 = LobPlsqlUtil.plsql_hasPattern(cLOB, cArray, l5);
            if (l7 == 0L) {
                return 0L;
            }
            l6 = l7;
            n2 += n3;
            l5 = l7 + (long)n3;
            boolean bl2 = true;
            while (bl2) {
                n3 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l3 - (long)n2);
                cArray = new char[n3];
                cLOB2.getChars(n2 + 1, n3, cArray);
                l7 = LobPlsqlUtil.plsql_hasPattern(cLOB, cArray, l5);
                if (l7 == l5) {
                    l5 += (long)n3;
                    if ((long)(n2 += n3) != l3) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l7 == 0L) {
                    return 0L;
                }
                l5 = l7 - (long)n2;
                bl2 = false;
            }
        }
        return l6;
    }

    public static long plsql_getChunkSize(CLOB cLOB) throws SQLException {
        return LobPlsqlUtil.plsql_getChunkSize(cLOB.getConnection(), cLOB, 2005);
    }

    public static long plsql_read(BFILE bFILE, long l2, long l3, byte[] byArray) throws SQLException {
        return LobPlsqlUtil.plsql_read(bFILE.getConnection(), bFILE, -13, l2, l3, byArray);
    }

    public static long plsql_length(BFILE bFILE) throws SQLException {
        return LobPlsqlUtil.plsql_length(bFILE.getConnection(), bFILE, -13);
    }

    public static long plsql_hasPattern(BFILE bFILE, byte[] byArray, long l2) throws SQLException {
        return LobPlsqlUtil.plsql_hasPattern(bFILE.getConnection(), bFILE, -13, byArray, l2);
    }

    public static long plsql_isSubLob(BFILE bFILE, BFILE bFILE2, long l2) throws SQLException {
        return LobPlsqlUtil.plsql_isSubLob(bFILE.getConnection(), bFILE, -13, bFILE2, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void plsql_fileOpen(BFILE bFILE) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getConnection().prepareCall("begin dbms_lob.fileopen (?, ?); end;");
            oracleCallableStatement.setBFILE(1, bFILE);
            oracleCallableStatement.setInt(2, 0);
            oracleCallableStatement.registerOutParameter(1, -13);
            oracleCallableStatement.execute();
            bFILE.setLocator(oracleCallableStatement.getBFILE(1).getLocator());
            Object var3_2 = null;
            if (oracleCallableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean plsql_fileIsOpen(BFILE bFILE) throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getConnection().prepareCall("begin ? := dbms_lob.fileIsOpen(?); end; ");
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setBFILE(2, bFILE);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var4_3 = null;
            if (oracleCallableStatement == null) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean plsql_fileExists(BFILE bFILE) throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getConnection().prepareCall("begin ? := dbms_lob.fileExists(?); end; ");
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setBFILE(2, bFILE);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var4_3 = null;
            if (oracleCallableStatement == null) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String plsql_fileGetName(BFILE bFILE) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        String string = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getConnection().prepareCall("begin dbms_lob.fileGetName(?, ?, ?); end; ");
            oracleCallableStatement.setBFILE(1, bFILE);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            string = oracleCallableStatement.getString(3);
            Object var4_3 = null;
            if (oracleCallableStatement == null) return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String plsql_fileGetDirAlias(BFILE bFILE) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        String string = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getConnection().prepareCall("begin dbms_lob.fileGetName(?, ?, ?); end; ");
            oracleCallableStatement.setBFILE(1, bFILE);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            string = oracleCallableStatement.getString(2);
            Object var4_3 = null;
            if (oracleCallableStatement == null) return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void plsql_fileClose(BFILE bFILE) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getConnection().prepareCall("begin dbms_lob.fileclose (?); end;");
            oracleCallableStatement.setBFILE(1, bFILE);
            oracleCallableStatement.registerOutParameter(1, -13);
            oracleCallableStatement.execute();
            bFILE.setLocator(oracleCallableStatement.getBFILE(1).getLocator());
            Object var3_2 = null;
            if (oracleCallableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
    }

    private static int getPlsqlMaxInstrSize(OracleConnection oracleConnection) throws SQLException {
        DBConversion dBConversion = oracleConnection.conversion;
        boolean bl = DBConversion.isCharSetMultibyte(dBConversion.getAccessCharSet());
        int n2 = dBConversion.getMaxCharbyteSize();
        int n3 = 32512;
        if (bl) {
            n3 = 32512 / (oracleConnection.db_access.getC2SNlsRatio() * n2);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long plsql_read(OracleConnection oracleConnection, Datum datum, int n2, long l2, long l3, byte[] byArray) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        int n3 = 0;
        try {
            try {
                oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin dbms_lob.read (?, ?, ?, ?); end;");
                int n4 = 0;
                int n5 = 0;
                if (LobPlsqlUtil.isNCLOB(datum)) {
                    oracleCallableStatement.setFormOfUse(1, (short)2);
                    oracleCallableStatement.setFormOfUse(4, (short)2);
                }
                oracleCallableStatement.setObject(1, (Object)datum, n2);
                oracleCallableStatement.registerOutParameter(2, 2);
                oracleCallableStatement.registerOutParameter(4, -3);
                while ((long)n3 < l3) {
                    n5 = Math.min((int)l3, 32512);
                    oracleCallableStatement.setInt(2, n5);
                    oracleCallableStatement.setInt(3, (int)l2 + n3);
                    oracleCallableStatement.execute();
                    n4 = oracleCallableStatement.getInt(2);
                    byte[] byArray2 = oracleCallableStatement.getBytes(4);
                    System.arraycopy(byArray2, 0, byArray, n3, n4);
                    n3 += n4;
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 1403) {
                    throw sQLException;
                }
                Object var14_13 = null;
                if (oracleCallableStatement == null) return n3;
                oracleCallableStatement.close();
                return n3;
            }
            Object var14_12 = null;
            if (oracleCallableStatement == null) return n3;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
                oracleCallableStatement = null;
            }
            throw throwable;
        }
        oracleCallableStatement.close();
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long plsql_length(OracleConnection oracleConnection, Datum datum, int n2) throws SQLException {
        long l2 = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin ? := dbms_lob.getLength (?); end;");
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(2, (short)2);
            }
            oracleCallableStatement.setObject(2, (Object)datum, n2);
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.execute();
            l2 = oracleCallableStatement.getLong(1);
            Object var7_5 = null;
            if (oracleCallableStatement == null) return l2;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long plsql_hasPattern(OracleConnection oracleConnection, Datum datum, int n2, byte[] byArray, long l2) throws SQLException {
        if (byArray == null || l2 <= 0L) {
            return 0L;
        }
        long l3 = byArray.length;
        long l4 = LobPlsqlUtil.plsql_length(oracleConnection, datum, n2);
        if (l3 == 0L || l3 > l4 - l2 + 1L || l2 > l4) {
            return 0L;
        }
        if (l3 <= 32512L) {
            long l5;
            OracleCallableStatement oracleCallableStatement = null;
            try {
                oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin ? := dbms_lob.instr(?, ?, ?); end;");
                oracleCallableStatement.registerOutParameter(1, 2);
                oracleCallableStatement.setObject(2, (Object)datum, n2);
                oracleCallableStatement.setBytes(3, byArray);
                oracleCallableStatement.setLong(4, l2);
                oracleCallableStatement.execute();
                l5 = oracleCallableStatement.getLong(1);
                Object var14_11 = null;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                oracleCallableStatement.close();
                oracleCallableStatement = null;
                throw throwable;
            }
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            return l5;
        }
        int n3 = 0;
        long l6 = l2;
        boolean bl = false;
        long l7 = 0L;
        while (!bl) {
            if (l3 > l4 - l6 + 1L) {
                return 0L;
            }
            n3 = 0;
            int n4 = (int)Math.min(32512L, l3 - (long)n3);
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n3, byArray2, 0, n4);
            long l8 = LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n2, byArray2, l6);
            if (l8 == 0L) {
                return 0L;
            }
            l7 = l8;
            n3 += n4;
            l6 = l8 + (long)n4;
            boolean bl2 = true;
            while (bl2) {
                n4 = (int)Math.min(32512L, l3 - (long)n3);
                byArray2 = new byte[n4];
                System.arraycopy(byArray, n3, byArray2, 0, n4);
                l8 = LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n2, byArray2, l6);
                if (l8 == l6) {
                    l6 += (long)n4;
                    if ((long)(n3 += n4) != l3) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l8 == 0L) {
                    return 0L;
                }
                l6 = l8 - (long)n3;
                bl2 = false;
            }
        }
        return l7;
    }

    public static long plsql_isSubLob(OracleConnection oracleConnection, Datum datum, int n2, Datum datum2, long l2) throws SQLException {
        if (datum2 == null || l2 <= 0L) {
            return 0L;
        }
        long l3 = LobPlsqlUtil.plsql_length(oracleConnection, datum2, n2);
        long l4 = LobPlsqlUtil.plsql_length(oracleConnection, datum, n2);
        if (l3 == 0L || l3 > l4 - l2 + 1L || l2 > l4) {
            return 0L;
        }
        if (l3 <= 32512L) {
            byte[] byArray = new byte[(int)l3];
            LobPlsqlUtil.plsql_read(oracleConnection, datum2, n2, 1L, l3, byArray);
            return LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n2, byArray, l2);
        }
        int n3 = 0;
        long l5 = l2;
        boolean bl = false;
        long l6 = 0L;
        while (!bl) {
            if (l3 > l4 - l5 + 1L) {
                return 0L;
            }
            n3 = 0;
            int n4 = (int)Math.min(32512L, l3 - (long)n3);
            byte[] byArray = new byte[n4];
            LobPlsqlUtil.plsql_read(oracleConnection, datum2, n2, n3 + 1, n4, byArray);
            long l7 = LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n2, byArray, l5);
            if (l7 == 0L) {
                return 0L;
            }
            l6 = l7;
            n3 += n4;
            l5 = l7 + (long)n4;
            boolean bl2 = true;
            while (bl2) {
                n4 = (int)Math.min(32512L, l3 - (long)n3);
                byArray = new byte[n4];
                LobPlsqlUtil.plsql_read(oracleConnection, datum2, n2, n3 + 1, n4, byArray);
                l7 = LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n2, byArray, l5);
                if (l7 == l5) {
                    l5 += (long)n4;
                    if ((long)(n3 += n4) != l3) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l7 == 0L) {
                    return 0L;
                }
                l5 = l7 - (long)n3;
                bl2 = false;
            }
        }
        return l6;
    }

    private static boolean isNCLOB(Datum datum) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("oracle.sql.CLOB");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        if (!clazz.isInstance(datum)) {
            return false;
        }
        CLOB cLOB = (CLOB)datum;
        return cLOB.isNCLOB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long plsql_getChunkSize(OracleConnection oracleConnection, Datum datum, int n2) throws SQLException {
        long l2 = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            try {
                oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin ? := dbms_lob.getchunksize(?); end;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (LobPlsqlUtil.isNCLOB(datum)) {
                    oracleCallableStatement.setFormOfUse(2, (short)2);
                }
                oracleCallableStatement.setObject(2, (Object)datum, n2);
                oracleCallableStatement.execute();
                l2 = oracleCallableStatement.getLong(1);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 6550) {
                    throw sQLException;
                }
                l2 = 32512L;
                Object var8_6 = null;
                if (oracleCallableStatement == null) return l2;
                oracleCallableStatement.close();
                return l2;
            }
            Object var8_5 = null;
            if (oracleCallableStatement == null) return l2;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
                oracleCallableStatement = null;
            }
            throw throwable;
        }
        oracleCallableStatement.close();
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void plsql_trimLob(Connection connection, Datum datum, int n2, long l2) throws SQLException {
        long l3 = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.trim (?, ?); end;");
            oracleCallableStatement.registerOutParameter(1, n2);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.setObject(1, (Object)datum, n2);
            oracleCallableStatement.setLong(2, l2);
            oracleCallableStatement.execute();
            datum.setShareBytes(oracleCallableStatement.getBytes(1));
            Object var9_6 = null;
            if (oracleCallableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
    }

    public static long plsql_write(Connection connection, Datum datum, int n2, long l2, byte[] byArray, long l3, long l4) throws SQLException {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Datum plsql_createTemporaryLob(Connection connection, boolean bl, int n2, int n3) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        Datum datum = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.createTemporary (?," + (bl ? "TRUE" : "FALSE") + ", ?); end;");
            oracleCallableStatement.registerOutParameter(1, n3);
            oracleCallableStatement.setInt(2, n2);
            oracleCallableStatement.execute();
            datum = oracleCallableStatement.getOracleObject(1);
            Object var7_6 = null;
            if (oracleCallableStatement == null) return datum;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void plsql_freeTemporaryLob(Connection connection, Datum datum, int n2) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.freeTemporary (?); end;");
            oracleCallableStatement.registerOutParameter(1, n2);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.setOracleObject(1, datum);
            oracleCallableStatement.execute();
            datum.setShareBytes(oracleCallableStatement.getBytes(1));
            Object var5_4 = null;
            if (oracleCallableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean plsql_isTemporaryLob(Connection connection, Datum datum, int n2) throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin ? := dbms_lob.isTemporary (?); end;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(2, (short)2);
            }
            oracleCallableStatement.setOracleObject(2, datum);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var6_5 = null;
            if (oracleCallableStatement == null) return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void plsql_openLob(Connection connection, Datum datum, int n2, int n3) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.open (?, ?); end;");
            oracleCallableStatement.registerOutParameter(1, n3);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.setOracleObject(1, datum);
            oracleCallableStatement.setInt(2, n2);
            oracleCallableStatement.execute();
            datum.setShareBytes(oracleCallableStatement.getOracleObject(1).shareBytes());
            Object var6_5 = null;
            if (oracleCallableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void plsql_closeLob(Connection connection, Datum datum, int n2) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.close (?); end;");
            oracleCallableStatement.registerOutParameter(1, n2);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.setOracleObject(1, datum);
            oracleCallableStatement.execute();
            datum.setShareBytes(oracleCallableStatement.getOracleObject(1).shareBytes());
            Object var5_4 = null;
            if (oracleCallableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean plsql_isLobOpen(Connection connection, Datum datum, int n2) throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin ? := dbms_lob.isOpen(?); end; ");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(2, (short)2);
            }
            oracleCallableStatement.setOracleObject(2, datum);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var6_5 = null;
            if (oracleCallableStatement == null) return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return bl;
    }
}

