/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version = 0;
    private static String xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
    private static String xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
    private static String xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
    private static String xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
    private static String xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
    private static String xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
    private static String xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
    private static String xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
    private static String xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
    private static String xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
    private static String xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
    private static String xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection) throws XAException {
        super(connection);
        try {
            this.m_version = ((OracleConnection)connection).getVersionNumber();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.m_version < 8160) {
            throw new XAException(-6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void start(Xid xid, int n2) throws XAException {
        int n3;
        block19: {
            CallableStatement callableStatement;
            block17: {
                n3 = -1;
                callableStatement = null;
                this.disallowLocalTxnMode(-6);
                if (xid == null) {
                    throw new XAException(-5);
                }
                int n4 = n2 & 0xFF00;
                if ((n2 &= 0xFFFF00FF) != 0 && n2 != 0x8000000 && n2 != 0x200000 && (n2 & 2) != 2) {
                    throw new XAException(-5);
                }
                if ((n4 & 0xFF00) != 0 && n4 != 256 && n4 != 512 && n4 != 1024) {
                    throw new XAException(-5);
                }
                if ((n4 & 0xFF00) != 0 && (n2 & 0x8200000) != 0) {
                    throw new XAException(-5);
                }
                n2 |= n4;
                if (this.m_version == 8160) {
                    if (!(xid instanceof OracleXid)) {
                        throw new XAException(-6);
                    }
                    callableStatement = this.m_conn.prepareCall(xa_start_816);
                    callableStatement.registerOutParameter(1, -2);
                    byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                    callableStatement.setBytes(2, byArray);
                    callableStatement.setInt(3, this.m_timeout);
                    callableStatement.setInt(4, n2);
                    callableStatement.registerOutParameter(5, 2);
                    callableStatement.execute();
                    byte[] byArray2 = callableStatement.getBytes(1);
                    ((OracleXid)xid).setTxContext(byArray2);
                    n3 = callableStatement.getInt(5);
                    break block17;
                }
                callableStatement = this.m_conn.prepareCall(xa_start_post_816);
                callableStatement.registerOutParameter(1, 2);
                callableStatement.setInt(2, xid.getFormatId());
                callableStatement.setBytes(3, xid.getGlobalTransactionId());
                callableStatement.setBytes(4, xid.getBranchQualifier());
                callableStatement.setInt(5, this.m_timeout);
                callableStatement.setInt(6, n2);
                callableStatement.execute();
                n3 = callableStatement.getInt(1);
            }
            Object var9_9 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            callableStatement = null;
            {
                break block19;
                catch (SQLException sQLException) {
                    Object var9_10 = null;
                    try {
                        if (callableStatement != null) {
                            callableStatement.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    callableStatement = null;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (callableStatement != null) {
                        callableStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                callableStatement = null;
                throw throwable;
            }
        }
        this.checkError(n3);
        super.push(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void end(Xid xid, int n2) throws XAException {
        int n3;
        block17: {
            n3 = -1;
            Statement statement = null;
            if (xid == null) {
                throw new XAException(-5);
            }
            if (n2 != 0x2000000 && n2 != 0x4000000 && n2 != 0x20000000 && (n2 & 2) != 2) {
                throw new XAException(-5);
            }
            Xid xid2 = super.suspendStacked(xid, n2);
            super.pop();
            if (this.m_version == 8160) {
                if (!(xid instanceof OracleXid)) {
                    throw new XAException(-6);
                }
                statement = this.m_conn.prepareCall(xa_end_816);
                statement.registerOutParameter(1, 2);
                byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                statement.setBytes(2, byArray);
                statement.setInt(3, n2);
                statement.execute();
                n3 = statement.getInt(1);
            } else {
                statement = this.m_conn.prepareCall(xa_end_post_816);
                statement.registerOutParameter(1, 2);
                statement.setInt(2, xid.getFormatId());
                statement.setBytes(3, xid.getGlobalTransactionId());
                statement.setBytes(4, xid.getBranchQualifier());
                statement.setInt(5, n2);
                statement.execute();
                n3 = statement.getInt(1);
            }
            super.resumeStacked(xid2);
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement = null;
            {
                break block17;
                catch (SQLException sQLException) {
                    Object var8_9 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    statement = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                statement = null;
                throw throwable;
            }
        }
        this.checkError(n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        int n2;
        block16: {
            n2 = -1;
            int n3 = 0;
            Statement statement = null;
            if (xid == null) {
                throw new XAException(-5);
            }
            int n4 = bl ? 1 : 0;
            Xid xid2 = super.suspendStacked(xid);
            if (this.m_version == 8160) {
                if (!(xid instanceof OracleXid)) {
                    throw new XAException(-6);
                }
                statement = this.m_conn.prepareCall(xa_commit_816);
                statement.registerOutParameter(1, 2);
                byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                statement.setBytes(2, byArray);
                statement.setInt(3, n4);
                statement.registerOutParameter(4, 2);
                statement.execute();
                n2 = statement.getInt(1);
                n3 = statement.getInt(4);
                ((OracleXid)xid).setState(n3);
            } else {
                statement = this.m_conn.prepareCall(xa_commit_post_816);
                statement.registerOutParameter(1, 2);
                statement.setInt(2, xid.getFormatId());
                statement.setBytes(3, xid.getGlobalTransactionId());
                statement.setBytes(4, xid.getBranchQualifier());
                statement.setInt(5, n4);
                statement.execute();
                n2 = statement.getInt(1);
            }
            super.resumeStacked(xid2);
            Object var10_10 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement = null;
            {
                break block16;
                catch (SQLException sQLException) {
                    Object var10_11 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    statement = null;
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                statement = null;
                throw throwable;
            }
        }
        this.checkError(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int prepare(Xid xid) throws XAException {
        int n22;
        int n3;
        block18: {
            n3 = 0;
            int n4 = 0;
            Statement statement = null;
            if (xid == null) {
                throw new XAException(-5);
            }
            Xid xid2 = super.suspendStacked(xid);
            if (this.m_version == 8160) {
                if (!(xid instanceof OracleXid)) {
                    throw new XAException(-6);
                }
                statement = this.m_conn.prepareCall(xa_prepare_816);
                statement.registerOutParameter(1, 2);
                byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                statement.setBytes(2, byArray);
                statement.registerOutParameter(3, 2);
                statement.execute();
                n3 = statement.getInt(1);
                n4 = statement.getInt(3);
                ((OracleXid)xid).setState(n4);
            } else {
                statement = this.m_conn.prepareCall(xa_prepare_post_816);
                statement.registerOutParameter(1, 2);
                statement.setInt(2, xid.getFormatId());
                statement.setBytes(3, xid.getGlobalTransactionId());
                statement.setBytes(4, xid.getBranchQualifier());
                statement.execute();
                n3 = statement.getInt(1);
            }
            super.resumeStacked(xid2);
            Object var8_10 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement = null;
            {
                break block18;
                catch (SQLException sQLException) {
                    int n5 = sQLException.getErrorCode();
                    if (n5 == 3113 || n5 == 3114) {
                        n3 = n5;
                    }
                    Object var8_11 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    statement = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                statement = null;
                throw throwable;
            }
        }
        int n6 = n22 = n3 == 0 ? 0 : OracleXAException.errorConvert(n3);
        if (n22 != 0 && n22 != 3) {
            throw new OracleXAException(n3);
        }
        return n22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void forget(Xid xid) throws XAException {
        int n2;
        block16: {
            n2 = 0;
            int n3 = 0;
            Statement statement = null;
            if (xid == null) {
                throw new XAException(-5);
            }
            this.saveTxnMode();
            if (this.m_version == 8160) {
                if (!(xid instanceof OracleXid)) {
                    throw new XAException(-6);
                }
                statement = this.m_conn.prepareCall(" begin ? := JAVA_XA.xa_forget (?,?); end; ");
                statement.registerOutParameter(1, 2);
                byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                statement.setBytes(2, byArray);
                statement.registerOutParameter(3, 2);
                statement.execute();
                n2 = statement.getInt(1);
                n3 = statement.getInt(3);
                ((OracleXid)xid).setState(n3);
            } else {
                statement = this.m_conn.prepareCall(xa_forget_post_816);
                statement.registerOutParameter(1, 2);
                statement.setInt(2, xid.getFormatId());
                statement.setBytes(3, xid.getGlobalTransactionId());
                statement.setBytes(4, xid.getBranchQualifier());
                statement.execute();
                n2 = statement.getInt(1);
            }
            this.restoreTxnMode();
            Object var7_7 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement = null;
            {
                break block16;
                catch (SQLException sQLException) {
                    Object var7_8 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    statement = null;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                statement = null;
                throw throwable;
            }
        }
        this.checkError(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void rollback(Xid xid) throws XAException {
        int n2;
        block16: {
            n2 = 0;
            int n3 = 0;
            Statement statement = null;
            if (xid == null) {
                throw new XAException(-5);
            }
            Xid xid2 = super.suspendStacked(xid);
            if (this.m_version == 8160) {
                if (!(xid instanceof OracleXid)) {
                    throw new XAException(-6);
                }
                statement = this.m_conn.prepareCall(xa_rollback_816);
                statement.registerOutParameter(1, 2);
                byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                statement.setBytes(2, byArray);
                statement.registerOutParameter(3, 2);
                statement.execute();
                n2 = statement.getInt(1);
                n3 = statement.getInt(3);
                ((OracleXid)xid).setState(n3);
            } else {
                statement = this.m_conn.prepareCall(xa_rollback_post_816);
                statement.registerOutParameter(1, 2);
                statement.setInt(2, xid.getFormatId());
                statement.setBytes(3, xid.getGlobalTransactionId());
                statement.setBytes(4, xid.getBranchQualifier());
                statement.execute();
                n2 = statement.getInt(1);
            }
            super.resumeStacked(xid2);
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement = null;
            {
                break block16;
                catch (SQLException sQLException) {
                    Object var8_9 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    statement = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                statement = null;
                throw throwable;
            }
        }
        this.checkError(n2);
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

