/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.MAREngine;

public class TTCItem
extends DBItem {
    public MAREngine meg;
    private int type;

    protected TTCItem(MAREngine mAREngine, DBType dBType) {
        super(dBType.max_length);
        this.type = dBType.type;
        this.meg = mAREngine;
    }

    protected void setOriginalSize(int n2) {
        this.original_size = n2;
    }

    public void setArrayData(boolean bl, byte[] byArray) throws SQLException {
        this.is_null = bl;
        if (byArray != null) {
            if (byArray.length > DBType.max_bind_array_length && ((this.type == 96 || this.type == 1) && byArray.length > this.max_out_size || this.type == 23 && byArray.length > this.max_out_size)) {
                DBError.throwSqlException(70, new Integer(byArray.length));
            }
            this.data_size = byArray.length;
            this.byte_value = byArray;
        } else {
            this.byte_value = new byte[0];
            this.data_size = 0;
        }
    }

    public void setArrayData(boolean bl, String string, int n2) throws SQLException {
        this.is_null = bl;
        if (string != null) {
            this.byte_value = this.StringToBytes(string, n2);
            this.data_size = this.byte_value.length;
            if ((this.type == 96 || this.type == 1) && this.data_size > this.max_out_size) {
                DBError.throwSqlException(70, new Integer(this.data_size));
            }
        } else {
            this.byte_value = new byte[0];
            this.data_size = 0;
        }
    }

    protected boolean isNull() {
        return this.is_null;
    }

    protected int getDataSize() {
        return this.data_size;
    }

    protected void marshal() throws IOException, SQLException {
        if (!(this.type != 113 && this.type != 112 && this.type != 114 || this.meg.proSvrVer < 6 || this.is_null)) {
            this.meg.marshalUB2(this.data_size);
        }
        this.meg.marshalCLR(this.byte_value, this.data_size);
    }

    public byte[] StringToBytes(String string, int n2) throws SQLException {
        byte[] byArray = n2 == 2 ? this.meg.conv.StringToNCharBytes(string) : this.meg.conv.StringToCharBytes(string);
        return byArray;
    }

    public char[] getChars(short s2) throws SQLException {
        this.char_value = new char[this.data_size];
        this.char_size = s2 == 2 ? this.meg.conv.NCHARBytesToJavaChars(this.byte_value, this.data_size, this.char_value) : this.meg.conv.CHARBytesToJavaChars(this.byte_value, this.data_size, this.char_value);
        return this.char_value;
    }

    protected void marshalPLSQL() throws IOException {
        this.meg.marshalCLR(new byte[0], 0);
    }

    protected void unmarshal() throws IOException, SQLException {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        if (this.byte_value == null) {
            DBError.check_error(401);
        }
        if ((this.type == 113 || this.type == 112 || this.type == 114) && this.meg.proSvrVer >= 6 && (n2 = this.meg.unmarshalUB2()) == 0) {
            this.is_null = true;
            return;
        }
        this.original_size = 0;
        this.data_size = 0;
        this.is_null = false;
        if (this.max_out_size == 0) {
            this.is_null = true;
            return;
        }
        int[] nArray = new int[1];
        Object var5_5 = null;
        this.meg.unmarshalCLR(this, nArray);
        this.data_size = nArray[0];
        this.is_null = nArray[0] <= 0;
    }

    public void unmarshalIndicator() throws IOException, SQLException {
        this.original_size = this.meg.processIndicator(this.is_null, this.data_size);
    }

    public void print(int n2, int n3, int n4) {
        OracleLog.print(this, n2, n3, n4, "           ---- Enter: TTCItem.print --- ");
        OracleLog.print(this, n2, n3, n4, "             +++ TTCItem.DBItem  Information +++");
        OracleLog.print(this, n2, n3, n4, "             DBItem.byte_value is: " + (this.byte_value == null ? " NULL " : "Not NULL"));
        if (this.byte_value != null) {
            OracleLog.print(this, n2, n3, n4, "             DBItem.byte_value.length = " + this.byte_value.length);
        }
        OracleLog.print(this, n2, n3, n4, "             DBItem.stream_value is: " + (this.stream_value == null ? " NULL " : "Not NULL"));
        OracleLog.print(this, n2, n3, n4, "             DBItem.data_size = " + this.data_size);
        OracleLog.print(this, n2, n3, n4, "             DBItem.original_size = " + this.original_size);
        OracleLog.print(this, n2, n3, n4, "             DBItem.max_out_size = " + this.max_out_size);
        OracleLog.print(this, n2, n3, n4, "             +++ End of TTCItem.DBItem  Info.+++");
        OracleLog.print(this, n2, n3, n4, "           ---- Exit: TTCItem.print --- ");
    }
}

