/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.TTCConversion;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTCTypeRep;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;

public class MAREngine {
    public static final int TTCC_MXL = 252;
    public static final int TTCC_ESC = 253;
    public static final int TTCC_LNG = 254;
    public static final int TTCC_ERR = 255;
    public static final int TTCC_MXIN = 64;
    public static final byte TTCLXMULTI = 1;
    public static final byte TTCLXMCONV = 2;
    public TTCTypeRep types;
    public Communication net;
    public TTCConversion conv;
    public byte proSvrVer;
    protected InputStream inStream;
    protected OutputStream outStream;
    final byte[] ignored = new byte[255];
    final byte[] tmpBuffer1 = new byte[1];
    final byte[] tmpBuffer2 = new byte[2];
    final byte[] tmpBuffer3 = new byte[3];
    final byte[] tmpBuffer4 = new byte[4];
    final int[] retLen = new int[1];

    protected static String toHex(long l2, int n2) {
        String string;
        switch (n2) {
            case 1: {
                string = "00" + Long.toString(l2 & 0xFFL, 16);
                break;
            }
            case 2: {
                string = "0000" + Long.toString(l2 & 0xFFFFL, 16);
                break;
            }
            case 3: {
                string = "000000" + Long.toString(l2 & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                string = "00000000" + Long.toString(l2 & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                string = "0000000000" + Long.toString(l2 & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                string = "000000000000" + Long.toString(l2 & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                string = "00000000000000" + Long.toString(l2 & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return MAREngine.toHex(l2 >> 32, 4) + MAREngine.toHex(l2, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + string.substring(string.length() - 2 * n2);
    }

    protected static String toHex(byte by) {
        String string = "00" + Integer.toHexString(by & 0xFF);
        return "0x" + string.substring(string.length() - 2);
    }

    protected static String toHex(short s2) {
        return MAREngine.toHex(s2, 2);
    }

    protected static String toHex(int n2) {
        return MAREngine.toHex(n2, 4);
    }

    protected static String toHex(byte[] byArray, int n2) {
        if (byArray == null) {
            return "null";
        }
        if (n2 > byArray.length) {
            return "byte array not long enough";
        }
        String string = "[";
        int n3 = Math.min(64, n2);
        int n4 = 0;
        while (n4 < n3) {
            string = string + MAREngine.toHex(byArray[n4]) + " ";
            ++n4;
        }
        if (n3 < n2) {
            string = string + "...";
        }
        return string + "]";
    }

    protected static String toHex(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return MAREngine.toHex(byArray, byArray.length);
    }

    public MAREngine(Communication communication) throws SQLException, IOException {
        if (communication == null) {
            DBError.check_error(433);
        }
        this.net = communication;
        try {
            this.inStream = communication.getInputStream();
            this.outStream = communication.getOutputStream();
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        this.types = new TTCTypeRep();
        this.types.setRep((byte)1, (byte)2);
    }

    public void initBuffers() {
    }

    protected void marshalSB1(byte by) throws IOException {
        this.outStream.write(by);
    }

    protected void marshalUB1(short s2) throws IOException {
        this.outStream.write((byte)(s2 & 0xFF));
    }

    protected void marshalSB2(short s2) throws IOException {
        byte by = this.value2Buffer(s2, this.tmpBuffer2, (byte)1);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer2, 0, by);
        }
    }

    protected void marshalUB2(int n2) throws IOException {
        this.marshalSB2((short)(n2 & 0xFFFF));
    }

    protected void marshalSB4(int n2) throws IOException {
        byte by = this.value2Buffer(n2, this.tmpBuffer4, (byte)2);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer4, 0, by);
        }
    }

    protected void marshalUB4(long l2) throws IOException {
        this.marshalSB4((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
    }

    protected void marshalSWORD(int n2) throws IOException {
        this.marshalSB4(n2);
    }

    protected void marshalUWORD(long l2) throws IOException {
        this.marshalSB4((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
    }

    protected void marshalB1Array(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray);
        }
    }

    protected void marshalB1Array(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray, n2, n3);
        }
    }

    protected void marshalUB4Array(long[] lArray) throws IOException {
        int n2 = 0;
        while (n2 < lArray.length) {
            this.marshalSB4((int)(lArray[n2] & 0xFFFFFFFFFFFFFFFFL));
            ++n2;
        }
    }

    public void marshalO2U(boolean bl) throws IOException {
        if (bl) {
            this.addPtr((byte)1);
        } else {
            this.addPtr((byte)0);
        }
    }

    public void marshalNULLPTR() throws IOException {
        this.addPtr((byte)0);
    }

    public void marshalPTR() throws IOException {
        this.addPtr((byte)1);
    }

    protected void marshalCHR(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            if (this.types.isConvNeeded()) {
                this.marshalCLR(byArray, byArray.length);
            } else {
                this.outStream.write(byArray);
            }
        }
    }

    protected void marshalCLR(byte[] byArray, int n2) throws IOException {
        if (n2 > 64) {
            int n3;
            int n4 = 0;
            this.outStream.write(-2);
            do {
                int n5;
                n3 = (n5 = n2 - n4) > 64 ? 64 : n5;
                this.outStream.write((byte)(n3 & 0xFF));
                this.outStream.write(byArray, n4, n3);
            } while ((n4 += n3) < n2);
            this.outStream.write(0);
        } else {
            this.outStream.write((byte)(n2 & 0xFF));
            if (byArray.length != 0) {
                this.outStream.write(byArray);
            }
        }
    }

    public void marshalDALC(byte[] byArray) throws SQLException, IOException {
        if (byArray == null || byArray.length < 1) {
            this.outStream.write(0);
        } else {
            this.marshalSB4(0xFFFFFFFF & byArray.length);
            this.marshalCLR(byArray, byArray.length);
        }
    }

    protected void addPtr(byte by) throws IOException {
        if ((this.types.rep[3] & 1) > 0) {
            this.outStream.write(by);
        } else {
            byte by2 = this.value2Buffer(by, this.tmpBuffer4, (byte)3);
            if (by2 != 0) {
                this.outStream.write(this.tmpBuffer4, 0, by2);
            }
        }
    }

    protected byte value2Buffer(int n2, byte[] byArray, byte by) throws IOException {
        boolean bl = true;
        byte by2 = 0;
        int n3 = byArray.length - 1;
        while (n3 >= 0) {
            byArray[by2] = (byte)(n2 >>> 8 * n3 & 0xFF);
            if ((this.types.rep[by] & 1) > 0) {
                if (!bl || byArray[by2] != 0) {
                    bl = false;
                    by2 = (byte)(by2 + 1);
                }
            } else {
                by2 = (byte)(by2 + 1);
            }
            --n3;
        }
        if ((this.types.rep[by] & 1) > 0) {
            this.outStream.write(by2);
        }
        if ((this.types.rep[by] & 2) > 0) {
            this.reverseArray(byArray, by2);
        }
        return by2;
    }

    protected void reverseArray(byte[] byArray, byte by) {
        int n2 = 0;
        while (n2 < by / 2) {
            byte by2 = byArray[n2];
            byArray[n2] = byArray[by - 1 - n2];
            byArray[by - 1 - n2] = by2;
            ++n2;
        }
    }

    public byte unmarshalSB1() throws SQLException, IOException {
        byte by = (byte)this.unmarshalUB1();
        return by;
    }

    public short unmarshalUB1() throws SQLException, IOException {
        short s2 = 0;
        try {
            while (true) {
                try {
                    s2 = (short)this.inStream.read();
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        if (s2 < 0) {
            DBError.check_error(410);
        }
        return s2;
    }

    public short unmarshalSB2() throws SQLException, IOException {
        short s2 = (short)this.unmarshalUB2();
        return s2;
    }

    public int unmarshalUB2() throws SQLException, IOException {
        int n2 = (int)this.buffer2Value((byte)1);
        return n2 & 0xFFFF;
    }

    public int unmarshalUCS2(byte[] byArray, long l2) throws SQLException, IOException {
        int n2 = 0;
        int n3 = 2;
        if ((this.types.rep[1] & 1) > 0) {
            try {
                while (true) {
                    try {
                        n3 = this.inStream.read();
                    }
                    catch (BreakNetException breakNetException) {
                        this.net.sendReset();
                        continue;
                    }
                    break;
                }
            }
            catch (NetException netException) {
                throw new IOException(netException.getMessage());
            }
            if ((n3 & 0x80) > 0) {
                n3 &= 0x7F;
            }
            if (n3 < 0) {
                DBError.check_error(410);
            }
        }
        if (n3 > 2 || n3 < 1) {
            DBError.check_error(412);
        } else {
            byte[] byArray2 = n3 == 1 ? this.tmpBuffer1 : this.tmpBuffer2;
            boolean bl = true;
            try {
                while (true) {
                    try {
                        if (this.inStream.read(byArray2) < 0) {
                            DBError.check_error(410);
                        }
                    }
                    catch (BreakNetException breakNetException) {
                        this.net.sendReset();
                        continue;
                    }
                    break;
                }
            }
            catch (NetException netException) {
                throw new IOException(netException.getMessage());
            }
            if (n3 == 1) {
                byArray[(int)l2] = 0;
                byArray[(int)l2 + 1] = byArray2[0];
                n2 = 2;
            } else {
                if ((this.types.rep[1] & 2) > 0) {
                    byArray[(int)l2] = byArray2[1];
                    byArray[(int)l2 + 1] = byArray2[0];
                } else {
                    byArray[(int)l2] = byArray2[0];
                    byArray[(int)l2 + 1] = byArray2[1];
                }
                n2 = 3;
            }
        }
        return n2;
    }

    public int unmarshalSB4() throws SQLException, IOException {
        int n2 = (int)this.unmarshalUB4();
        return n2;
    }

    public long unmarshalUB4() throws SQLException, IOException {
        long l2 = this.buffer2Value((byte)2);
        return l2;
    }

    public int unmarshalSB4(byte[] byArray) throws SQLException, IOException {
        long l2 = this.buffer2Value((byte)2, new ByteArrayInputStream(byArray));
        return (int)l2;
    }

    public int unmarshalRefCursor(byte[] byArray) throws SQLException, IOException {
        int n2 = this.unmarshalSB4(byArray);
        return n2;
    }

    public int unmarshalSWORD() throws SQLException, IOException {
        int n2 = (int)this.unmarshalUB4();
        return n2;
    }

    public long unmarshalUWORD() throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        return l2;
    }

    public byte[] unmarshalNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        try {
            while (true) {
                try {
                    if (this.inStream.read(byArray) < 0) {
                        DBError.check_error(410);
                    }
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        return byArray;
    }

    public int unmarshalNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        int n4 = 0;
        while (n4 < n3) {
            n4 += this.getNBytes(byArray, n2 + n4, n3 - n4);
        }
        return n4;
    }

    public int getNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        int n4 = 0;
        try {
            while (true) {
                try {
                    n4 = this.inStream.read(byArray, n2, n3);
                    if (n4 < 0) {
                        DBError.check_error(410);
                    }
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        return n4;
    }

    public byte[] getNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        try {
            while (true) {
                try {
                    if (this.inStream.read(byArray) < 0) {
                        DBError.check_error(410);
                    }
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        return byArray;
    }

    public byte[] unmarshalTEXT(int n2) throws SQLException, IOException {
        byte[] byArray;
        int n3 = 0;
        byte[] byArray2 = new byte[n2];
        while (n3 < n2) {
            try {
                while (true) {
                    try {
                        if (this.inStream.read(byArray2, n3, 1) < 0) {
                            DBError.check_error(410);
                        }
                    }
                    catch (BreakNetException breakNetException) {
                        this.net.sendReset();
                        continue;
                    }
                    break;
                }
            }
            catch (NetException netException) {
                throw new IOException(netException.getMessage());
            }
            if (byArray2[n3++] == 0) break;
        }
        if (byArray2.length == --n3) {
            byArray = byArray2;
        } else {
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        return byArray;
    }

    public byte[] unmarshalCHR(int n2) throws SQLException, IOException {
        byte[] byArray = null;
        if (this.types.isConvNeeded()) {
            byArray = this.unmarshalCLR(n2, this.retLen);
            if (byArray.length != this.retLen[0]) {
                byte[] byArray2 = new byte[this.retLen[0]];
                System.arraycopy(byArray, 0, byArray2, 0, this.retLen[0]);
                byArray = byArray2;
            }
        } else {
            byArray = this.getNBytes(n2);
        }
        return byArray;
    }

    public void unmarshalCLR(TTCItem tTCItem, int[] nArray) throws SQLException, IOException {
        short s2 = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = -1;
        s2 = this.unmarshalUB1();
        if (s2 < 0) {
            DBError.check_error(401);
        }
        if (s2 == 0) {
            return;
        }
        if (this.escapeSequenceNull(s2)) {
            nArray[0] = 0;
            return;
        }
        if (s2 != 254) {
            n2 = this.unmarshalBuffer(tTCItem.byte_value, n2, s2);
        } else {
            n3 = -1;
            block5: while (n3 == -1 || (s2 = this.unmarshalUB1()) > 0) {
                if (s2 == 254) {
                    switch (n3) {
                        case -1: {
                            n3 = 1;
                            continue block5;
                        }
                        case 1: {
                            n3 = 0;
                            break;
                        }
                        case 0: {
                            if (bl) {
                                n3 = 0;
                                break;
                            }
                            n3 = 0;
                            continue block5;
                        }
                    }
                }
                if (n2 == -1) {
                    this.unmarshalBuffer(this.ignored, 0, s2);
                } else {
                    n2 = this.unmarshalBuffer(tTCItem.byte_value, n2, s2);
                }
                n3 = 0;
                if (s2 <= 252) continue;
                bl = true;
            }
        }
        if (nArray != null) {
            nArray[0] = n2 != -1 ? n2 : tTCItem.byte_value.length;
        }
    }

    /*
     * Unable to fully structure code
     */
    public byte[] unmarshalCLR(int var1_1, int[] var2_2) throws SQLException, IOException {
        block6: {
            block7: {
                block5: {
                    var3_3 = 0;
                    var4_4 = 0;
                    var5_5 = this.unmarshalUB1();
                    if (var5_5 < 0) {
                        DBError.check_error(401);
                    }
                    if (var5_5 == 0) {
                        var2_2[0] = 0;
                        return new byte[0];
                    }
                    var6_6 = new byte[var1_1 * this.conv.getNLSRATIO()];
                    if (!this.escapeSequenceNull(var5_5)) break block5;
                    var2_2[0] = 0;
                    break block6;
                }
                if (var5_5 == 254) ** GOTO lbl23
                var4_4 = this.unmarshalBuffer(var6_6, var4_4, var5_5);
                break block7;
lbl-1000:
                // 1 sources

                {
                    if (var3_3 == 254 && this.types.isServerConversion()) continue;
                    if (var4_4 == -1) {
                        this.unmarshalBuffer(this.ignored, 0, var3_3);
                        continue;
                    }
                    var4_4 = this.unmarshalBuffer(var6_6, var4_4, var3_3);
lbl23:
                    // 4 sources

                    ** while ((var3_3 = this.unmarshalUB1()) > 0)
                }
            }
            if (var2_2 != null) {
                var2_2[0] = var4_4 != -1 ? var4_4 : var6_6.length;
            }
        }
        return var6_6;
    }

    private int unmarshalBuffer(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        if (byArray.length < n2 + n3) {
            this.unmarshalNBytes(byArray, n2, byArray.length - n2);
            this.unmarshalNBytes(this.ignored, 0, n2 + n3 - byArray.length);
            n2 = -1;
        } else {
            this.unmarshalNBytes(byArray, n2, n3);
            n2 += n3;
        }
        return n2;
    }

    public byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        short s2 = 0;
        short s3 = 0;
        byte[] byArray = null;
        Vector<byte[]> vector = new Vector<byte[]>(10, 10);
        short s4 = this.unmarshalUB1();
        if (s4 < 0) {
            DBError.check_error(401);
        }
        if (s4 == 0) {
            return null;
        }
        if (!this.escapeSequenceNull(s4)) {
            byte[] byArray2;
            if (s4 == 254) {
                while ((s2 = this.unmarshalUB1()) > 0) {
                    if (s2 == 254 && this.types.isServerConversion()) continue;
                    s3 = (short)(s3 + s2);
                    byArray2 = new byte[s2];
                    this.unmarshalBuffer(byArray2, 0, s2);
                    vector.addElement(byArray2);
                }
            } else {
                s3 = s4;
                byArray2 = new byte[s4];
                this.unmarshalBuffer(byArray2, 0, s4);
                vector.addElement(byArray2);
            }
            byArray = new byte[s3];
            int n2 = 0;
            while (vector.size() > 0) {
                int n3 = ((byte[])vector.elementAt(0)).length;
                System.arraycopy(vector.elementAt(0), 0, byArray, n2, n3);
                n2 += n3;
                vector.removeElementAt(0);
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    public boolean escapeSequenceNull(int n2) throws SQLException {
        boolean bl = false;
        switch (n2) {
            case 0: {
                bl = true;
                break;
            }
            case 253: {
                DBError.check_error(401);
            }
            case 255: {
                bl = true;
                break;
            }
            case 254: {
                break;
            }
        }
        return bl;
    }

    public int processIndicator(boolean bl, int n2) throws SQLException, IOException {
        short s2 = this.unmarshalSB2();
        int n3 = 0;
        if (!bl) {
            n3 = s2 == 0 ? n2 : (s2 == -2 || s2 > 0 ? (int)s2 : 65536 + s2);
        }
        return n3;
    }

    public byte[] unmarshalDALC() throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        byte[] byArray = new byte[(int)(0xFFFFFFFFFFFFFFFFL & l2)];
        if (byArray.length > 0) {
            if ((byArray = this.unmarshalCLR(byArray.length, this.retLen)) == null) {
                DBError.check_error(401);
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public byte[] unmarshalDALC(int[] nArray) throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        byte[] byArray = new byte[(int)(0xFFFFFFFFFFFFFFFFL & l2)];
        if (byArray.length > 0) {
            if ((byArray = this.unmarshalCLR(byArray.length, nArray)) == null) {
                DBError.check_error(401);
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    private long buffer2Value(byte by) throws SQLException, IOException {
        byte[] byArray;
        int n2 = 0;
        long l2 = 0L;
        boolean bl = false;
        if ((this.types.rep[by] & 1) > 0) {
            try {
                while (true) {
                    try {
                        n2 = this.inStream.read();
                    }
                    catch (BreakNetException breakNetException) {
                        this.net.sendReset();
                        continue;
                    }
                    break;
                }
            }
            catch (NetException netException) {
                throw new IOException(netException.getMessage());
            }
            if ((n2 & 0x80) > 0) {
                n2 &= 0x7F;
                bl = true;
            }
            if (n2 < 0) {
                DBError.check_error(410);
            }
            if (n2 == 0) {
                return 0L;
            }
            if (by == 1 && n2 > 2 || by == 2 && n2 > 4) {
                DBError.check_error(412);
            }
        } else if (by == 1) {
            n2 = 2;
        } else if (by == 2) {
            n2 = 4;
        }
        switch (n2) {
            case 1: {
                byArray = this.tmpBuffer1;
                break;
            }
            case 2: {
                byArray = this.tmpBuffer2;
                break;
            }
            case 3: {
                byArray = this.tmpBuffer3;
                break;
            }
            case 4: {
                byArray = this.tmpBuffer4;
                break;
            }
            default: {
                byArray = new byte[n2];
                break;
            }
        }
        try {
            while (true) {
                try {
                    if (this.inStream.read(byArray) < 0) {
                        DBError.check_error(410);
                    }
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        int n3 = 0;
        while (n3 < byArray.length) {
            short s2 = (this.types.rep[by] & 2) > 0 ? (short)(byArray[byArray.length - 1 - n3] & 0xFF) : (short)(byArray[n3] & 0xFF);
            l2 |= (long)(s2 << 8 * (byArray.length - 1 - n3));
            ++n3;
        }
        l2 &= 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l2 *= -1L;
        }
        return l2;
    }

    private long buffer2Value(byte by, ByteArrayInputStream byteArrayInputStream) throws SQLException, IOException {
        byte[] byArray;
        int n2 = 0;
        long l2 = 0L;
        boolean bl = false;
        if ((this.types.rep[by] & 1) > 0) {
            n2 = byteArrayInputStream.read();
            if ((n2 & 0x80) > 0) {
                n2 &= 0x7F;
                bl = true;
            }
            if (n2 < 0) {
                DBError.check_error(410);
            }
            if (n2 == 0) {
                return 0L;
            }
            if (by == 1 && n2 > 2 || by == 2 && n2 > 4) {
                DBError.check_error(412);
            }
        } else if (by == 1) {
            n2 = 2;
        } else if (by == 2) {
            n2 = 4;
        }
        if (byteArrayInputStream.read(byArray = new byte[n2]) < 0) {
            DBError.check_error(410);
        }
        int n3 = 0;
        while (n3 < byArray.length) {
            short s2 = (this.types.rep[by] & 2) > 0 ? (short)(byArray[byArray.length - 1 - n3] & 0xFF) : (short)(byArray[n3] & 0xFF);
            l2 |= (long)(s2 << 8 * (byArray.length - 1 - n3));
            ++n3;
        }
        l2 &= 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l2 *= -1L;
        }
        return l2;
    }
}

