/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oci8;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.oci8.OCIDBAccess;

public class OCIEnv {
    long OCIEnvHandle = 0L;
    OCIDBAccess access;
    long refCount;
    short envCharSetId = 0;
    static OCIEnv environment = null;

    public OCIEnv(OCIDBAccess oCIDBAccess) {
        this.access = oCIDBAccess;
        this.OCIEnvHandle = 0L;
        this.refCount = 0L;
    }

    public static synchronized OCIEnv getEnv(OCIDBAccess oCIDBAccess) {
        if (environment == null) {
            environment = new OCIEnv(oCIDBAccess);
        }
        return environment;
    }

    public synchronized long getRefCount() {
        return this.refCount;
    }

    public synchronized long getEnvHandle() throws SQLException {
        int n2;
        if (this.refCount == 0L && (n2 = this.get_env_handle()) < 0) {
            DBError.throwSqlException(n2, this);
        }
        ++this.refCount;
        return this.OCIEnvHandle;
    }

    public synchronized void freeEnvHandle() throws SQLException {
        if (this.refCount > 0L) {
            --this.refCount;
        }
        if (this.refCount == 0L) {
            if (this.access.logon_mode != 6) {
                this.access.check_error(this.free_env_handle(), null);
            }
        }
    }

    native int get_env_handle();

    native int free_env_handle();
}

