/*
 * Decompiled with CFR 0.152.
 */
package unity.relational;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import unity.relational.Relation;
import unity.relational.Tuple;
import unity.util.Convert;

public class TupleTS
extends Tuple {
    private int timestamp;

    public TupleTS(Relation r, int TS) {
        super(r);
        this.timestamp = TS;
    }

    public TupleTS(Object[] vals, Relation r, int TS) {
        super(vals, r);
        this.timestamp = TS;
    }

    public TupleTS(Tuple t, int TS) {
        super(t.relation);
        this.values = t.values;
        this.timestamp = TS;
    }

    public TupleTS(TupleTS t) {
        super(t);
        this.timestamp = t.timestamp;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int TS) {
        this.timestamp = TS;
    }

    public void negateTimestamp() {
        this.timestamp = -1 * Math.abs(this.timestamp);
    }

    public boolean read(BufferedInputStream in) throws IOException {
        byte[] tmp = new byte[4];
        if (in.read(tmp, 0, 4) == -1) {
            return false;
        }
        this.timestamp = Convert.toInt(tmp);
        return super.read(in);
    }

    public void write(BufferedOutputStream out) throws IOException {
        out.write(Convert.toByte(this.timestamp));
        super.write(out);
    }

    public String toString() {
        String st = "TS: " + this.timestamp + "\tTuple: " + super.toString();
        return st;
    }
}

