/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import unity.annotation.AnnotatedSourceField;
import unity.operators.Operator;
import unity.query.GQFieldRef;
import unity.query.LocalQuery;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;
import unity.util.StringFunc;
import unity.util.VerifySystem;

public class ResultSetScan
extends Operator {
    protected ResultSet rs;
    protected ResultSetMetaData metadata;
    private int numCols;
    private Object[] obj;
    private String sqlQueryString;
    private boolean delayedExecution = false;
    private LocalQuery query;

    public ResultSetScan(LocalQuery lq) {
        this.rs = null;
        this.query = lq;
        this.sqlQueryString = this.query.getSQLQueryString();
    }

    public ResultSetScan(ResultSet r) {
        this.rs = r;
        this.outputRelation = null;
    }

    public void setResultSet(ResultSet r) {
        this.rs = r;
    }

    public String getSQLString() {
        return this.sqlQueryString;
    }

    public void setSQLString(String s) {
        this.sqlQueryString = s;
    }

    public void setDelayedExecution(boolean b) {
        this.delayedExecution = b;
    }

    public boolean getDelayedExecution() {
        return this.delayedExecution;
    }

    public void buildOutputRelation(ArrayList outputFields) {
        Attribute[] attrs = new Attribute[outputFields.size()];
        int i = 0;
        while (i < outputFields.size()) {
            GQFieldRef fref = (GQFieldRef)outputFields.get(i);
            AnnotatedSourceField asf = fref.getField();
            int type = asf.getDataType();
            attrs[i] = new Attribute(asf.getColumnName(), type, asf.getColumnSize(), fref);
            ++i;
        }
        this.outputRelation = new Relation(attrs);
    }

    /*
     * Unable to fully structure code
     */
    public void init() throws IOException {
        tm = (int)System.currentTimeMillis();
        if (tm % 500 != 0) ** GOTO lbl12
        try {
            VerifySystem.verifyReg();
            if (true) ** GOTO lbl12
        }
        catch (SQLException e) {
            throw new IOException(e.toString());
        }
        do {
            Thread.yield();
            if (this.query == null || !this.query.hasErrorMessage()) continue;
            throw new IOException(this.query.getErrorMessage());
lbl12:
            // 3 sources

        } while (this.rs == null);
        if (this.outputRelation == null) {
            try {
                this.metadata = this.rs.getMetaData();
                this.numCols = this.metadata.getColumnCount();
                this.obj = new Object[this.numCols];
                attrs = new Attribute[this.numCols];
                i = 1;
                while (i <= this.numCols) {
                    attrs[i - 1] = new Attribute(this.metadata.getColumnName(i), this.metadata.getColumnType(i), this.metadata.getColumnDisplaySize(i));
                    ++i;
                }
                this.outputRelation = new Relation(attrs);
            }
            catch (SQLException e) {
                throw new IOException(e.toString());
            }
        }
        try {
            this.numCols = this.rs.getMetaData().getColumnCount();
        }
        catch (Exception e) {
            System.out.println("Exception thrown -  " + e);
        }
        this.obj = new Object[this.numCols];
    }

    public Tuple next() throws IOException {
        try {
            if (!this.rs.next()) {
                return null;
            }
            int i = 1;
            while (i <= this.numCols) {
                this.obj[i - 1] = this.rs.getObject(i);
                ++i;
            }
            Tuple t = new Tuple(this.obj, this.outputRelation);
            this.incrementTuplesRead();
            this.incrementTuplesOutput();
            return t;
        }
        catch (SQLException e) {
            throw new IOException(e.toString());
        }
    }

    public void close() throws IOException {
        try {
            this.rs.getStatement().close();
            this.rs.close();
        }
        catch (SQLException e) {
            throw new IOException(e.toString());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(250);
        sb.append("RESULTSET SCAN: Database=" + this.query.getDatabaseName() + " ; Query: " + StringFunc.oneLineSQL(this.sqlQueryString));
        return sb.toString();
    }
}

