/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.IOException;
import unity.operators.Operator;
import unity.predicates.EquiJoinPredicate;
import unity.relational.Relation;
import unity.relational.Tuple;

public class MergeJoin
extends Operator {
    private int MERGE_BUFFER_SIZE = 10000;
    private Tuple[] tup;
    private Tuple[] buffer;
    private boolean inBuffer;
    private int numInBuffer;
    private int curBufferPosition;
    private boolean endLeft;
    private EquiJoinPredicate pred;

    public MergeJoin(Operator[] in, EquiJoinPredicate p) {
        super(in, 0, 0);
        this.pred = p;
        Relation out = new Relation(this.input[0].getOutputRelation());
        out.mergeRelation(this.input[1].getOutputRelation());
        this.setOutputRelation(out);
    }

    public void init() throws IOException {
        this.tup = new Tuple[this.numInputs];
        int i = 0;
        while (i < this.numInputs) {
            this.input[i].init();
            ++i;
        }
        i = 0;
        while (i < this.numInputs) {
            this.tup[i] = this.input[i].next();
            this.incrementTuplesRead();
            ++i;
        }
        this.buffer = new Tuple[this.MERGE_BUFFER_SIZE];
        this.inBuffer = false;
        this.endLeft = false;
    }

    public Tuple next() throws IOException {
        block0: while (!this.endLeft || this.inBuffer) {
            if (!this.inBuffer) {
                while (true) {
                    if (this.pred.isLessThan(this.tup[0], this.tup[1])) {
                        this.tup[0] = this.input[0].next();
                        if (this.tup[0] == null) break block0;
                        this.incrementTuplesRead();
                        continue;
                    }
                    while (this.pred.isGreaterThan(this.tup[0], this.tup[1])) {
                        this.tup[1] = this.input[1].next();
                        if (this.tup[1] == null) break block0;
                        this.incrementTuplesRead();
                    }
                    if (this.pred.isEqual(this.tup[0], this.tup[1])) break;
                }
                this.numInBuffer = 0;
                do {
                    this.buffer[this.numInBuffer] = new Tuple(this.tup[0]);
                    ++this.numInBuffer;
                    this.tup[0] = this.input[0].next();
                    if (this.tup[0] == null) {
                        this.endLeft = true;
                        break;
                    }
                    this.incrementTuplesRead();
                } while (this.pred.isEqual(this.tup[0], this.tup[1]));
                this.inBuffer = true;
                this.curBufferPosition = 0;
                continue;
            }
            do {
                if (this.curBufferPosition < this.numInBuffer) {
                    return this.outputJoinTuple(this.buffer[this.curBufferPosition++], this.tup[1]);
                }
                this.curBufferPosition = 0;
                this.tup[1] = this.input[1].next();
                if (this.tup[1] == null) {
                    this.inBuffer = false;
                    break block0;
                }
                this.incrementTuplesRead();
            } while (this.pred.isEqual(this.buffer[0], this.tup[1]));
            this.inBuffer = false;
        }
        return null;
    }

    public void close() throws IOException {
        super.close();
    }

    private Tuple outputJoinTuple(Tuple left, Tuple right) {
        Tuple t = new Tuple(left, right, this.getOutputRelation());
        this.incrementTuplesOutput();
        return t;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(250);
        sb.append("MERGE JOIN: ");
        sb.append(this.pred.toString(this.input[0].getOutputRelation(), this.input[1].getOutputRelation()));
        return sb.toString();
    }
}

