/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import unity.functions.Expression;
import unity.functions.Function;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class F_Power
extends Function {
    private Expression expr1;
    private Expression expr2;

    public F_Power(Expression e1, Expression e2) {
        this.expr1 = e1;
        this.expr2 = e2;
        this.returnType = Attribute.TYPE_DOUBLE;
    }

    public Object evaluate(Tuple t) {
        Object val1 = this.expr1.evaluate(t);
        if (val1 == null) {
            return null;
        }
        Object val2 = this.expr2.evaluate(t);
        if (val2 == null) {
            return null;
        }
        if (val1 instanceof Number && val2 instanceof Number) {
            return new Double(Math.pow(((Number)val1).doubleValue(), ((Number)val2).doubleValue()));
        }
        return null;
    }

    public int getReturnType() {
        return Attribute.TYPE_DOUBLE;
    }

    public static int[] getParamListTypes() {
        return new int[]{Attribute.TYPE_NUMBER, Attribute.TYPE_NUMBER};
    }

    public static String getFunctionName() {
        return "POW";
    }

    public String toString(Relation relation) {
        return "POW(" + this.expr1.toString(relation) + "," + this.expr2.toString(relation) + ")";
    }
}

