/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.util.ArrayList;
import unity.functions.Aggregate_Function;
import unity.functions.Expression;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class A_Sum
extends Aggregate_Function {
    protected double currentTotalDouble;
    protected int currentTotalInt;
    protected boolean hasData = false;
    protected boolean isIntType;

    public A_Sum(Expression exp) {
        this.children = new ArrayList(1);
        this.children.add(exp);
        this.computedExpr = exp;
        this.returnType = exp.getReturnType();
        this.isIntType = this.returnType == Attribute.TYPE_INT;
    }

    public void reset() {
        this.currentTotalDouble = 0.0;
        this.currentTotalInt = 0;
        this.hasData = false;
    }

    public Object compute() {
        if (this.hasData) {
            if (this.isIntType) {
                return new Integer(this.currentTotalInt);
            }
            return new Double(this.currentTotalDouble);
        }
        return null;
    }

    public void add(Tuple t) {
        Object val = this.computedExpr.evaluate(t);
        if (val != null) {
            if (this.isIntType) {
                this.currentTotalInt += ((Number)val).intValue();
            } else {
                this.currentTotalDouble += ((Number)val).doubleValue();
            }
            this.hasData = true;
        }
    }

    public String toString(Relation relation, Attribute outputAttribute) {
        return "SUM(" + this.computedExpr.toString(relation) + ") AS " + outputAttribute.getName();
    }
}

