/*
 * Decompiled with CFR 0.152.
 */
package unity.annotation;

import java.util.ArrayList;
import unity.annotation.SourceField;
import unity.annotation.SourceTable;

public class SourceKey {
    protected ArrayList key = new ArrayList();
    protected int keyType;
    protected String keyName;
    protected SourceTable table;

    public SourceKey(SourceTable newTable) {
        this.table = newTable;
    }

    public SourceKey(ArrayList newKey, int type, String name) {
        this.key = newKey;
        this.keyType = type;
        this.keyName = name;
    }

    public SourceKey(SourceTable table, int type, String name) {
        this.table = table;
        this.keyType = type;
        this.keyName = name == null ? "Undefined" : name;
    }

    public boolean matchKeyFields(ArrayList fields) {
        if (this.key.size() != fields.size()) {
            return false;
        }
        int i = 0;
        while (i < this.key.size()) {
            if (fields.indexOf(this.key.get(i)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public SourceKey(SourceTable table, ArrayList newKey, int type, String name) {
        this.table = table;
        this.key = newKey;
        this.keyType = type;
        this.keyName = name == null ? "Undefined" : name;
    }

    public ArrayList getFields() {
        return this.key;
    }

    public String getName() {
        return this.keyName;
    }

    public void setName(String name) {
        this.keyName = name;
    }

    public int getKeyType() {
        return this.keyType;
    }

    public void setKeyType(int type) {
        this.keyType = type;
    }

    public SourceTable getTable() {
        return this.table;
    }

    public void setTable(SourceTable st) {
        this.table = st;
    }

    public void addField(SourceField sf) {
        this.key.add(sf);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(2000);
        if (this.keyType == 1) {
            buf.append("    Primary Key\n");
        } else if (this.keyType != 2) {
            if (this.keyType == 3) {
                buf.append("    Candidate Key\n");
            } else if (this.keyType == 4) {
                buf.append("    Specified Join Key\n");
            } else if (this.keyType == 5) {
                buf.append("    Reference Key\n");
            }
        }
        buf.append("       Key Name: " + this.keyName + "\n");
        buf.append("       Key Type: " + this.keyType + "\n");
        buf.append("       Fields in Key\n");
        int i = 0;
        while (i < this.key.size()) {
            buf.append("   " + this.key.get(i) + "\n");
            ++i;
        }
        return buf.toString();
    }

    public String keyTypeToXML() {
        String s = this.keyType == 1 ? "     <PRIMARYKEY>\n" : (this.keyType == 2 ? "     <FOREIGNKEY>\n" : "     <CANDIDATEKEY>\n");
        return s;
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer(2000);
        buf.append("        <keyName>" + this.keyName + "</keyName>\n");
        buf.append("        <keyType>" + this.keyType + "</keyType>\n");
        buf.append("        <FIELDS>\n");
        int i = 0;
        while (i < this.key.size()) {
            buf.append("        " + ((SourceField)this.key.get(i)).toXMLKey() + "\n");
            ++i;
        }
        buf.append("        </FIELDS>\n");
        if (this.keyType == 1) {
            buf.append("     </PRIMARYKEY>");
        } else if (this.keyType > 2) {
            buf.append("     </CANDIDATEKEY>");
        }
        return buf.toString();
    }
}

