;----------------------------------------------------------------------------:
; SILVERMOON																 :
;																			 :
; VGA driving code and macros	(C) John Connors 1993						 :
;----------------------------------------------------------------------------:

		IDEAL
		P286N

		MODEL	HUGE,C
	    
		INCLUDE "VGA.INC"
		INCLUDE "STRUCTS.INC"			    

		PUBLIC	unchain_vga
	    
;----------------------------------------------------------------------------:
; set VGA write mode														 :
;----------------------------------------------------------------------------:


MACRO		Write_Mode Mode
		MOV DX,Graphics_Address_Port
		MOV AL,05h
		OUT DX,AL
		INC DX
		IN	AL,DX
		AND AL,NOT 011b
		OR	AL,Mode
		OUT DX,AL
ENDM

;----------------------------------------------------------------------------:
; set VGA Map Mask															 :
;----------------------------------------------------------------------------:

MACRO		Set_Map_Mask Mask
			Out_Index	Sequencer_Address_Port,Map_Mask,Mask
ENDM

;----------------------------------------------------------------------------:
; output to an indexed address/data port									 :
;----------------------------------------------------------------------------:

MACRO		Out_Index Port,Index,OutByte
		MOV DX,Port
		MOV AX,((OutByte)*0100h)+Index
		OUT DX,AX
ENDM

;----------------------------------------------------------------------------:
;				DATA SEGMENT												 :
;----------------------------------------------------------------------------:

			DATASEG


CRTC_Parameters:
		 dw 	 00014h  ;	turn off dword mode
		 dw 	 0e317h  ;	turn on byte mode

;----------------------------------------------------------------------------:
;			CODE SEGMENT													 :
;----------------------------------------------------------------------------:


			CODESEG
		    

;----------------------------------------------------------------------------:
; Unchain																	 :
; 'Unchains' the VGA display so that 64k of VGA memory is mapped into four	 :
; 16k bitplanes in the host memory - suitable for hardware scrolling		 :
;----------------------------------------------------------------------------:


PROC	unchain_vga     
		USES	DS,DX,CX,AX,SI

		MOV 	AH,0							; set VGA mode 0x13
		MOV 	AL,13h
		INT 	10h
		Out_Index	Sequencer_Address_Port,Memory_Mode,6
		Out_Index	Graphics_Address_Port,Miscellaneous,5
		MOV 	DX,CRTC_Address_Port
		MOV 	AL,Vertical_Retrace_End
		OUT 	DX,AL   
		INC 	DX
		IN		AL,DX
		AND 	AL,NOT 80h						; clobber write protect
		OUT 	DX,AL
		DEC 	DX
		CLD
		MOV 	AX,SEG CRTC_Parameters
		MOV 	DS,AX
		MOV 	SI,OFFSET CRTC_Parameters
		MOV 	CX,2
@@Set_CRTC_Parameters_Loop:
		MOV 	AX,[WORD SI]
		INC 	SI
		INC 	SI
		OUT 	DX,AX
		LOOP	@@Set_CRTC_Parameters_Loop		; set up CRTC chip
		RET

ENDP	unchain_vga


	END
