#ifdef __cplusplus
extern "C" {
#endif

typedef struct {			/* MAIN FLI header */
    long	size;                   /* Size of file */
    unsigned 	magic;                  /* 44817 = FLI, 44818 = FLC */
    int 	frames;                 /* Frames in animation */
    int 	width;			/* Animation width */
    int 	height;			/* Animation height */
    int 	depth;			/* Bits per pixel (8) */
    int 	flags;			/* Set to 0x0003 after ring frame */
    int 	speed;			/* Delay in msec between frames */
    int	        reserved;               /* Unused word, set to 0 */
    long 	created;		/* MSDOS format date/time */
    long 	creator;		/* Serial # of AnimPro */
    long	updated;		/* MSDOS format date/time */
    long	updater;		/* Yet another serial # */
    int		aspectx;		/* Aspect ratio of x-axis */
    int		aspecty;		/* Aspect ratio of y-axis */
    unsigned	reserved2[19];		/* 38 unused bytes, set to zeroes */
    long	oframe1;		/* Offset of frame 1 in file */
    long	oframe2;		/* Offset of frame 2 in file */
    unsigned	reserved3[20];		/* 40 unused bytes, set to zeroes */
} flicheader;

#define FLIC_DISK		1
#define FLIC_EMS		2

#define FLIC_OK			0
#define FLIC_NOTFOUND		1
#define FLIC_INVALIDRES		2
#define FLIC_INVALIDHEADER	3
#define FLIC_INVALIDFRAME	4
#define FLIC_INVALIDCHUNK	5
#define FLIC_DONE		6

extern int 	flic_mode;	/* Play from either disk or EMS */
extern int 	flic_color;	/* Palette will be adjusted if set to 1 */

extern flicheader flichdr;	/* Access this structure for general info */

extern block 	flicscreen;	/* Logical screen for FLI/FLC updates */
extern int 	flic_updatey;	/* Uppermost y position updated */
extern int 	flic_updatey2;	/* Lowermost y position updated */
extern int 	flic_update;	/* Indicates screen update */

extern int   openflic(char *);	/* Open up a FLI or FLC file */
extern int   nextframe(void);	/* Advance to the next frame */
extern void  copyflic(void);	/* Copy the FLISCREEN to the visual screen */
extern void  closeflic(void);	/* Close the FLI/FLC file */

#ifdef __cplusplus
}
#endif
