/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                           Demonstration Program 53                         
                                                                            
 VESA demonstration file. Any program which uses the WGT VESA library       
 requires the existence of a VESA driver. Most video card manufacturers     
 include software drivers with their installation diskettes. You can also   
 find drivers for most popular cards on a BBS.                              
                                                                            
 VESA calls perform the same functions as their 320*200 equivalents in WGT. 
 Some limitations exist. Virtual screens are still limited to 320*200, and  
 only a few of the WGT commands are implemented. Refer to the WGT Library   
 Reference to find out more about the commands and their use.               
                                                                            
  PROJECT                                                             
 This program requires the WGT4.LIB and WGTVESA.LIB files to be linked.     
                                                                            
  DATA FILES                                                          
 WGT1.BLK, WGT2.BLK, and WGT1.PAL must be in your executable directory.     
                                                                            
ͼ
*/

#include <conio.h>
#include <wgt4.h>
#include <wgtvesa.h>

block wgt;                    /* Pointer to our first image to load */
block wgt2;                   /* Pointer to our second image to load */
block ptr;                    /* Temporary pointer */
color pal[256];               /* Our color palette */
int videomode[10];            /* Array to hold supported modes */
int totalmodes;               /* Total number of supported VESA modes */

char vstring[5][18] = { "640  x 400  x 256", "640  x 480  x 256", 
                        "800  x 600  x 256", "1024 x 768  x 256", 
                        "1280 x 1024 x 256" };



void getmodes (void)
{
  totalmodes = 0;               /* Start counter at 0 modes supported */

  /* Now find supported modes and add them to our array */
  if (wvesa_supported(V640x400))
  {
    videomode[totalmodes] = V640x400;
    totalmodes++;
  }
  if (wvesa_supported(V640x480))
  {
    videomode[totalmodes] = V640x480;
    totalmodes++;
  }
  if (wvesa_supported(V800x600))
  {
    videomode[totalmodes] = V800x600;
    totalmodes++;
  }
  if (wvesa_supported(V1024x768))
  {
    videomode[totalmodes] = V1024x768;
    totalmodes++;
  }
  if (wvesa_supported(V1280x1024))
  {
    videomode[totalmodes] = V1280x1024;
    totalmodes++;
  }
}


void do_pixels (void)
{
  while (!kbhit())              /* Random pixels */
  {
    wsetcolor (rand() % 256);
    wvesa_putpixel (rand() % VESAmode.XResolution, rand() % VESAmode.YResolution);
  }
  getch();
}


void do_lines (void)
{
  while (!kbhit())              /* Random lines */
  {
    wsetcolor (rand() % 256);
    wvesa_line (0, 0, rand() % VESAmode.XResolution, rand() % VESAmode.YResolution);
  }
  getch();
}


void do_bars (void)
{
  while (!kbhit())              /* Random bars */
  {
    wsetcolor (rand() % 256);
    wvesa_bar (rand() % VESAmode.XResolution, rand() % VESAmode.YResolution,rand() % VESAmode.XResolution, rand() % VESAmode.YResolution);
  }
  getch();
}


void do_rectangles (void)
{
  while (!kbhit())              /* Random rectangles */
  {
    wsetcolor (rand() % 256);
    wvesa_rectangle (rand() % VESAmode.XResolution, rand() % VESAmode.YResolution,rand() % VESAmode.XResolution, rand() % VESAmode.YResolution);
  }
  getch();
}


void do_blocks (void)
{
  while (!kbhit())              /* Randomly paste blocks */
  {
    if (ptr == wgt)		/* Alternate between block 1 and block 2 */
      ptr = wgt2;
    else ptr = wgt;
    wvesa_putblock (rand() % VESAmode.XResolution, rand() % VESAmode.YResolution, ptr, XRAY);
  }
  getch ();
}


void do_text (void)
{
  wtexttransparent (TEXTFGBG);

  while (!kbhit())              /* Randomly place text string */
  {
    wtextcolor (rand() % 256);
    wvesa_outtextxy (rand() % VESAmode.XResolution, rand() % VESAmode.YResolution, NULL, "SUPER VGA Text!");
  }
  getch();
}


int which_string(int mode)
{
  /* This function simply returns a string number to display based on the
     highlighted video mode */
  switch (mode)
  {
    case V640x400   : return 0; 
    case V640x480   : return 1; 
    case V800x600   : return 2; 
    case V1024x768  : return 3; 
    case V1280x1024 : return 4; 
  }
  return 0;
}


int select_mode (void)
{
  int ctr;
  int done;
  int selected;
  int starty;
  int endy;
  char ch;

  printf ("\nPress ENTER to selected highlighted mode, any other key advances highlight.\n");

  starty = wherey ();				/* Preserve starting y pos */

  for (ctr = 0; ctr < totalmodes; ctr++)	/* Show supported modes */
    printf ("%s\n", vstring[ which_string(videomode[ctr]) ]);
  endy = wherey ();

  selected = 0;
  done = 0;
  while (!done)
  {
    textcolor (LIGHTRED);			/* Highlight string */
    gotoxy (1, starty + selected);
    cprintf ("%s", vstring[ which_string(videomode[selected]) ]);
    ch = getch ();
    if (ch == 13)				/* Abort when ENTER pressed */
      done = 1;
    else {
      textcolor (LIGHTGRAY);			/* De-highlight previous */
      gotoxy (1, starty + selected);
      cprintf ("%s", vstring[ which_string(videomode[selected]) ]);
      selected++;
      if (selected >= totalmodes)		/* Wrap around list */
	selected = 0;
    }
  }
  gotoxy (1, endy);

  return videomode[selected];		/* Return the selected mode */
}


void main(void)
{
  int oldmode;                  /* Video mode before program was started */
  int mymode = 0;               /* Selected video mode */

  oldmode = wgetmode ();        /* Preserve our original video mode */
  clrscr();                     /* Clear the screen */
  if (wvesa_detected())         /* Look for VESA driver */
    printf("SVGA detected.\n");
  else
  {
    printf("SVGA support not found. Please check for VESA driver presence.\n");
    exit(1);
  }

  /* Display the video card maunfacturer's string */
  printf("VIDEO CARD OEM STRING:\n%s\n", VGA.OEMStringPtr);

  getmodes ();                           /* Find supported video modes */

  if (totalmodes == 0)
  {
    printf("256 color SVGA modes not supported. Program aborted.\n");
    exit(1);
  }
  else
  {
    mymode = select_mode ();
  }    

  if (!wvesa_getmodeinfo(mymode))
    printf("Mode detection failed.\n");
  else
  {
    printf("\nMode %x selected.\n\n",mymode);
    printf("X resolution : %5d\nY resolution : %5d\n", VESAmode.XResolution, VESAmode.YResolution);
    printf("Window Granularity : %d\n", VESAmode.WinGranularity);
    printf("Window size in Kb  : %d\n", VESAmode.WinSize);
    if (VESAmode.WinAAttributes & 1 == 0)
      printf("Window A not supported\n");
    else
      printf("Window A Segment   : %x\n", VESAmode.WinASegment);
    if (VESAmode.WinBAttributes & 1 == 0)
      printf("Window B not supported\n");
    else
      printf("Window B Segment   : %x\n", VESAmode.WinBSegment);
  }

  printf("\n\nPRESS ANY KEY TO ENTER GRAPHICS MODE\n");
  getch();

  vga256();
  if (!wvesa_init(mymode))
  {
    printf("Unable to initialize graphics mode.\n");
    exit(1);
  }

//  wvesa_clip (50, 90, 490, 380);	/* Add this line for clipping */

  wgt = wloadblock("wgt1.blk");		/* Load our images */
  wgt2 = wloadblock("wgt2.blk");
  wloadpalette("wgt1.pal", pal);	/* And our palette */
  wsetpalette(0, 255, pal);

  do_pixels ();				/* Perform our demo */
  wvesa_cls (0);

  do_lines ();
  wvesa_cls (1);

  do_bars ();

  do_rectangles ();

  do_blocks ();
  wfreeblock (wgt);			/* Free the images */
  wfreeblock (wgt2);

  do_text ();

  wsetmode(oldmode);			/* Return text mode */
}

