/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 49                        
                                                                            
 This program will show how to use the wfade_between and wfade_between_once 
 commands. It will fade an image between the default palette and the image  
 palette.                                                                   
                                                                            
  PROJECT                                                             
 This program requires the WGT4.LIB file to be linked.                      
                                                                            
  DATA FILES                                                          
 WGT1.BLK and WGT1.PAL must be in the executable directory.                 
                                                                            
ͼ
*/

#include <stdlib.h>
#include <conio.h>
#include <wgt4.h>

void main (void)
{
  block myimage;			/* Pointer to loaded image */
  color desired[256];			/* Image palette */
  color defaultpal[256];		/* First copy of default palette */
  color backup_pal[256];		/* Second copy of default palette */
  int oldmode;				/* Initial video mode */
  int ctr;				/* Loop counter */

  if ( !vgadetected() )
  {
    printf ("Error - VGA card required for any WGT program.\n");
    exit (0);
  }

  oldmode = wgetmode();			/* Store current video mode 	*/
  vga256();				/* Initialize WGT system	*/

  myimage = wloadblock ("wgt1.blk");	/* Load the image */
  wloadpalette ("wgt1.pal", desired);	/* And its palette */
  wreadpalette (0, 255, defaultpal);	/* Store default palette */
  wreadpalette (0, 255, backup_pal);	/* Store backup palette */

  wputblock (0, 0, myimage, NORMAL);	/* And show the image */

  wfade_between (0, 255, 20, defaultpal, desired);	/* Perform fade */
  getch ();

  /* We now need to use backup_pal since defaultpal has been changed to
     the values in "desired" */

  wtextcolor (15);			/* Text is white */
  wtexttransparent (TEXTFGBG);		/* No transparencies */

  for (ctr = 0; ctr < 64; ctr++)	/* Do fades one step at a time */
  {
    wgtprintf (10, 180, NULL, "Fading - step #%d", ctr);
    wfade_between_once (0, 255, desired, backup_pal);	/* Perform fade */
    wsetpalette (0, 255, desired);	/* Show the changes */
    delay (40);				/* Wait for a while */
  }
  getch ();

  wfreeblock (myimage);			/* Deallocate the image */

  wsetmode (oldmode);			/* Reset to text mode */
}