/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 14                        
                                                                            
Demonstrates string input,mouse cursor shape and speed, and                 
wflashcursor, cursor coordinates (xc,yc)                                    
                                                                            
  PROJECT                                                             
 This program requires the file WGT4.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 NONE                                                                       
                                                                            
ͼ
*/

#include <wgt4.h>

color palette[256];
int i;
int px,py,pbut;
int oldmode;

char *charlist=" ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890_.";
	/* this is a list of all the possible characters you can enter
	   with wstring. If the character is not in the list, nothing will
	   happen and the cursor will remain in the same position. */

char *yesno="YNyn";		/* used for yes/no answers only */

char *string;			/* A temporary string variable */


void main(void)
{
  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }
  oldmode = wgetmode();
  vga256();

  wcls(0);
  wtextcolor(15);
  wsetcolor(8);
  wtextbackground(7);
  wtexttransparent(TEXTFGBG);
  /* Both FG and BG are turned on so text will erase itself. */

  /* wstring allows strings to be entered using special keys such as
     the arrow keys, backspace, delete, insert, home and end, etc. */

  string= (char *)malloc(11);		/* remember to add one for
					   the null character. This
					   string is 10 chars long. */

  strcpy(string," ");			/* now make sure it is empty */

  curspeed = 2400;	/* type in a string, try using the special keys */

  wouttextxy(10,1,NULL,"Type in a string: ");
  wstring(150,1,string,charlist,10);

  free(string);				/* now free the memory */

  string = (char *)malloc(2);
  strcpy(string," ");

  /* now try a yes or no answer, try letters other than {YNyn} */
  wouttextxy(10,30,NULL,"Do you want to quit? ");
  wstring(170,30,string,yesno,1);
  free(string);

  wsetcursor(0,7);			/* now do something interactive */
  curspeed = 20;			/* with the mouse */
  minit();
  moff();
  do {
    px = mx;
    py = my;
    pbut = but;
    xc = (px/8) * 8;			/* divide by 8 and multiply by 8 */
    yc = (py/8) * 8;			/* to make 8*8 squares */
    wflashcursor();
    if (but == 1)
    {
      wsetcolor(rand() % 64);
      wline(0,0,xc,yc);		     /* do something with graphics as well */
    }
  } while (!kbhit());
  mdeinit ();                   /* Deinitialize the mouse handler */

  wsetmode(oldmode);
}