{ PATCH.PAS - Patching Turbo's Runtime Library On The Fly }

{$A+   Word Alignment                              }
{$B-   Short-circuit Boolean expression evaluation }
{$D-   Debug information off                       }
{$E-   Disable 80x87 run-time library              }
{$F-   Force Far Calls off                         }
{$G+   80286 instructions                          }
{$I-   I/O checking off                            }
{$L-   Local Symbols off                           }
{$N-   Calc reals by software                      }
{$O-   Overlays not allowed                        }
{$P-   Open string parameters disabled             }
{$Q-   Overflow Check off                          }
{$R-   Range-checking off			   }
{$S-   Stack-checking off			   }
{$T-   Type-Check pointers off                     }
{$V-   Strict Var-String off			   }
{$X+   Extended Syntax on			   }


UNIT	Patch;


	INTERFACE


	IMPLEMENTATION

CONST	dummy		: LongInt = 1;

TYPE	SystemProc	= PROCEDURE;
	SystemCall   	= ^SystemProc; { Pointer to the caller's address }

VAR	CallAddr	: ^SystemCall; { Pointer to the proc to be patched }

{ Copy instruction pointer of caller from the stack }

FUNCTION IPtr : Word;
  INLINE( $8B / $46 / $02 ); { MOV   AX, [ BP+2 ] }


{ This patch speeds up 4-byte signed integer division by 600% }

PROCEDURE DivisionPatch;
CONST	PatchCode : ARRAY[ 0..21 ] OF Byte = (
	   { Push dividend on the stack, pop it in a 32-bits register
	     To avoid division by zero errors, extend it to a quadword }
		   $52,            {  PUSH  DX        }
		   $50,            {  PUSH  AX        }
		   $66, $58,       {  POP   EAX       }
		   $66, $99,       {  CDQ             }
	   { Push divisor on the stack, pop it in a 32-bit register.
	     Perform the division }
		   $53,            {  PUSH  BX        }
		   $51,            {  PUSH  CX        }
		   $66, $5E,       {  POP   ESI       }
		   $66, $F7, $FE,  {  IDIV  ESI       }
	   { Push remainder on the stack, pop it in 16-bits registers }
		   $66, $52,       {  PUSH  EDX       }
		   $59,            {  POP   CX        }
		   $5B,            {  POP   BX        }
	   { Push quotient on the stack, pop it in 16-bits registers }
		   $66, $50,       {  PUSH  EAX       }
		   $58,            {  POP   AX        }
		   $5A,            {  POP   DX        }
		   $CB );          {  RETF            }
BEGIN
  CallAddr := Ptr( CSeg, IPtr - 14 );
  Move( PatchCode, CallAddr^^, SizeOf( PatchCode ));
END;  { LongIntDivisionPatch }


{ Provided the product > 2^16, this patch speeds up 4-byte signed integer
   multiplication by 5%  }

PROCEDURE MultiplyPatch;
CONST	PatchCode : ARRAY[ 0..15 ] OF Byte = (
	   { Push first operand on the stack, pop it in a 32-bits register }
		   $52,            {  PUSH  DX        }
		   $50,            {  PUSH  AX        }
		   $66, $58,       {  POP   EAX       }
	   { Push second operand on the stack, pop it in a 32-bits register
	     Perform the multiplication }
		   $53,            {  PUSH  BX        }
		   $51,            {  PUSH  CX        }
		   $66, $5A,       {  POP   EDX       }
		   $66, $F7, $EA,  {  IMUL  EDX       }
	   { Push product on the stack, pop it in 16-bits registers }
		   $66, $50,       {  PUSH  EAX       }
		   $58,            {  POP   AX        }
		   $5A,            {  POP   DX        }
		   $CB );          {  RETF            }
BEGIN
  CallAddr := Ptr( CSeg, IPtr - 14 );
  Move( PatchCode, CallAddr^^, SizeOf( PatchCode ));
END;  { MultiplyPatch }


{ Shift directly across multiple words, rather than in a loop }

PROCEDURE ShiftLeftPatch;
CONST	PatchCode : ARRAY[ 0..3 ] OF Byte = (
		   $0F, $A5, $C2,  {  SHLD DX, AX, CL }
		   $CB );          {  RETF            }
BEGIN
  CallAddr := Ptr( CSeg, IPtr - 14 );
  Move( PatchCode, CallAddr^^, SizeOf( PatchCode ));
END;  { ShiftLeftPatch }


{ Shift directly across multiple words, rather than in a loop }

PROCEDURE ShiftRightPatch;
CONST	PatchCode : ARRAY[ 0..3 ] OF Byte = (
		   $0F, $AD, $C2,  {  SHRD DX, AX, CL }
		   $CB );          {  RETF            }
BEGIN
  CallAddr := Ptr( CSeg, IPtr - 14 );
  Move( PatchCode, CallAddr^^, SizeOf( PatchCode ));
END;  { ShiftRightPatch }

BEGIN  { Patch }
  IF Test8086 >= 2 THEN                        { It's a 32-bitter }
    BEGIN
      dummy := dummy DIV dummy;
      DivisionPatch;
      dummy := dummy * dummy;
      MultiplyPatch;
      dummy := dummy SHL 1;
      ShiftLeftPatch;
      dummy := dummy SHR 1;
      ShiftRightPatch;
    END
END.  { Patch }

{
George Kalemanis
}

