/*  Copyright 1986 by Carnegie Mellon  */
/*  See permission and disclaimer notice in file "cmu-note.h"  */
#include	<cmu-note.h>
/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
#include	<notice.h>

#include <stdio.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>
#include <timer.h>
#include "sl.h"

/* This file contains the initialization code for the SLIP net for
 * the PC's.  SL_INIT() has to initialize the serial port, perhaps fill in
 * some of its net struct and fork the serial line packet to protocol
 * demultiplexor.  Changed 4/6/85 to use consistent error return codes
 * from sl_write, and to assign a distinctive IP address (177,177,177,177)
 *					<J. H. Saltzer>
 */

NET	*sl_net;	/* Serial line net descriptor */
Task	SlDemux;	/* The packet-to-protocol demultiplexor. */
extern int sl_demux();	/* "		"		" 	 */


sl_init(net, baud, dummy)
	NET *net;
	unsigned baud;
	unsigned dummy;
{
	PACKET p;
	timer *tm;

#ifdef	DEBUG
	if(NDEBUG & INFOMSG)
		printf("Forking SLDEMUX.\n");
#endif

	SlDemux = tk_fork(tk_cur, sl_demux, net->n_stksiz, "SLDEMUX");
	if(SlDemux == NULL) {
		printf("Error: SLIP setup failed\n");
		exit(1);
	}

	sl_net = net;
	net->n_demux = SlDemux;

	/* patch in a bogus gateway address so the internet router
	 *	doesn't complain.
	 */
	net->n_defgw = 0x01020304;

	/*
	 * Allocate a buffer for the receiver.
	 */
	if((sl_buff = getfree()) == nullbuf)
		slref++;
	else
		sl_cp = sl_buff->nb_prot;	/* Find buffer */

	baud = custom.c_baud;
	if(baud == 0) {
		printf("The data rate has not been customized! You should ");
		printf("set it using the customizer\nand try again.\n");
		exit(1);
	}

	sl_switch(1, baud);

	tk_yield();		/* Give the per net task a chance to run. */

	return;
}


/*
 * Routine to switch the board and interrupts on/off.
 */
sl_switch(state, baud)
int state;
unsigned baud;
{
    if(state) { 	/* Turn them on? */
#ifdef	DEBUG
	if(NDEBUG & INFOMSG)
		printf("Initializing Serial Port.\n");
#endif

	init_aux(baud);		/* initialize the serial port */
    }
    else sl_close();	/* Let et_close do the work */
}

